/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel;

import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourcePanelComponentFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class WidgetDataSourcePanel
extends AbstractConfigurationPanel {
    private Panel activitiesPanel;
    private WidgetDataSourcePanelComponentFactory componentFactory;
    private Panel dataTypePanel;
    private Panel dimensionsPanel;
    private Panel measurementPanel;
    private Panel namePanel;
    private Panel ouProcessChooser;

    public WidgetDataSourcePanel(UiContainer parent, WidgetModel widgetModel) {
        super(parent, DesignerMsg.DATA_SOURCE);
        this.componentFactory = new WidgetDataSourcePanelComponentFactory(widgetModel);
        this.activitiesPanel = new Panel((UiContainer)this, UIMsg.TO_MSG((String)""));
        this.componentFactory.setActivitiesPanel(this.activitiesPanel);
        this.dataTypePanel = new Panel((UiContainer)this, UIMsg.TO_MSG((String)""));
        this.componentFactory.setDataTypePanel(this.dataTypePanel);
        this.dimensionsPanel = new Panel((UiContainer)this, DesignerMsg.DIMENSIONS);
        this.componentFactory.setDimensionsPanel(this.dimensionsPanel);
        this.measurementPanel = new Panel((UiContainer)this, UIMsg.TO_MSG((String)""));
        this.componentFactory.setMeasurementPanel(this.measurementPanel);
        this.namePanel = new Panel((UiContainer)this, UIMsg.TO_MSG((String)""));
        this.componentFactory.setNamePanel(this.namePanel);
        this.ouProcessChooser = new Panel((UiContainer)this, UIMsg.TO_MSG((String)""));
        this.componentFactory.setOuProcessChooser(this.ouProcessChooser);
        this.componentFactory.init(this);
        this.initGui();
    }

    public void reloadTitle() {
        this.componentFactory.reloadTitle();
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.componentFactory.setModel(widgetModel);
    }

    public void guessTypeBasedOnDimensions() {
        this.componentFactory.guessType();
    }

    private Panel buildActivitiesPanel() {
        String columns = "max(50dlu;pref), 4dlu, fill:100dlu, 4dlu, fill:100dlu";
        String rows = "pref, 2dlu, pref, 2dlu, pref";
        FormLayout layout = new FormLayout("max(50dlu;pref), 4dlu, fill:100dlu, 4dlu, fill:100dlu", "pref, 2dlu, pref, 2dlu, pref");
        CellConstraints cc = new CellConstraints();
        this.activitiesPanel.setLayout((Layout)layout);
        RadioButton activityRadioButton = this.componentFactory.getActivityRadioButton();
        RadioButton allActivitiesRadioButton = this.componentFactory.getAllActivitiesRadioButton();
        this.activitiesPanel.add((UiComponent)activityRadioButton, (Object)cc.xy(1, 1));
        this.activitiesPanel.add((UiComponent)this.componentFactory.getActivitiesCombo(), (Object)cc.xy(3, 1));
        this.activitiesPanel.add((UiComponent)allActivitiesRadioButton, (Object)cc.xywh(1, 3, 3, 1));
        return this.activitiesPanel;
    }

    private Panel buildDataTypePanel() {
        String columns = "max(50dlu;pref), 4dlu, pref";
        String rows = "pref, 2dlu, pref, 2dlu, pref";
        FormLayout layout = new FormLayout("max(50dlu;pref), 4dlu, pref", "pref, 2dlu, pref, 2dlu, pref");
        CellConstraints cc = new CellConstraints();
        this.dataTypePanel.setLayout((Layout)layout);
        RadioButton workloadRadio = this.componentFactory.getWorkloadRadio();
        RadioButton activityPerformanceRadio = this.componentFactory.getActivityPerformanceRadio();
        RadioButton processPerformanceRadio = this.componentFactory.getProcessPerformanceRadio();
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)workloadRadio);
        group.add((AbstractButton)activityPerformanceRadio);
        group.add((AbstractButton)processPerformanceRadio);
        this.dataTypePanel.add((UiComponent)Label.create((UiContainer)this.dataTypePanel, (Msg)DesignerMsg.DATA_TYPE), (Object)cc.xy(1, 1));
        this.dataTypePanel.add((UiComponent)workloadRadio, (Object)cc.xy(3, 1));
        this.dataTypePanel.add((UiComponent)activityPerformanceRadio, (Object)cc.xy(3, 3));
        this.dataTypePanel.add((UiComponent)processPerformanceRadio, (Object)cc.xy(3, 5));
        return this.dataTypePanel;
    }

    private Panel buildDimensionsPanel() {
        this.dimensionsPanel.setLayout((Layout)new BorderLayout());
        this.dimensionsPanel.add((UiComponent)this.componentFactory.getDimensionChooser(), (Object)"Center");
        return this.dimensionsPanel;
    }

    private Panel buildMeasurementsPanel() {
        String columns = "max(50dlu;pref), 4dlu, fill:100dlu, 8dlu, pref, fill:2dlu:g(0.2)";
        String rows = "pref, fill:4dlu:g(0.2), pref, fill:7dlu:g(0.2), pref, fill:4dlu:g(0.2), pref";
        FormLayout layout = new FormLayout("max(50dlu;pref), 4dlu, fill:100dlu, 8dlu, pref, fill:2dlu:g(0.2)", "pref, fill:4dlu:g(0.2), pref, fill:7dlu:g(0.2), pref, fill:4dlu:g(0.2), pref");
        CellConstraints cc = new CellConstraints();
        this.measurementPanel.setLayout((Layout)layout);
        this.measurementPanel.add((UiComponent)Label.create((UiContainer)this.measurementPanel, (Msg)DesignerMsg.MEASURES), (Object)cc.xy(1, 1));
        this.measurementPanel.add((UiComponent)this.componentFactory.getMeasurementsCombo(), (Object)cc.xy(3, 1));
        this.measurementPanel.add((UiComponent)Label.create((UiContainer)this.measurementPanel, (Msg)DesignerMsg.OPERATION_TYPE), (Object)cc.xy(1, 3));
        this.measurementPanel.add((UiComponent)this.componentFactory.getOperationTypePanel(), (Object)cc.xywh(3, 3, 4, 1));
        this.measurementPanel.add((UiComponent)Label.create((UiContainer)this.measurementPanel, (Msg)DesignerMsg.VALUE_TYPE), (Object)cc.xy(1, 5, "left, top"));
        this.measurementPanel.add((UiComponent)this.componentFactory.getValueTypePanel(), (Object)cc.xywh(3, 5, 4, 1));
        return this.measurementPanel;
    }

    private Panel buildNamePanel() {
        String columns = "max(50dlu;pref), 4dlu, fill:100dlu, 5dlu, pref";
        String rows = "pref, 4dlu, pref";
        FormLayout layout = new FormLayout("max(50dlu;pref), 4dlu, fill:100dlu, 5dlu, pref", "pref, 4dlu, pref");
        CellConstraints cc = new CellConstraints();
        this.namePanel.setLayout((Layout)layout);
        this.namePanel.add((UiComponent)Label.create((UiContainer)this.namePanel, (Msg)DesignerMsg.NAME), (Object)cc.xy(1, 1));
        this.namePanel.add((UiComponent)this.componentFactory.getNameTextField(), (Object)cc.xy(3, 1));
        this.namePanel.add((UiComponent)Label.create((UiContainer)this.namePanel, (Msg)DesignerMsg.TITLE), (Object)cc.xy(1, 3));
        this.namePanel.add((UiComponent)this.componentFactory.getTitleTextField(), (Object)cc.xy(3, 3));
        this.namePanel.add((UiComponent)this.componentFactory.getLocalizationButtonForTitle((UiContainer)this.namePanel), (Object)cc.xy(5, 3));
        return this.namePanel;
    }

    private void initGui() {
        String columns = "fill:0dlu:g(0.5), pref, fill:2dlu:g(0.2), pref, fill:0dlu:g(0.5)";
        String rows = "fill:2dlu:g(0.5), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.5)";
        FormLayout layout = new FormLayout("fill:0dlu:g(0.5), pref, fill:2dlu:g(0.2), pref, fill:0dlu:g(0.5)", "fill:2dlu:g(0.5), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.5)");
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        this.add((UiComponent)this.buildNamePanel(), cc.xy(2, 2));
        this.add(this.buildOuProcessChooser(), cc.xy(2, 4));
        this.add((UiComponent)this.buildDataTypePanel(), cc.xy(2, 6));
        this.add((UiComponent)this.buildActivitiesPanel(), cc.xy(2, 8));
        this.add((UiComponent)this.buildDimensionsPanel(), cc.xy(2, 10));
        this.add((UiComponent)this.buildMeasurementsPanel(), cc.xy(2, 12));
    }

    private UiComponent buildOuProcessChooser() {
        String columns = "max(50dlu;pref), 4dlu, fill:100dlu, 4dlu, fill:100dlu";
        String rows = "pref";
        FormLayout layout = new FormLayout(columns, rows);
        this.ouProcessChooser.setLayout((Layout)layout);
        CellConstraints cc = new CellConstraints();
        this.ouProcessChooser.add((UiComponent)this.componentFactory.getProcessesIdentifier(), (Object)cc.xy(1, 1));
        this.ouProcessChooser.add((UiComponent)this.componentFactory.getProcessCombo(), (Object)cc.xy(3, 1));
        return this.ouProcessChooser;
    }

    public class ChangeEditingModeAction
    extends DesignerAction {
        boolean advancedMode;

        public ChangeEditingModeAction() {
            super(DesignerMsg.ADVANCED_MODE);
        }

        @Override
        public boolean doIt() {
            this.advancedMode = !this.advancedMode;
            this.setAdvancedMessage();
            return true;
        }

        public void setAdvancedMessage() {
            Msg msg = this.advancedMode ? DesignerMsg.BASIC_MODE : DesignerMsg.ADVANCED_MODE;
            this.setMsg(msg);
        }

        public void unDoIt() {
        }

        public void setMode(boolean advancedMode) {
            this.advancedMode = advancedMode;
            this.setAdvancedMessage();
        }
    }
}

