/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel;

import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourcePanelComponentFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;

public class WidgetDataSourceLoader {
    private WidgetDataSourcePanelComponentFactory componentFactory;
    private Project project;

    public WidgetDataSourceLoader(WidgetDataSourcePanelComponentFactory componentFactory, Project project) {
        this.componentFactory = componentFactory;
        this.project = project;
    }

    public void loadNameAndTitle() {
        this.componentFactory.nameTextField.setText(this.componentFactory.widgetPresentationModel.getName());
        this.componentFactory.titleTextField.setText(this.componentFactory.widgetPresentationModel.getTitle());
    }

    public void loadValueType() {
        Measurement measurement = this.componentFactory.widgetDataModel.getMeasurement();
        WidgetValueType widgetValueType = this.componentFactory.widgetDataModel.getValueType();
        if (widgetValueType != null) {
            this.componentFactory.valueTypePanel.selectEnum((Enum)widgetValueType);
            WidgetType type = this.componentFactory.widgetDataModel.getType();
            this.componentFactory.enableValues(type.equals((Object)WidgetType.ACTIVITY_PERFORMANCE) || type.equals((Object)WidgetType.ALL_ACTIVITIES_PERFORMANCE) || type.equals((Object)WidgetType.PROCESS_PERFORMANCE));
            this.componentFactory.updateMeasurementsCombo(measurement);
            this.componentFactory.measurementsCombo.setSelectedItem(measurement);
        }
    }

    void reloadActivitiesCombo() {
        boolean reloadDimensions;
        WidgetDataModel widgetDataModel = this.componentFactory.widgetDataModel;
        Process process = this.project.findProcess(widgetDataModel.getProcessId());
        if (process != null) {
            FlowNode selectedNode = process.findNode(widgetDataModel.getActivityId());
            this.componentFactory.activitiesCombo.load(process, widgetDataModel.getType());
            this.componentFactory.activitiesCombo.setSelectedItem(selectedNode);
        }
        boolean bl = reloadDimensions = this.componentFactory.activitiesCombo.getSelectedItem() == null && (!this.componentFactory.isAllActivitiesRadioSelected() || widgetDataModel.getType().equals((Object)WidgetType.PROCESS_PERFORMANCE));
        if (reloadDimensions) {
            // empty if block
        }
    }

    void loadOperation() {
        OperationType operationType;
        Measurement measurement = this.componentFactory.widgetDataModel.getMeasurement();
        if (measurement != null && (operationType = measurement.getOperationType()) != null) {
            this.componentFactory.operationTypePanel.selectEnum((Enum)operationType);
            this.componentFactory.updateMeasurementsCombo(measurement);
            this.componentFactory.measurementsCombo.setSelectedItem(measurement);
        }
    }

    void loadMeasure() {
        WidgetDataModel widgetDataModel = this.componentFactory.widgetDataModel;
        Process process = this.project.findProcess(widgetDataModel.getProcessId());
        if (process != null) {
            this.componentFactory.measurementsCombo.reload(widgetDataModel.getType(), process);
            this.componentFactory.measurementsCombo.setSelectedItem(widgetDataModel.getMeasurement());
        }
    }

    void loadDimensions() {
        WidgetType type = this.componentFactory.widgetDataModel.getType();
        if (!type.isOuType()) {
            int dimensionsQuantity;
            this.componentFactory.dimensionChooser.reload();
            List dimensions = this.componentFactory.widgetDataModel.getDimensions();
            int dimensionsSize = dimensions.size();
            if (dimensionsSize > 0) {
                this.componentFactory.dimensionChooser.setSelectedXDimension((Dimension)dimensions.get(0));
                if (dimensionsSize > 1) {
                    this.componentFactory.dimensionChooser.setSelectedSeriesDimension((Dimension)dimensions.get(1));
                }
            }
            boolean moreThanOneDimension = (dimensionsQuantity = this.componentFactory.dimensionChooser.getDimensionsQuantity()) > 0;
            this.componentFactory.valueTypePanel.enableEnum((Enum)WidgetValueType.PERCENTAGE, moreThanOneDimension);
        }
    }

    void loadActivity() {
        WidgetDataModel widgetDataModel = this.componentFactory.widgetDataModel;
        Process process = this.project.findProcess(widgetDataModel.getProcessId());
        this.componentFactory.activitiesCombo.load(process, widgetDataModel.getType());
        if (process != null) {
            FlowNode selectedNode = process.findNode(this.componentFactory.widgetDataModel.getActivityId());
            this.componentFactory.activitiesCombo.setSelectedItem(selectedNode);
        }
    }

    void loadType() {
        WidgetType type = this.componentFactory.widgetDataModel.getType();
        boolean allActivitiesPerformance = WidgetType.ALL_ACTIVITIES_PERFORMANCE.equals((Object)type);
        boolean allActivitiesWorkload = WidgetType.ALL_ACTIVITIES_WORKLOAD.equals((Object)type);
        boolean activityWorkload = WidgetType.ACTIVITY_WORKLOAD.equals((Object)type);
        boolean activityPerformance = WidgetType.ACTIVITY_PERFORMANCE.equals((Object)type);
        this.componentFactory.allActivitiesRadioButton.setSelected(allActivitiesPerformance || allActivitiesWorkload);
        this.componentFactory.activityRadioButton.setSelected(activityWorkload || activityPerformance);
        this.componentFactory.workloadRadio.setSelected(activityWorkload || allActivitiesWorkload);
        this.componentFactory.activityPerformanceRadio.setSelected(activityPerformance || allActivitiesPerformance);
        boolean processPerformance = WidgetType.PROCESS_PERFORMANCE.equals((Object)type);
        this.componentFactory.processPerformanceRadio.setSelected(processPerformance);
        this.componentFactory.activityRadioButton.setEnabled(!processPerformance);
        this.componentFactory.allActivitiesRadioButton.setEnabled(!processPerformance);
        this.componentFactory.activitiesCombo.setEnabled(!processPerformance);
    }

    void loadProcessOrOu() {
        Process selectedProcess = this.project.findProcess(this.componentFactory.widgetDataModel.getProcessId());
        this.componentFactory.processCombo.setSelectedItem((Object)selectedProcess);
    }

    boolean shouldReloadTableBasedOnProcess() {
        return this.componentFactory.allActivitiesRadioButton.isSelected() || this.componentFactory.activitiesCombo.getSelectedItem() != null || this.componentFactory.widgetDataModel.getType().equals((Object)WidgetType.PROCESS_PERFORMANCE);
    }
}

