/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel;

import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.OperationType;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.designer.dashboardwizards.components.MeasurementsCombo;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourcePanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourcePanelComponentFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;

public class WidgetDataSourceListenerManager {
    private WidgetDataSourcePanelComponentFactory componentFactory;
    private boolean doFireEvents;
    private Project project;

    public WidgetDataSourceListenerManager(WidgetDataSourcePanelComponentFactory widgetDataSourcePanelComponentFactory, Project project) {
        this.componentFactory = widgetDataSourcePanelComponentFactory;
        this.project = project;
    }

    public boolean doFireEvents() {
        return this.doFireEvents;
    }

    public void setDoFireEvents(boolean doFireEvents) {
        this.doFireEvents = doFireEvents;
    }

    public void addListenerToMeasurementsCombo(MeasurementsCombo measurementsCombo) {
        measurementsCombo.addItemListener(new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setMeasurement((Measurement)e.getItem());
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.operationTypePanel.selectEnum((Enum)OperationType.SUM);
            }
        });
    }

    public void addListenerToOusCombo(ComboBox ousCombo) {
        ousCombo.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
            }
        });
    }

    void addListenerToActivitiesCombo() {
        this.componentFactory.activitiesCombo.addItemListener(new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                Process selectedProcess = WidgetDataSourceListenerManager.this.project.findProcess(((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getProcessId());
                if (selectedProcess != null) {
                    ProjectObject projectElement = (ProjectObject)e.getItem();
                    WidgetDataSourceListenerManager.this.componentFactory.storeActivityIdToDataModel(projectElement);
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.dimensionChooser.reload();
                    if (((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.measurementsCombo != null) {
                        ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.measurementsCombo.reload(((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getType(), projectElement, selectedProcess);
                    }
                }
            }
        });
    }

    void addListenerToActivitiesRadioButton() {
        this.componentFactory.activityRadioButton.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                WidgetType widgetType = ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getType();
                if (((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.workloadRadio.isSelected()) {
                    widgetType = WidgetType.ACTIVITY_WORKLOAD;
                }
                if (((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activityPerformanceRadio.isSelected()) {
                    widgetType = WidgetType.ACTIVITY_PERFORMANCE;
                }
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setType(widgetType);
                WidgetDataSourceListenerManager.this.componentFactory.changeWidgetType(true);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activitiesCombo.setSelectedItem(null);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activitiesCombo.setEnabled(true);
            }
        });
    }

    void addListenerToActivityPerformanceRadio(final WidgetDataSourcePanel dataSourcePanel) {
        this.componentFactory.activityPerformanceRadio.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                WidgetType widgetType = WidgetDataSourceListenerManager.this.componentFactory.isAllActivitiesRadioSelected() ? WidgetType.ALL_ACTIVITIES_PERFORMANCE : WidgetType.ACTIVITY_PERFORMANCE;
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setType(widgetType);
                WidgetDataSourceListenerManager.this.componentFactory.changeWidgetType(false);
                if (WidgetDataSourceListenerManager.this.componentFactory.isAllActivitiesRadioSelected()) {
                    WidgetDataSourceListenerManager.this.componentFactory.changeWidgetType(WidgetDataSourceListenerManager.this.componentFactory.isAllActivitiesRadioSelected());
                } else {
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.loader.reloadActivitiesCombo();
                }
                WidgetDataSourceListenerManager.this.componentFactory.enableValues(true);
                dataSourcePanel.fireDataChanged();
            }
        });
    }

    void addListenerToDimensionsTableModel(final WidgetDataSourcePanel dataSourcePanel) {
        this.componentFactory.dimensionChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                dataSourcePanel.fireDataChanged();
                if (((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.valueTypePanel != null) {
                    boolean moreThanOneDimension = ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.dimensionChooser.getDimensionQuantity() > 0;
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.valueTypePanel.enableEnum((Enum)WidgetValueType.PERCENTAGE, moreThanOneDimension);
                }
            }
        });
        List<Dimension> dimensions = this.componentFactory.getDimensionChooser().getDimensions();
        if (dimensions.size() > 0) {
            this.componentFactory.widgetDataModel.asMutable().setDimensions(dimensions);
        }
    }

    void addListenerToProcessCombo() {
        this.componentFactory.processCombo.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                Process process = (Process)e.getItem();
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setProcessId(process.getId());
                if (!((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getType().equals((Object)WidgetType.PROCESS_PERFORMANCE)) {
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.loader.reloadActivitiesCombo();
                } else {
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.dimensionChooser.reload();
                }
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setProcessId(process.getId());
            }
        });
    }

    void addListenerToProcessesRadio() {
        this.componentFactory.processesRadio.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doAlways(ItemEvent e) {
                boolean selected = e.isStateSelected();
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activityRadioButton.setSelected(true);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.processCombo.setEnabled(selected);
                if (!selected) {
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.processCombo.setSelectedItem(null);
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setProcessId(null);
                }
            }
        });
    }

    void addListenerToProcessPerformanceRadio(final WidgetDataSourcePanel dataSourcePanel) {
        this.componentFactory.processPerformanceRadio.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doAlways(ItemEvent e) {
                boolean selected = e.isStateSelected();
                WidgetType widgetType = WidgetType.PROCESS_PERFORMANCE;
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setType(widgetType);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.invisibleProcessRadioButton.setSelected(selected);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.allActivitiesRadioButton.setEnabled(!selected);
                boolean ouType = ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getType().isOuType();
                boolean enable = !ouType && !selected;
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activityRadioButton.setEnabled(enable);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activitiesCombo.setEnabled(enable);
                if (!enable) {
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activitiesCombo.setSelectedItem(null);
                }
                WidgetDataSourceListenerManager.this.componentFactory.changeWidgetType(true);
                if (!selected) {
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activityRadioButton.setSelected(!ouType);
                }
                WidgetDataSourceListenerManager.this.componentFactory.enableValues(true);
                dataSourcePanel.fireDataChanged();
            }
        });
    }

    void addListenerToTitleTextField(final WidgetDataSourcePanel dataSourcePanel) {
        this.componentFactory.titleTextField.addDocumentListener((DocumentListener)new WidgetDataSourceDocumentListener(){

            public void update() {
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetPresentationModel.asMutable().setTitle(((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.titleTextField.getText());
                dataSourcePanel.fireDataChanged();
            }
        });
    }

    void addListenerToWorkloadRadioButton(final WidgetDataSourcePanel dataSourcePanel) {
        this.componentFactory.workloadRadio.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                boolean allSelected = WidgetDataSourceListenerManager.this.componentFactory.isAllActivitiesRadioSelected();
                WidgetType widgetType = allSelected ? WidgetType.ALL_ACTIVITIES_WORKLOAD : WidgetType.ACTIVITY_WORKLOAD;
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setType(widgetType);
                WidgetDataSourceListenerManager.this.componentFactory.changeWidgetType(allSelected);
                WidgetDataSourceListenerManager.this.componentFactory.enableValues(false);
                dataSourcePanel.fireDataChanged();
            }
        });
    }

    void addListenerToAllActivitiesRadioButton() {
        this.componentFactory.allActivitiesRadioButton.addItemListener((ItemListener)new WidgetDataSourceItemListener(){

            @Override
            public void doOnSelection(ItemEvent e) {
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activitiesCombo.setSelectedItem(null);
                ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.activitiesCombo.setEnabled(false);
                WidgetType widgetType = ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getType();
                if (!widgetType.isOuType()) {
                    widgetType = ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.getType().equals((Object)WidgetType.ACTIVITY_WORKLOAD) ? WidgetType.ALL_ACTIVITIES_WORKLOAD : WidgetType.ALL_ACTIVITIES_PERFORMANCE;
                    ((WidgetDataSourceListenerManager)WidgetDataSourceListenerManager.this).componentFactory.widgetDataModel.asMutable().setType(widgetType);
                }
                WidgetDataSourceListenerManager.this.componentFactory.changeWidgetType(true);
            }
        });
    }

    private class WidgetDataSourceTableModelListener
    implements TableModelListener {
        private WidgetDataSourceTableModelListener() {
        }

        public void changed(TableModelEvent e) {
        }

        public void tableChanged(TableModelEvent e) {
            if (WidgetDataSourceListenerManager.this.doFireEvents) {
                this.changed(e);
            }
        }
    }

    private abstract class WidgetDataSourceItemListener
    implements ItemListener {
        private WidgetDataSourceItemListener() {
        }

        public void doOnSelection(ItemEvent e) {
        }

        public void doOnDeselection(ItemEvent e) {
        }

        public void doAlways(ItemEvent e) {
        }

        public void itemStateChanged(ItemEvent e) {
            if (WidgetDataSourceListenerManager.this.doFireEvents) {
                if (e.isStateSelected()) {
                    this.doOnSelection(e);
                }
                if (e.isStateDeselected()) {
                    this.doOnDeselection(e);
                }
                this.doAlways(e);
            }
        }
    }

    private abstract class WidgetDataSourceDocumentListener
    implements DocumentListener {
        private WidgetDataSourceDocumentListener() {
        }

        public void update(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (WidgetDataSourceListenerManager.this.doFireEvents) {
                this.update(e);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (WidgetDataSourceListenerManager.this.doFireEvents) {
                this.update(e);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            if (WidgetDataSourceListenerManager.this.doFireEvents) {
                this.update(e);
            }
        }
    }
}

