/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.designer.dashboardwizards.components.FontPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.TextField;

public class WidgetTitlePropertiesPanel
extends AbstractConfigurationPanel {
    private boolean doFireChangeEvents;
    private boolean doNotFireInternalEvents;
    private FontPanel fontPanel;
    private Label titleLabel;
    private TextField titleTextField;
    private WidgetPresentationModel widgetPresentationModel;

    public WidgetTitlePropertiesPanel(UiContainer parent, WidgetPresentationModel widgetPresentationModel) {
        super(parent, DesignerMsg.WIDGET_TITLE);
        this.widgetPresentationModel = widgetPresentationModel;
        this.buildTitleTextField();
        this.buildFontPanel();
        this.layoutComponents();
        this.load();
        this.doFireChangeEvents = true;
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        this.doNotFireInternalEvents = true;
        this.load();
        this.doNotFireInternalEvents = false;
    }

    protected void reload() {
        this.doFireChangeEvents = false;
        this.load();
        this.doFireChangeEvents = true;
    }

    private void buildFontPanel() {
        this.fontPanel = new FontPanel((UiContainer)this, Font.valueOf((FontInfo)this.widgetPresentationModel.getTitleFont()), Color.valueOf((ColorInfo)this.widgetPresentationModel.getTitleBackgroundColor()), Color.valueOf((ColorInfo)this.widgetPresentationModel.getTitleForegroundColor()));
        this.fontPanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!WidgetTitlePropertiesPanel.this.doNotFireInternalEvents) {
                    WidgetTitlePropertiesPanel.this.widgetPresentationModel.asMutable().setTitleFont(WidgetTitlePropertiesPanel.this.fontPanel.getCurrentFont().getInfo());
                    WidgetTitlePropertiesPanel.this.widgetPresentationModel.asMutable().setTitleBackgroundColor(WidgetTitlePropertiesPanel.this.fontPanel.getBackgroundColor().getInfo());
                    WidgetTitlePropertiesPanel.this.widgetPresentationModel.asMutable().setTitleForegroundColor(WidgetTitlePropertiesPanel.this.fontPanel.getForegroundColor().getInfo());
                }
            }
        });
    }

    private void buildTitleTextField() {
        this.titleLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.TITLE);
        this.titleTextField = new TextField((UiContainer)this, 20);
        this.titleTextField.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.changeTitle();
            }

            public void removeUpdate(DocumentEvent e) {
                this.changeTitle();
            }

            public void changedUpdate(DocumentEvent e) {
                this.changeTitle();
            }

            private void changeTitle() {
                if (!WidgetTitlePropertiesPanel.this.doNotFireInternalEvents) {
                    WidgetTitlePropertiesPanel.this.fontPanel.changePreviewedText(WidgetTitlePropertiesPanel.this.titleTextField.getText());
                    WidgetTitlePropertiesPanel.this.widgetPresentationModel.asMutable().setTitle(WidgetTitlePropertiesPanel.this.titleTextField.getText());
                }
                if (WidgetTitlePropertiesPanel.this.doFireChangeEvents) {
                    WidgetTitlePropertiesPanel.this.fireDataChanged();
                }
            }
        });
    }

    private void layoutComponents() {
        String columns = "fill:0dlu:grow, pref, 3dlu, fill:pref:grow, fill:0dlu:grow";
        String rows = "fill:2dlu:grow, pref, 2dlu, pref, fill:2dlu:grow";
        FormLayout layout = new FormLayout("fill:0dlu:grow, pref, 3dlu, fill:pref:grow, fill:0dlu:grow", "fill:2dlu:grow, pref, 2dlu, pref, fill:2dlu:grow");
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        this.add((UiComponent)this.titleLabel, cc.xy(2, 2));
        this.add((UiComponent)this.titleTextField, cc.xy(4, 2));
        this.add((UiComponent)this.fontPanel, cc.xywh(2, 4, 3, 1));
    }

    private void load() {
        FontInfo titleFont;
        String title = this.widgetPresentationModel.getTitle();
        if (title != null) {
            this.titleTextField.setText(title);
        }
        if ((titleFont = this.widgetPresentationModel.getTitleFont()) != null) {
            this.fontPanel.setCurrentFont(Font.valueOf((FontInfo)titleFont));
            this.fontPanel.setBackgroundColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getTitleBackgroundColor()));
            this.fontPanel.setForegroundColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getTitleForegroundColor()));
        }
    }
}

