/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.designer.dashboardwizards.WidgetPanelEnabler;
import oracle.bpm.designer.dashboardwizards.components.FontPanel;
import oracle.bpm.designer.dashboardwizards.components.WidgetSeriesColorPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

public class WidgetSeriesPropertiesPanel
extends AbstractConfigurationPanel {
    private ComboBox dataLabelFormatCombo;
    private Label dataLabelFormatLabel;
    private boolean doFireEvents;
    private FontPanel fontPanel;
    private WidgetSeriesColorPanel seriesColorTable;
    private WidgetPresentationModel widgetPresentationModel;

    public WidgetSeriesPropertiesPanel(UiContainer parent, WidgetPresentationModel model) {
        super(parent, DesignerMsg.SERIES);
        this.widgetPresentationModel = model;
        this.initGui();
        this.doFireEvents = true;
    }

    public void setDataLabelEnabled(boolean enabled) {
        this.dataLabelFormatLabel.setEnabled(enabled);
        this.dataLabelFormatCombo.setEnabled(enabled);
    }

    public boolean isDataLabelFormatEnabled() {
        return this.dataLabelFormatCombo.isEnabled();
    }

    public void setSeriesEnabled(boolean enabled) {
        this.seriesColorTable.setEnabled(enabled);
        this.fontPanel.enableForegroundColor(!enabled);
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.doFireEvents = false;
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        WidgetPanelEnabler.enable(this, this.widgetPresentationModel);
        this.load();
        this.doFireEvents = true;
    }

    private void buildDataLabelFormatCombo() {
        StringList dataLabelFormatList = StringList.create();
        dataLabelFormatList.add("");
        dataLabelFormatList.add("{0} = {1}");
        dataLabelFormatList.add("{0}");
        dataLabelFormatList.add("{1}");
        this.dataLabelFormatCombo = UiFactory.createComboBox((UiContainer)this, (List)dataLabelFormatList);
        this.dataLabelFormatCombo.setLabelProvider((LabelProvider)new DataLabelProvider());
    }

    private void load() {
        this.dataLabelFormatCombo.setSelectedItem((Object)this.widgetPresentationModel.getDataLabelFormat());
        this.fontPanel.setCurrentFont(Font.valueOf((FontInfo)this.widgetPresentationModel.getSeriesDataLabelFont()));
        this.fontPanel.setForegroundColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getSeriesDataLabelColor()));
        this.seriesColorTable.reload(this.widgetPresentationModel);
        this.dataLabelFormatCombo.setSelectedItem((Object)this.widgetPresentationModel.getDataLabelFormat());
    }

    private void initGui() {
        String columns = "fill:0dlu:grow, pref, 2dlu, max(100dlu;pref), fill:2dlu:grow, pref, fill:2dlu:g(0.1), pref, fill:0dlu:g(0.1)";
        String rows = "fill:2dlu:grow, pref, fill:2dlu:grow, pref, fill:2dlu:grow";
        FormLayout layout = new FormLayout("fill:0dlu:grow, pref, 2dlu, max(100dlu;pref), fill:2dlu:grow, pref, fill:2dlu:g(0.1), pref, fill:0dlu:g(0.1)", "fill:2dlu:grow, pref, fill:2dlu:grow, pref, fill:2dlu:grow");
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        this.dataLabelFormatLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.DATA_LABELS_FORMAT);
        this.buildDataLabelFormatCombo();
        this.dataLabelFormatCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    WidgetSeriesPropertiesPanel.this.widgetPresentationModel.asMutable().setDataLabelFormat((String)e.getItem());
                }
            }
        });
        FontInfo seriesDataLabelFont = this.widgetPresentationModel.getSeriesDataLabelFont();
        this.fontPanel = new FontPanel((UiContainer)this, Font.valueOf((FontInfo)seriesDataLabelFont), Color.WHITE, Color.valueOf((ColorInfo)this.widgetPresentationModel.getSeriesDataLabelColor()), false, true, true, 1);
        this.fontPanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (WidgetSeriesPropertiesPanel.this.doFireEvents) {
                    WidgetSeriesPropertiesPanel.this.widgetPresentationModel.asMutable().setSeriesDataLabelFont(WidgetSeriesPropertiesPanel.this.fontPanel.getCurrentFont().getInfo());
                    WidgetSeriesPropertiesPanel.this.widgetPresentationModel.asMutable().setSeriesDataLabelColor(WidgetSeriesPropertiesPanel.this.fontPanel.getForegroundColor().getInfo());
                }
            }
        });
        this.seriesColorTable = new WidgetSeriesColorPanel((UiContainer)this, this.widgetPresentationModel);
        this.seriesColorTable.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WidgetSeriesPropertiesPanel.this.widgetPresentationModel.asMutable().setSeriesColor(WidgetSeriesPropertiesPanel.this.seriesColorTable.getColorList());
            }
        });
        this.layoutComponents(cc);
        WidgetPanelEnabler.enable(this, this.widgetPresentationModel);
        this.load();
    }

    private void layoutComponents(CellConstraints cc) {
        this.add((UiComponent)this.dataLabelFormatLabel, cc.xy(2, 4));
        this.add((UiComponent)this.dataLabelFormatCombo, cc.xy(4, 4));
        this.add((UiComponent)this.fontPanel, cc.xywh(2, 2, 3, 1));
        this.add((UiComponent)new Separator((UiContainer)this, Separator.VERTICAL), cc.xywh(6, 2, 1, 3));
        this.add((UiComponent)this.seriesColorTable, cc.xywh(8, 2, 1, 3, "center, top"));
    }

    static class DataLabelProvider
    extends LabelProvider.Default {
        DataLabelProvider() {
        }

        public String getText(Object element) {
            String value = String.valueOf(element);
            String result = "";
            if (value.equals("")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_NONE.getString();
            } else if (value.equals("{0} = {1}")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_FULL.getString();
            } else if (value.equals("{0}")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_NAME.getString();
            } else if (value.equals("{1}")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_VALUE.getString();
            }
            return result;
        }

        String getLabel(String value) {
            String result = "";
            if (value.equals("")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_NONE.getString();
            } else if (value.equals("{0} = {1}")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_FULL.getString();
            } else if (value.equals("{0}")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_NAME.getString();
            } else if (value.equals("{1}")) {
                result = DesignerMsg.PROPERTY_ITEM_LABEL_MASK_VALUE.getString();
            }
            return result;
        }
    }
}

