/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionKind;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.drilldown.DrillDown;
import oracle.bpm.dashboard.model.drilldown.DrillDownType;
import oracle.bpm.designer.dashboardwizards.DrillDownViewChooser;
import oracle.bpm.designer.dashboardwizards.WidgetList;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.view.gui.tree.ViewTreeNode;
import oracle.bpm.project.dashboard.drilldown.DrillDownAdapterFactory;
import oracle.bpm.project.dashboard.drilldown.ViewDrillDownAdapter;
import oracle.bpm.project.dashboard.drilldown.WidgetDrillDownAdapter;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.presentation.views.View;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.tree.TreeNode;

public class WidgetDrillDownPanel
extends AbstractConfigurationPanel {
    public CheckBox hasDrillDownCheckBox;
    public RadioButton viewDrillDownRadio;
    public ComboBox widgetCombo;
    public RadioButton widgetDrillDownRadio;
    private boolean fireEvents;
    private DrillDownViewChooser viewChooser;
    private WidgetModel widgetModel;

    public WidgetDrillDownPanel(UiContainer parent, WidgetModel widgetDataModel) {
        super(parent, DesignerMsg.DRILL_DOWN);
        this.widgetModel = widgetDataModel;
        this.buildComponents();
        this.layoutComponents();
    }

    public static int getParametersProvidedByGraphicType(String type) {
        int result = type.equals("XYZ") ? 2 : (type.equals("XY") ? 1 : 0);
        return result;
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.widgetModel = widgetModel;
        boolean hasDrillDown = widgetModel.getDataModel().hasDrillDown();
        this.hasDrillDownCheckBox.setSelected(hasDrillDown);
        this.reloadWidgetCombo();
        this.reloadViews();
        DrillDown drillDownObject = widgetModel.getDataModel().getDrillDown();
        if (hasDrillDown && drillDownObject != null) {
            boolean isViewDrillDown = drillDownObject.getType().equals((Object)DrillDownType.VIEW_DRILL_DOWN);
            this.viewDrillDownRadio.setEnabled(true);
            this.widgetDrillDownRadio.setEnabled(true);
            if (isViewDrillDown) {
                this.viewDrillDownRadio.setSelected(true);
                this.viewChooser.setEnabled(true);
                ViewDrillDownAdapter viewDrillDown = (ViewDrillDownAdapter)drillDownObject;
                View selectedView = viewDrillDown.getView();
                this.viewChooser.setSelectedView(selectedView);
                this.widgetCombo.setSelectedItem(null);
                this.widgetCombo.setEnabled(false);
            } else {
                this.widgetDrillDownRadio.setSelected(true);
                this.widgetCombo.setEnabled(true);
                WidgetDrillDownAdapter widgetDrillDown = (WidgetDrillDownAdapter)drillDownObject;
                WidgetModel selectedWidget = widgetDrillDown.getWidget();
                this.fireEvents = false;
                this.widgetCombo.setSelectedItem((Object)selectedWidget);
                this.fireEvents = true;
                this.viewChooser.setSelectedView(null);
                this.viewChooser.setEnabled(false);
            }
        } else {
            if (hasDrillDown) {
                this.hasDrillDownCheckBox.setSelected(false);
                widgetModel.getDataModel().asMutable().setHasDrillDown(false);
            }
            this.widgetCombo.setSelectedItem(null);
            this.viewChooser.setSelectedView(null);
            this.widgetDrillDownRadio.setSelected(false);
            this.viewDrillDownRadio.setSelected(false);
            this.widgetDrillDownRadio.setEnabled(false);
            this.widgetCombo.setEnabled(false);
            this.viewDrillDownRadio.setEnabled(false);
            this.viewChooser.setEnabled(false);
        }
    }

    public void loadWidgetList() {
        List widgets = this.widgetModel.getProject().getWidgetsList();
        ArrayList<WidgetModel> drillDownWidgets = new ArrayList<WidgetModel>();
        String name = this.widgetModel.getName();
        for (WidgetModel widget : widgets) {
            boolean parametersMatchAllowed;
            int providedParameters = WidgetDrillDownPanel.getParametersProvidedByGraphicType(widget.getPresentationModel().getSubType().getGraphicType());
            int requiredParameters = widget.getDataModel().getDrillDownParametersQuantity();
            boolean bl = parametersMatchAllowed = requiredParameters <= providedParameters;
            if (name == null || name.equals(widget.getName()) || !parametersMatchAllowed) continue;
            drillDownWidgets.add(widget);
        }
        assert (this.widgetCombo != null) : "Combo-box component should not be null";
        this.widgetCombo.setDelegate(drillDownWidgets);
    }

    public void reloadViews() {
        this.viewChooser.reload(this.getVariables(), this.widgetModel);
    }

    private void reloadWidgetCombo() {
        this.loadWidgetList();
        this.widgetCombo.setSelectedItem(null);
    }

    private void layoutComponents() {
        String columns = "fill:0dlu:grow, pref, fill:2dlu:g(0.2), pref, fill:0dlu:grow";
        String rows = "fill:2dlu:grow, pref, 2dlu, pref, 2dlu, pref, fill:2dlu:grow";
        FormLayout layout = new FormLayout(columns, rows);
        this.setLayout((Layout)layout);
        CellConstraints cc = new CellConstraints();
        this.add((UiComponent)this.hasDrillDownCheckBox, cc.xywh(2, 2, 3, 1));
        this.add((UiComponent)this.widgetDrillDownRadio, cc.xy(2, 4));
        this.add((UiComponent)this.widgetCombo, cc.xy(4, 4));
        this.add((UiComponent)this.viewDrillDownRadio, cc.xy(2, 6));
        this.add((UiComponent)this.viewChooser, cc.xy(4, 6));
    }

    private void buildComponents() {
        this.buildHasDrillDownCheckBox();
        this.buildWidgetChooser();
        this.buildViewChooser();
        this.addRadiosToButtonGroup();
        this.fireEvents = true;
    }

    private void addRadiosToButtonGroup() {
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.widgetDrillDownRadio);
        group.add((AbstractButton)this.viewDrillDownRadio);
    }

    private void buildWidgetChooser() {
        this.widgetDrillDownRadio = new RadioButton((UiContainer)this, DesignerMsg.DRILL_DOWN_TO_WIDGET);
        this.widgetDrillDownRadio.setEnabled(false);
        this.widgetDrillDownRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateDeselected()) {
                    WidgetDrillDownPanel.this.widgetCombo.setSelectedItem(null);
                }
                WidgetDrillDownPanel.this.reloadWidgetCombo();
                WidgetDrillDownPanel.this.widgetCombo.setEnabled(e.isStateSelected());
            }
        });
        this.widgetCombo = UiFactory.createComboBox((UiContainer)this);
        this.widgetCombo.setLabelProvider((LabelProvider)new WidgetList.WidgetRenderer());
        this.widgetCombo.setSelectedItem(null);
        this.widgetCombo.setEnabled(false);
        this.widgetCombo.addItemListener(new ItemListener(){
            private WidgetModel oldSelection;

            public void itemStateChanged(ItemEvent e) {
                WidgetModel selectedWidget;
                if (WidgetDrillDownPanel.this.fireEvents && e.isStateSelected() && (selectedWidget = (WidgetModel)e.getItem()) != null && selectedWidget != this.oldSelection) {
                    WidgetDrillDownPanel.this.widgetModel.getDataModel().asMutable().setDrillDown((DrillDown)new DrillDownAdapterFactory(WidgetDrillDownPanel.this.widgetModel.getProject()).create(selectedWidget, false));
                    this.oldSelection = selectedWidget;
                }
            }
        });
    }

    private void buildHasDrillDownCheckBox() {
        this.hasDrillDownCheckBox = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.HAS_DRILL_DOWN);
        this.hasDrillDownCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.isStateSelected();
                WidgetDrillDownPanel.this.enableDrillDownChoosers(selected);
                WidgetDrillDownPanel.this.widgetModel.getDataModel().asMutable().setHasDrillDown(selected);
            }
        });
    }

    private void enableDrillDownChoosers(boolean enable) {
        if (!enable) {
            this.widgetDrillDownRadio.setSelected(false);
            this.widgetCombo.setSelectedItem(null);
            this.viewDrillDownRadio.setSelected(false);
            this.viewChooser.setSelectedView(null);
        }
        this.widgetDrillDownRadio.setEnabled(enable);
        this.widgetCombo.setEnabled(false);
        this.viewDrillDownRadio.setEnabled(enable);
        this.viewChooser.setEnabled(false);
    }

    private void buildViewChooser() {
        this.viewDrillDownRadio = new RadioButton((UiContainer)this, DesignerMsg.DRILL_DOWN_TO_VIEW);
        this.viewDrillDownRadio.setEnabled(false);
        this.viewDrillDownRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateDeselected()) {
                    WidgetDrillDownPanel.this.viewChooser.setSelectedView(null);
                }
                WidgetDrillDownPanel.this.viewChooser.setEnabled(e.isStateSelected());
            }
        });
        this.viewChooser = DrillDownViewChooser.create((UiContainer)this, this.widgetModel, this.getVariables());
        this.viewChooser.addNodeSelectedListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                View selectedView;
                TreeNode treeNode = WidgetDrillDownPanel.this.viewChooser.getValueTreeNode();
                if (treeNode instanceof ViewTreeNode && (selectedView = WidgetDrillDownPanel.this.viewChooser.getSelectedView()) != null) {
                    WidgetDataModel.Mutable dataModel = WidgetDrillDownPanel.this.widgetModel.getDataModel().asMutable();
                    dataModel.setHasDrillDown(true);
                    dataModel.setDrillDown((DrillDown)new DrillDownAdapterFactory(WidgetDrillDownPanel.this.widgetModel.getProject()).create(selectedView, false));
                }
            }
        });
        this.viewChooser.setEnabled(false);
    }

    private List<ProjectDataObject> getVariables() {
        List list = this.widgetModel.getDataModel().getDimensions();
        ArrayList<ProjectDataObject> dataObjects = new ArrayList<ProjectDataObject>();
        for (Dimension dimension : list) {
            ProjectDataObject dataObject = this.adaptToVariable(dimension);
            if (dataObject == null) continue;
            dataObjects.add(dataObject);
        }
        return dataObjects;
    }

    private ProjectDataObject adaptToVariable(Dimension dimension) {
        ProjectDataObject result = null;
        DimensionKind kind = dimension.getKind();
        String variableId = kind.getEquivalentVariableId();
        Collection projectDataObjects = this.widgetModel.getProject().getAllVariables();
        for (ProjectDataObject projectDataObject : projectDataObjects) {
            String id = projectDataObject.getId();
            if (!id.equals(variableId)) continue;
            result = projectDataObject;
            break;
        }
        return result;
    }
}

