/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import java.math.BigDecimal;
import java.util.ArrayList;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.designer.dashboardwizards.WidgetPanelEnabler;
import oracle.bpm.designer.dashboardwizards.WizardPreferencesPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.GaugePropertiesPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.WidgetBasicPropertiesPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.WidgetDrillDownPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.WidgetSeriesPropertiesPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.WidgetTitlePropertiesPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.datasourcepanel.WidgetDataSourcePanel;
import oracle.bpm.designer.formdesigner.FullBorderPropertiesImpl;
import oracle.bpm.project.dashboard.WidgetPresentationModelImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.xobject.GraphicType;
import oracle.bpm.xobject.lib.chart.Range;
import oracle.bpm.xobject.presentationmodel.FullBorderProperties;

public class WidgetDisplayPreferencesBuilder {
    private WidgetBasicPropertiesPanel basicPanel;
    private WidgetDataSourcePanel dataSourcePanel;
    private WidgetDrillDownPanel drillDownPanel;
    private GaugePropertiesPanel gaugePanel;
    private WidgetSeriesPropertiesPanel seriesPanel;
    private WidgetTitlePropertiesPanel titlePanel;
    private static final int DEFAULT_REFRESH_RATE = 30;

    public static WidgetPresentationModel createDefaultPresentationModel(Project project) {
        WidgetPresentationModel.Mutable widgetPresentationModel = new WidgetPresentationModelImpl(project).asMutable();
        FullBorderPropertiesImpl border = new FullBorderPropertiesImpl();
        widgetPresentationModel.setBorder((FullBorderProperties)border);
        widgetPresentationModel.setType(WidgetGraphicType.CHART);
        widgetPresentationModel.setSubType(GraphicType.BAR_CHART);
        widgetPresentationModel.setTotalRange(new Range(0.0, 300.0).createBVDRange());
        widgetPresentationModel.setNormalRange(new Range(0.0, 100.0).createBVDRange());
        widgetPresentationModel.setWarningRange(new Range(101.0, 200.0).createBVDRange());
        widgetPresentationModel.setCriticalRange(new Range(201.0, 300.0).createBVDRange());
        widgetPresentationModel.setNormalRangeColor(ColorInfo.GREEN);
        widgetPresentationModel.setWarningRangeColor(ColorInfo.YELLOW);
        widgetPresentationModel.setCriticalRangeColor(ColorInfo.RED);
        widgetPresentationModel.setDataLabelFormat("{0} = {1}");
        widgetPresentationModel.setSeriesDataLabelFont(FontInfo.valueOf("Verdana", 0, 15));
        widgetPresentationModel.setSeriesDataLabelColor(ColorInfo.BLACK);
        ArrayList<ColorInfo> colors = new ArrayList<ColorInfo>();
        colors.add(ColorInfo.valueOf(0, 153, 255));
        colors.add(ColorInfo.valueOf(204, 255, 255));
        colors.add(ColorInfo.valueOf(0, 0, 119));
        colors.add(ColorInfo.valueOf(0, 102, 204));
        widgetPresentationModel.setSeriesColor(colors);
        widgetPresentationModel.setBackgroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setForegroundColor(ColorInfo.BLACK);
        widgetPresentationModel.setPlotBackgroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setOutlineColor(ColorInfo.GRAY);
        widgetPresentationModel.setPlotOutlineColor(ColorInfo.BLACK);
        widgetPresentationModel.setSeriesDataLabelColor(ColorInfo.BLACK);
        widgetPresentationModel.setShadowColor(ColorInfo.GRAY);
        widgetPresentationModel.setWidth(400);
        widgetPresentationModel.setHeight(400);
        widgetPresentationModel.setTitleFont(FontInfo.valueOf("Verdana", 0, 15));
        widgetPresentationModel.setTitleBackgroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setTitleForegroundColor(ColorInfo.BLACK);
        widgetPresentationModel.setRefreshRate(30);
        widgetPresentationModel.setOrientation(1);
        return widgetPresentationModel;
    }

    public static WidgetPresentationModel createPresentationModelForTesting() {
        WidgetPresentationModel.Mutable widgetPresentationModel = new WidgetPresentationModelImpl(null).asMutable();
        widgetPresentationModel.setName("NewWidget");
        widgetPresentationModel.setTitle("New Widget");
        FullBorderPropertiesImpl border = new FullBorderPropertiesImpl();
        border.setBottomColor("red");
        border.setBottomborderstyle(BorderStyle.DASHED);
        border.setBottomWidth(3);
        border.setLeftColor("blue");
        border.setLeftborderstyle(BorderStyle.DOUBLE);
        border.setLeftWidth(1);
        border.setRightColor("green");
        border.setRightborderstyle(BorderStyle.SOLID);
        border.setRightWidth(2);
        border.setTopColor("violet");
        border.setTopborderstyle(BorderStyle.GROOVE);
        border.setTopWidth(0);
        widgetPresentationModel.setBorder((FullBorderProperties)border);
        widgetPresentationModel.setType(WidgetGraphicType.CHART);
        widgetPresentationModel.setSubType(GraphicType.BAR_CHART);
        widgetPresentationModel.setWidth(250);
        widgetPresentationModel.setHeight(250);
        widgetPresentationModel.setTotalRange(new Range(-100.0, 1000.0).createBVDRange());
        widgetPresentationModel.setNormalRange(new Range(0.0, 100.0).createBVDRange());
        widgetPresentationModel.setWarningRange(new Range(101.0, 200.0).createBVDRange());
        widgetPresentationModel.setCriticalRange(new Range(201.0, 1000.0).createBVDRange());
        widgetPresentationModel.setDataLabelFormat("{0} = {1}");
        ArrayList<ColorInfo> colors = new ArrayList<ColorInfo>();
        colors.add(ColorInfo.valueOf(0, 153, 255));
        colors.add(ColorInfo.valueOf(204, 255, 255));
        colors.add(ColorInfo.valueOf(0, 0, 119));
        colors.add(ColorInfo.valueOf(0, 102, 204));
        colors.add(ColorInfo.valueOf(0, 102, 204));
        widgetPresentationModel.setSeriesColor(colors);
        widgetPresentationModel.setBackgroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setForegroundColor(ColorInfo.BLACK);
        widgetPresentationModel.setPlotBackgroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setOutlineColor(ColorInfo.BLACK);
        widgetPresentationModel.setPlotOutlineColor(ColorInfo.BLACK);
        widgetPresentationModel.setSeriesDataLabelColor(ColorInfo.WHITE);
        widgetPresentationModel.setShadowColor(ColorInfo.GRAY);
        widgetPresentationModel.setNormalRangeColor(ColorInfo.RED);
        widgetPresentationModel.setCriticalRangeColor(ColorInfo.GREEN);
        widgetPresentationModel.setWarningRangeColor(ColorInfo.CYAN);
        widgetPresentationModel.setTitleBackgroundColor(ColorInfo.RED);
        widgetPresentationModel.setTitleForegroundColor(ColorInfo.WHITE);
        widgetPresentationModel.setSeriesDataLabelFont(FontInfo.valueOf("Elvetica", 1, 12));
        widgetPresentationModel.setTitleFont(FontInfo.valueOf("Arial", 2, 14));
        widgetPresentationModel.setCriticalRange(BusinessVariableData.Range.create("Range1", new BigDecimal(3), new BigDecimal(4)));
        widgetPresentationModel.setNormalRange(BusinessVariableData.Range.create("Range2", new BigDecimal(100), new BigDecimal(40)));
        widgetPresentationModel.setTotalRange(BusinessVariableData.Range.create("Range3", new BigDecimal(1), new BigDecimal(10)));
        widgetPresentationModel.setWarningRange(BusinessVariableData.Range.create("Range4", new BigDecimal(4), new BigDecimal(340)));
        widgetPresentationModel.setDataLabelFormat("datalabe");
        widgetPresentationModel.setTypeSelectionAllowed(true);
        widgetPresentationModel.setUsrSelectionAllowed(true);
        widgetPresentationModel.setHeight(2);
        widgetPresentationModel.setWidth(2);
        widgetPresentationModel.setOrientation(3);
        widgetPresentationModel.setRefreshRate(2);
        return widgetPresentationModel;
    }

    public WizardPreferencesPanel build(UiContainer parent, WidgetModel widgetModel) {
        WizardPreferencesPanel displayWidgetPreferences = new WizardPreferencesPanel(parent);
        WidgetPresentationModel widgetPresentationModel = widgetModel.getPresentationModel();
        this.dataSourcePanel = displayWidgetPreferences.addDataSourcePanel(widgetModel);
        this.dataSourcePanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WidgetDisplayPreferencesBuilder.this.dataSourcePanel.guessTypeBasedOnDimensions();
                WidgetDisplayPreferencesBuilder.this.basicPanel.reloadType();
                WidgetDisplayPreferencesBuilder.this.titlePanel.reload();
                WidgetDisplayPreferencesBuilder.this.drillDownPanel.reloadViews();
            }
        });
        displayWidgetPreferences.setSelected(0);
        this.createBasicPanel(displayWidgetPreferences, widgetPresentationModel);
        this.titlePanel = displayWidgetPreferences.addTitlePanel(widgetPresentationModel);
        this.titlePanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WidgetDisplayPreferencesBuilder.this.dataSourcePanel.reloadTitle();
            }
        });
        displayWidgetPreferences.addColorPropertiesPanel(widgetPresentationModel);
        displayWidgetPreferences.addBorderpanel(widgetPresentationModel);
        this.seriesPanel = displayWidgetPreferences.addSeriesPanel(widgetPresentationModel);
        displayWidgetPreferences.addBehaviourPanel(widgetPresentationModel);
        this.gaugePanel = displayWidgetPreferences.addGaugePropertiesPanel(widgetPresentationModel);
        this.drillDownPanel = displayWidgetPreferences.addDrillDownPanel(widgetModel);
        return displayWidgetPreferences;
    }

    private void createBasicPanel(WizardPreferencesPanel displayWidgetPreferences, WidgetPresentationModel widgetPresentationModel) {
        this.basicPanel = displayWidgetPreferences.addBasicPanel(widgetPresentationModel);
        WidgetBasicPropertiesPanel.DoOnTypeSelectionStrategy typeSelectionStrategy = new WidgetBasicPropertiesPanel.DoOnTypeSelectionStrategy(){

            @Override
            public void doOnTypeSelection() {
                WidgetPanelEnabler.enable(WidgetDisplayPreferencesBuilder.this.basicPanel, WidgetDisplayPreferencesBuilder.this.gaugePanel);
                WidgetPanelEnabler.enable(WidgetDisplayPreferencesBuilder.this.basicPanel, WidgetDisplayPreferencesBuilder.this.seriesPanel);
            }
        };
        this.basicPanel.setTypeSelectionStrategy(typeSelectionStrategy);
    }
}

