/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

public class WidgetColorPropertiesPanel
extends AbstractConfigurationPanel {
    private ColorChoosingComponent backgroundChooser;
    private Label backgroundColorLabel;
    private boolean noEvents;
    private ColorChoosingComponent outlineChooser;
    private Label outlineColorLabel;
    private ColorChoosingComponent plotBackgroundChooser;
    private Label plotBackgroundLabel;
    private ColorChoosingComponent plotOutlineChooser;
    private Label plotOutlineLabel;
    private ColorChoosingComponent shadowChooser;
    private Label shadowColorLabel;
    private WidgetPresentationModel widgetPresentationModel;
    public static final Color BACKGROUND_DEFAULT_COLOR = Color.WHITE;
    public static final Color OUTLINE_DEFAULT_COLOR = Color.GRAY;
    public static final Color SHADOW_DEFAULT_COLOR = Color.GRAY;
    public static final Color PLOT_BACKGROUND_DEFAULT_COLOR = Color.WHITE;
    public static final Color PLOT_OUTLINE_DEFAULT_COLOR = Color.BLACK;

    public WidgetColorPropertiesPanel(UiContainer parent, WidgetPresentationModel widgetPresentationModel) {
        super(parent, DesignerMsg.COLORS);
        this.widgetPresentationModel = widgetPresentationModel;
        this.buildComponents();
        this.layoutComponents();
        this.addListeners();
    }

    public void enableOutlineColor(boolean enable) {
        this.outlineColorLabel.setEnabled(enable);
        this.outlineChooser.setEnabled(enable);
    }

    public void enablePlotBackgroundColor(boolean enable) {
        this.plotBackgroundLabel.setEnabled(enable);
        this.plotBackgroundChooser.setEnabled(enable);
    }

    public void enablePlotOutlineColor(boolean enable) {
        this.plotOutlineLabel.setEnabled(enable);
        this.plotOutlineChooser.setEnabled(enable);
    }

    public void enableShadowColor(boolean enable) {
        this.shadowColorLabel.setEnabled(enable);
        this.shadowChooser.setEnabled(enable);
    }

    public void load() {
        this.outlineChooser.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getOutlineColor()));
        this.backgroundChooser.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getBackgroundColor()));
        this.plotOutlineChooser.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getPlotOutlineColor()));
        this.shadowChooser.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getShadowColor()));
        this.plotBackgroundChooser.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getPlotBackgroundColor()));
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        this.noEvents = true;
        this.enableGaugeColors();
        this.load();
        this.noEvents = false;
    }

    public void enableGaugeColors() {
        boolean isGauge = this.widgetPresentationModel.getType().equals((Object)WidgetGraphicType.GAUGE);
        this.enableOutlineColor(!isGauge);
        this.enablePlotBackgroundColor(!isGauge);
        this.enablePlotOutlineColor(!isGauge);
        this.enableShadowColor(!isGauge);
    }

    private void addListeners() {
        this.outlineChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!WidgetColorPropertiesPanel.this.noEvents) {
                    WidgetColorPropertiesPanel.this.widgetPresentationModel.asMutable().setOutlineColor(WidgetColorPropertiesPanel.this.outlineChooser.getSelectedColor().getInfo());
                }
            }
        });
        this.backgroundChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!WidgetColorPropertiesPanel.this.noEvents) {
                    WidgetColorPropertiesPanel.this.widgetPresentationModel.asMutable().setBackgroundColor(WidgetColorPropertiesPanel.this.backgroundChooser.getSelectedColor().getInfo());
                }
            }
        });
        this.shadowChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!WidgetColorPropertiesPanel.this.noEvents) {
                    WidgetColorPropertiesPanel.this.widgetPresentationModel.asMutable().setShadowColor(WidgetColorPropertiesPanel.this.shadowChooser.getSelectedColor().getInfo());
                }
            }
        });
        this.plotBackgroundChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!WidgetColorPropertiesPanel.this.noEvents) {
                    WidgetColorPropertiesPanel.this.widgetPresentationModel.asMutable().setPlotBackgroundColor(WidgetColorPropertiesPanel.this.plotBackgroundChooser.getSelectedColor().getInfo());
                }
            }
        });
        this.plotOutlineChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!WidgetColorPropertiesPanel.this.noEvents) {
                    WidgetColorPropertiesPanel.this.widgetPresentationModel.asMutable().setPlotOutlineColor(WidgetColorPropertiesPanel.this.plotOutlineChooser.getSelectedColor().getInfo());
                }
            }
        });
    }

    private void buildComponents() {
        this.outlineColorLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.OUTLINE);
        this.outlineChooser = new ColorChoosingComponent((UiContainer)this, OUTLINE_DEFAULT_COLOR);
        this.backgroundColorLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.BACKGROUND);
        this.backgroundChooser = new ColorChoosingComponent((UiContainer)this, BACKGROUND_DEFAULT_COLOR);
        this.plotOutlineLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.PLOT_OUTLINE);
        this.plotOutlineChooser = new ColorChoosingComponent((UiContainer)this, PLOT_OUTLINE_DEFAULT_COLOR);
        this.shadowColorLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.SHADOW);
        this.shadowChooser = new ColorChoosingComponent((UiContainer)this, SHADOW_DEFAULT_COLOR);
        this.plotBackgroundLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.PLOT_BACKGROUND);
        this.plotBackgroundChooser = new ColorChoosingComponent((UiContainer)this, PLOT_BACKGROUND_DEFAULT_COLOR);
    }

    private void layoutComponents() {
        String columns = "fill:0dlu:grow, pref, fill:2dlu:g(0.2), pref, fill:0dlu:grow";
        String rows = "fill:2dlu:grow, pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:grow";
        FormLayout layout = new FormLayout("fill:0dlu:grow, pref, fill:2dlu:g(0.2), pref, fill:0dlu:grow", "fill:2dlu:grow, pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:grow");
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        this.add((UiComponent)this.outlineColorLabel, cc.xy(2, 2));
        this.add((UiComponent)this.outlineChooser, cc.xy(4, 2));
        this.add((UiComponent)this.backgroundColorLabel, cc.xy(2, 4));
        this.add((UiComponent)this.backgroundChooser, cc.xy(4, 4));
        this.add((UiComponent)this.plotOutlineLabel, cc.xy(2, 6));
        this.add((UiComponent)this.plotOutlineChooser, cc.xy(4, 6));
        this.add((UiComponent)this.shadowColorLabel, cc.xy(2, 8));
        this.add((UiComponent)this.shadowChooser, cc.xy(4, 8));
        this.add((UiComponent)this.plotBackgroundLabel, cc.xy(2, 10));
        this.add((UiComponent)this.plotBackgroundChooser, cc.xy(4, 10));
    }
}

