/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.ValueChangedEvent;
import oracle.bpm.ui.text.ValueChangedListener;

public class WidgetBehaviourPropertiesPanel
extends AbstractConfigurationPanel {
    private Label refreshRateLabel;
    private IntervalField refreshRateSpinner;
    private CheckBox typeSelectionCheckbox;
    private CheckBox usrRefreshCheckbox;
    private WidgetPresentationModel widgetPresentationModel;
    public static final int MAX_REFRESH_RATE = Integer.MAX_VALUE;

    public WidgetBehaviourPropertiesPanel(UiContainer parent, WidgetPresentationModel widgetPresentationModel) {
        super(parent, DesignerMsg.BEHAVIOUR);
        this.widgetPresentationModel = widgetPresentationModel;
        this.buildRefreshRateSpinner((UiContainer)this);
        this.buildUserRefreshCheck((UiContainer)this);
        this.buildTypeSelectionCheck((UiContainer)this);
        this.layoutComponents();
        this.load();
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        this.load();
    }

    private void buildRefreshRateSpinner(UiContainer parent) {
        this.refreshRateLabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.REFRESH_RATE);
        this.refreshRateSpinner = IntervalField.createPositiveIntervalField((UiContainer)parent, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
        this.refreshRateSpinner.addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent valuechangedevent) {
                WidgetBehaviourPropertiesPanel.this.widgetPresentationModel.asMutable().setRefreshRate(WidgetBehaviourPropertiesPanel.this.refreshRateSpinner.getInterval().getSeconds());
            }
        });
    }

    private void buildTypeSelectionCheck(UiContainer parent) {
        this.typeSelectionCheckbox = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.TYPE_SELECTION_ALLOWED);
        this.typeSelectionCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WidgetBehaviourPropertiesPanel.this.widgetPresentationModel.asMutable().setTypeSelectionAllowed(e.isStateSelected());
            }
        });
    }

    private void buildUserRefreshCheck(UiContainer parent) {
        this.usrRefreshCheckbox = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.USER_REFRESH);
        this.usrRefreshCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WidgetBehaviourPropertiesPanel.this.widgetPresentationModel.asMutable().setUsrSelectionAllowed(e.isStateSelected());
            }
        });
    }

    private void layoutComponents() {
        String columns = "fill:0dlu:grow, pref, fill:2dlu:g(0.01), pref, fill:0dlu:grow";
        String rows = "fill:2dlu:grow, pref, fill:2dlu:g(0.2), pref, fill:2dlu:g(0.2), pref, fill:2dlu:grow";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        this.add((UiComponent)this.refreshRateLabel, cc.xy(2, 2));
        this.add((UiComponent)this.refreshRateSpinner, cc.xy(4, 2));
        this.add((UiComponent)this.usrRefreshCheckbox, cc.xywh(2, 4, 3, 1));
        this.add((UiComponent)this.typeSelectionCheckbox, cc.xywh(2, 6, 3, 1));
    }

    private void load() {
        Interval refreshRate = Interval.valueOf(this.widgetPresentationModel.getRefreshRate() + "s");
        this.refreshRateSpinner.setInterval(refreshRate);
        this.usrRefreshCheckbox.setSelected(this.widgetPresentationModel.isUsrSelectionAllowed());
        this.typeSelectionCheckbox.setSelected(this.widgetPresentationModel.isTypeSelectionAllowed());
    }
}

