/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import javax.swing.ListModel;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.designer.dashboardwizards.components.GraphSubtypeComboModel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.webformdesigner.msg.WebformdesignerMsg;
import oracle.bpm.xobject.GraphicType;

public class WidgetBasicPropertiesPanel
extends AbstractConfigurationPanel {
    private NumericField<Integer> heightSpinner;
    private RadioButton horizontalRadio;
    private DoOnTypeSelectionStrategy typeSelectionStrategy;
    private RadioButton verticalRadio;
    private WidgetPresentationModel widgetPresentationModel;
    private SubtypeList widgetSubtypeList;
    private NumericField<Integer> widthSpinner;

    public WidgetBasicPropertiesPanel(UiContainer parent, WidgetPresentationModel widgetPresentationModel) {
        super(parent, DesignerMsg.WIDGET_CONFIGURATION);
        this.widgetPresentationModel = widgetPresentationModel;
        this.buildWidgetSubtypeCombo();
        this.buildWidthSpinner();
        this.buildHeightSpinner();
        this.buildOrientationRadios();
        this.layoutComponents();
        this.load();
    }

    public void doOnTypeSelectionChange() {
        this.typeSelectionStrategy.doOnTypeSelection();
    }

    public void setTypeSelectionStrategy(DoOnTypeSelectionStrategy typeSelectionStrategy) {
        this.typeSelectionStrategy = typeSelectionStrategy;
    }

    public WidgetPresentationModel getWidgetModel() {
        return this.widgetPresentationModel;
    }

    public void reloadType() {
        this.widgetSubtypeList.reload(this.widgetPresentationModel.getType().getMsg().getCode());
        this.widgetSubtypeList.setSelectedValue(this.widgetPresentationModel.getSubType(), true);
        this.doOnTypeSelectionChange();
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        this.load();
    }

    private static NumericField<Integer> createNumericField(UiContainer parent, int value) {
        NumericField field = NumericField.createIntegerNumericField((UiContainer)parent);
        Integer min = Integer.MIN_VALUE;
        Integer max = Integer.MAX_VALUE;
        field.setValue((Number)value);
        field.setRange((Number)min, (Number)max);
        field.setStepSize((Number)1);
        return field;
    }

    private void buildHeightSpinner() {
        this.heightSpinner = WidgetBasicPropertiesPanel.createNumericField((UiContainer)this, this.widgetPresentationModel.getHeight());
        this.heightSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WidgetBasicPropertiesPanel.this.widgetPresentationModel.asMutable().setHeight(((Integer)WidgetBasicPropertiesPanel.this.heightSpinner.getValue()).intValue());
            }
        });
    }

    private void buildOrientationRadios() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.verticalRadio = new RadioButton((UiContainer)this, DesignerMsg.VERTICAL);
        this.horizontalRadio = new RadioButton((UiContainer)this, DesignerMsg.HORIZONTAL);
        buttonGroup.add((AbstractButton)this.verticalRadio);
        buttonGroup.add((AbstractButton)this.horizontalRadio);
        this.verticalRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WidgetBasicPropertiesPanel.this.widgetPresentationModel.asMutable().setOrientation(1);
            }
        });
        this.horizontalRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                WidgetBasicPropertiesPanel.this.widgetPresentationModel.asMutable().setOrientation(0);
            }
        });
    }

    private void buildWidgetSubtypeCombo() {
        this.widgetSubtypeList = new SubtypeList((UiContainer)this, this.widgetPresentationModel.getType().getString());
        this.widgetSubtypeList.reload(this.widgetPresentationModel.getType().getMsg().getCode());
        this.widgetSubtypeList.setSelectedValue(this.widgetPresentationModel.getSubType(), true);
        this.widgetSubtypeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GraphicType newSubType = (GraphicType)WidgetBasicPropertiesPanel.this.widgetSubtypeList.getSelectedValue();
                WidgetBasicPropertiesPanel.this.widgetPresentationModel.asMutable().setSubType(newSubType);
                if (!WidgetBasicPropertiesPanel.this.widgetPresentationModel.getType().equals((Object)WidgetGraphicType.CHART)) {
                    WidgetBasicPropertiesPanel.this.verticalRadio.setSelected(true);
                    WidgetBasicPropertiesPanel.this.horizontalRadio.setEnabled(false);
                } else {
                    WidgetBasicPropertiesPanel.this.horizontalRadio.setEnabled(true);
                }
            }
        });
    }

    private void buildWidthSpinner() {
        this.widthSpinner = WidgetBasicPropertiesPanel.createNumericField((UiContainer)this, this.widgetPresentationModel.getWidth());
        this.widthSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                WidgetBasicPropertiesPanel.this.widgetPresentationModel.asMutable().setWidth(((Integer)WidgetBasicPropertiesPanel.this.widthSpinner.getValue()).intValue());
            }
        });
    }

    private void layoutComponents() {
        String cols = "fill:0dlu:grow, pref, 5dlu, pref, 2dlu, 70dlu, fill:0dlu:grow";
        String rows = "fill:2dlu:grow, fill:100dlu, 16dlu, pref, 2dlu, pref, 16dlu, pref, 2dlu, pref, fill:2dlu:grow";
        FormLayout layout = new FormLayout("fill:0dlu:grow, pref, 5dlu, pref, 2dlu, 70dlu, fill:0dlu:grow", rows);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.GRAPH_TYPE), cc.xy(2, 2, "left, top"));
        builder.add((UiComponent)this.widgetSubtypeList, cc.xywh(4, 2, 3, 1));
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.WIDTH), cc.xy(2, 4));
        builder.add(this.widthSpinner, cc.xy(4, 4));
        builder.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.HEIGHT), cc.xy(2, 6));
        builder.add(this.heightSpinner, cc.xy(4, 6));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ORIENTATION), cc.xy(2, 8));
        this.add((UiComponent)this.verticalRadio, cc.xy(4, 8));
        this.add((UiComponent)this.horizontalRadio, cc.xy(6, 8));
    }

    private void load() {
        this.heightSpinner.setValue((Number)this.widgetPresentationModel.getHeight());
        this.widthSpinner.setValue((Number)this.widgetPresentationModel.getWidth());
        this.widgetSubtypeList.reload(this.widgetPresentationModel.getType().getMsg().getCode());
        this.widgetSubtypeList.setSelectedValue(this.widgetPresentationModel.getSubType(), true);
        if (this.widgetPresentationModel.getOrientation() == 1) {
            this.verticalRadio.setSelected(true);
        } else {
            this.horizontalRadio.setSelected(true);
        }
    }

    public static class SubtypeList
    extends List {
        public SubtypeList(UiContainer parent, String type) {
            super(parent, (ListModel)new GraphSubtypeComboModel(type));
            this.setLabelProvider((LabelProvider)new SubtypeLabelProvider());
        }

        public void reload(String type) {
            String typeCode = "XYZ";
            if (type.equals(WebformdesignerMsg.PIE.getCode())) {
                typeCode = "XY";
            } else if (type.equals(WebformdesignerMsg.GAUGE.getCode())) {
                typeCode = "GAUGE";
            }
            GraphSubtypeComboModel graphSubtypeComboModel = (GraphSubtypeComboModel)this.getModel();
            graphSubtypeComboModel.reloadSubtypes(typeCode);
            this.setEnabled(!graphSubtypeComboModel.isEmpty());
        }

        public static class SubtypeLabelProvider
        extends LabelProvider.Default {
            public String getText(Object element) {
                return element instanceof I18nProvider ? ((I18nProvider)element).getString() : String.valueOf(element);
            }
        }
    }

    static interface DoOnTypeSelectionStrategy {
        public void doOnTypeSelection();
    }
}

