/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.configurationpanels;

import java.math.BigDecimal;
import oracle.bpm.dashboard.model.WidgetGraphicType;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.designer.dashboardwizards.WidgetPanelEnabler;
import oracle.bpm.designer.dashboardwizards.components.FontPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.AbstractConfigurationPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.text.NumericField;

public class GaugePropertiesPanel
extends AbstractConfigurationPanel {
    private ColorChoosingComponent criticalRangeColor;
    private boolean doFireEvents = true;
    private ColorChoosingComponent foregroundChooser;
    private Label foregroundColorLabel;
    private NumericField<Double> maxCriticalRangeSpinner;
    private NumericField<Double> maxNormalRangeSpinner;
    private NumericField<Double> maxTotalRangeSpinner;
    private NumericField<Double> maxWarningRangeSpinner;
    private NumericField<Double> minCriticalRangeSpinner;
    private NumericField<Double> minNormalRangeSpinner;
    private NumericField<Double> minTotalRangeSpinner;
    private NumericField<Double> minWarningRangeSpinner;
    private ColorChoosingComponent normalRangeColor;
    private FontPanel valueFontChooser;
    private ColorChoosingComponent warningRangeColor;
    private WidgetPresentationModel widgetPresentationModel;
    public static final Color FOREGROUND_DEFAULT_COLOR = Color.BLACK;

    public GaugePropertiesPanel(UiContainer parent, WidgetPresentationModel widgetPresentationModel) {
        super(parent, DesignerMsg.GAUGE_PROPERTIES);
        this.widgetPresentationModel = widgetPresentationModel;
        this.buildAndLayoutComponents();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.foregroundChooser.setEnabled(enabled);
        this.valueFontChooser.setEnabled(enabled);
        this.minTotalRangeSpinner.setEnabled(enabled);
        this.maxTotalRangeSpinner.setEnabled(enabled);
        this.minNormalRangeSpinner.setEnabled(enabled);
        this.maxNormalRangeSpinner.setEnabled(enabled);
        this.normalRangeColor.setEnabled(enabled);
        this.minWarningRangeSpinner.setEnabled(enabled);
        this.maxWarningRangeSpinner.setEnabled(enabled);
        this.warningRangeColor.setEnabled(enabled);
        this.minCriticalRangeSpinner.setEnabled(enabled);
        this.maxCriticalRangeSpinner.setEnabled(enabled);
        this.criticalRangeColor.setEnabled(enabled);
    }

    public void load() {
        this.doFireEvents = false;
        this.foregroundChooser.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getForegroundColor()));
        this.valueFontChooser.setForegroundColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getValueColor()));
        this.valueFontChooser.setCurrentFont(Font.valueOf((FontInfo)this.widgetPresentationModel.getValueFont()));
        this.minTotalRangeSpinner.setValue((Number)this.widgetPresentationModel.getTotalRange().getStart().doubleValue());
        this.maxTotalRangeSpinner.setValue((Number)this.widgetPresentationModel.getTotalRange().getFinish().doubleValue());
        this.minNormalRangeSpinner.setValue((Number)this.widgetPresentationModel.getNormalRange().getStart().doubleValue());
        this.maxNormalRangeSpinner.setValue((Number)this.widgetPresentationModel.getNormalRange().getFinish().doubleValue());
        this.normalRangeColor.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getNormalRangeColor()));
        this.minWarningRangeSpinner.setValue((Number)this.widgetPresentationModel.getWarningRange().getStart().doubleValue());
        this.maxWarningRangeSpinner.setValue((Number)this.widgetPresentationModel.getWarningRange().getFinish().doubleValue());
        this.warningRangeColor.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getWarningRangeColor()));
        this.minCriticalRangeSpinner.setValue((Number)this.widgetPresentationModel.getCriticalRange().getStart().doubleValue());
        this.maxCriticalRangeSpinner.setValue((Number)this.widgetPresentationModel.getCriticalRange().getFinish().doubleValue());
        this.criticalRangeColor.setSelectedColor(Color.valueOf((ColorInfo)this.widgetPresentationModel.getCriticalRangeColor()));
        this.widgetPresentationModel.getType().equals((Object)WidgetGraphicType.GAUGE);
        this.doFireEvents = true;
    }

    @Override
    public void setModel(WidgetModel widgetModel) {
        this.widgetPresentationModel = widgetModel.getPresentationModel();
        WidgetPanelEnabler.enableGaugePanel(this.widgetPresentationModel.getType(), this);
        this.load();
    }

    private NumericField<Double> createFinishSpinner(UiContainer parent, final BusinessVariableData.Range range) {
        final NumericField<Double> spinner = this.createNumericField(parent, range.getFinish());
        spinner.setPreferredSize(Dimension.valueOf(75, 25));
        spinner.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void update() {
                range.setFinish(new BigDecimal((Double)spinner.getValue()));
            }
        });
        return spinner;
    }

    private NumericField<Double> createNumericField(UiContainer parent, BigDecimal value) {
        NumericField field = NumericField.createDoubleNumericField((UiContainer)parent);
        field.setValue((Number)value.doubleValue());
        return field;
    }

    private NumericField<Double> createStartSpinner(UiContainer parent, final BusinessVariableData.Range range) {
        final NumericField<Double> spinner = this.createNumericField(parent, range.getStart());
        spinner.setPreferredSize(Dimension.valueOf(75, 25));
        spinner.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                range.setStart(new BigDecimal((Double)spinner.getValue()));
            }
        });
        return spinner;
    }

    private void buildAndLayoutComponents() {
        this.widgetPresentationModel.getType().equals((Object)WidgetGraphicType.GAUGE);
        String columns = "fill:0dlu:grow, pref, fill:0dlu:grow";
        String rows = "fill:0dlu:grow, pref, 2dlu, pref, 2dlu, pref, 2dlu,pref, 4dlu, pref, 2dlu, pref, 2dlu, pref, fill:0dlu:grow";
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        Panel foregroundPanel = this.buildForegroundPanel();
        this.add((UiComponent)foregroundPanel, cc.xy(2, 2));
        Panel valuePanel = this.buildValuePanel();
        this.add((UiComponent)valuePanel, cc.xy(2, 4));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.RANGES_CONFIGURATION), cc.xy(2, 6));
        Panel totalRangePanel = this.buildTotalRangePanel();
        this.add((UiComponent)totalRangePanel, cc.xy(2, 8));
        Panel normalRangePanel = this.buildNormalRangePanel();
        this.add((UiComponent)normalRangePanel, cc.xy(2, 10));
        Panel warningRangePanel = this.buildWarningRangePanel();
        this.add((UiComponent)warningRangePanel, cc.xy(2, 12));
        Panel criticalRangePanel = this.buildCriticalRangePanel();
        this.add((UiComponent)criticalRangePanel, cc.xy(2, 14));
    }

    private Panel buildCriticalRangePanel() {
        Panel criticalRangePanel = new Panel((UiContainer)this, DesignerMsg.CRITICAL_RANGE);
        criticalRangePanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        BusinessVariableData.Range criticalRange = this.widgetPresentationModel.getCriticalRange();
        criticalRangePanel.add((UiComponent)Label.create((UiContainer)criticalRangePanel, (Msg)DesignerMsg.MIN));
        this.minCriticalRangeSpinner = this.createStartSpinner((UiContainer)criticalRangePanel, criticalRange);
        criticalRangePanel.add(this.minCriticalRangeSpinner);
        criticalRangePanel.add((UiComponent)Label.create((UiContainer)criticalRangePanel, (Msg)DesignerMsg.MAX));
        this.maxCriticalRangeSpinner = this.createFinishSpinner((UiContainer)criticalRangePanel, criticalRange);
        criticalRangePanel.add(this.maxCriticalRangeSpinner);
        this.criticalRangeColor = new ColorChoosingComponent((UiContainer)criticalRangePanel, Color.valueOf((ColorInfo)this.widgetPresentationModel.getCriticalRangeColor()));
        this.criticalRangeColor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GaugePropertiesPanel.this.widgetPresentationModel.asMutable().setCriticalRangeColor(GaugePropertiesPanel.this.criticalRangeColor.getSelectedColor().getInfo());
            }
        });
        criticalRangePanel.add((UiComponent)this.criticalRangeColor);
        return criticalRangePanel;
    }

    private Panel buildWarningRangePanel() {
        Panel warningRangePanel = new Panel((UiContainer)this, CoreMsg.WARNING);
        warningRangePanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        BusinessVariableData.Range warningRange = this.widgetPresentationModel.getWarningRange();
        warningRangePanel.add((UiComponent)Label.create((UiContainer)warningRangePanel, (Msg)DesignerMsg.MIN));
        this.minWarningRangeSpinner = this.createStartSpinner((UiContainer)warningRangePanel, warningRange);
        warningRangePanel.add(this.minWarningRangeSpinner);
        warningRangePanel.add((UiComponent)Label.create((UiContainer)warningRangePanel, (Msg)DesignerMsg.MAX));
        this.maxWarningRangeSpinner = this.createFinishSpinner((UiContainer)warningRangePanel, warningRange);
        warningRangePanel.add(this.maxWarningRangeSpinner);
        this.warningRangeColor = new ColorChoosingComponent((UiContainer)warningRangePanel, Color.valueOf((ColorInfo)this.widgetPresentationModel.getWarningRangeColor()));
        this.warningRangeColor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GaugePropertiesPanel.this.widgetPresentationModel.asMutable().setWarningRangeColor(GaugePropertiesPanel.this.warningRangeColor.getSelectedColor().getInfo());
            }
        });
        warningRangePanel.add((UiComponent)this.warningRangeColor);
        return warningRangePanel;
    }

    private Panel buildNormalRangePanel() {
        Panel normalRangePanel = new Panel((UiContainer)this, ProjectMsg.NORMAL);
        normalRangePanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        BusinessVariableData.Range normalRange = this.widgetPresentationModel.getNormalRange();
        normalRangePanel.add((UiComponent)Label.create((UiContainer)normalRangePanel, (Msg)DesignerMsg.MIN));
        this.minNormalRangeSpinner = this.createStartSpinner((UiContainer)normalRangePanel, normalRange);
        normalRangePanel.add(this.minNormalRangeSpinner);
        normalRangePanel.add((UiComponent)Label.create((UiContainer)normalRangePanel, (Msg)DesignerMsg.MAX));
        this.maxNormalRangeSpinner = this.createFinishSpinner((UiContainer)normalRangePanel, normalRange);
        normalRangePanel.add(this.maxNormalRangeSpinner);
        this.normalRangeColor = new ColorChoosingComponent((UiContainer)normalRangePanel, Color.valueOf((ColorInfo)this.widgetPresentationModel.getNormalRangeColor()));
        this.normalRangeColor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GaugePropertiesPanel.this.widgetPresentationModel.asMutable().setNormalRangeColor(GaugePropertiesPanel.this.normalRangeColor.getSelectedColor().getInfo());
            }
        });
        normalRangePanel.add((UiComponent)this.normalRangeColor);
        return normalRangePanel;
    }

    private Panel buildTotalRangePanel() {
        Panel totalRangePanel = new Panel((UiContainer)this, DesignerMsg.TOTAL_RANGE);
        totalRangePanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        BusinessVariableData.Range totalRange = this.widgetPresentationModel.getTotalRange();
        totalRangePanel.add((UiComponent)Label.create((UiContainer)totalRangePanel, (Msg)DesignerMsg.MIN));
        this.minTotalRangeSpinner = this.createStartSpinner((UiContainer)totalRangePanel, totalRange);
        totalRangePanel.add(this.minTotalRangeSpinner);
        totalRangePanel.add((UiComponent)Label.create((UiContainer)totalRangePanel, (Msg)DesignerMsg.MAX));
        this.maxTotalRangeSpinner = this.createFinishSpinner((UiContainer)totalRangePanel, totalRange);
        totalRangePanel.add(this.maxTotalRangeSpinner);
        return totalRangePanel;
    }

    private Panel buildValuePanel() {
        Panel valuePanel = new Panel((UiContainer)this, DesignerMsg.VALUE);
        FontInfo valueFont = this.widgetPresentationModel.getValueFont();
        this.valueFontChooser = new FontPanel((UiContainer)valuePanel, Font.valueOf((FontInfo)valueFont), Color.valueOf((ColorInfo)this.widgetPresentationModel.getForegroundColor()), Color.valueOf((ColorInfo)this.widgetPresentationModel.getValueColor()), false, true, false, valueFont.getSize());
        this.valueFontChooser.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (GaugePropertiesPanel.this.doFireEvents) {
                    GaugePropertiesPanel.this.widgetPresentationModel.asMutable().setValueFont(GaugePropertiesPanel.this.valueFontChooser.getCurrentFont().getInfo());
                    GaugePropertiesPanel.this.widgetPresentationModel.asMutable().setValueColor(GaugePropertiesPanel.this.valueFontChooser.getForegroundColor().getInfo());
                }
            }
        });
        valuePanel.add((UiComponent)this.valueFontChooser);
        return valuePanel;
    }

    private Panel buildForegroundPanel() {
        Panel foregroundPanel = new Panel((UiContainer)this, DesignerMsg.FOREGROUND);
        foregroundPanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.foregroundColorLabel = Label.create((UiContainer)foregroundPanel, (Msg)DesignerMsg.COLOR);
        this.foregroundChooser = new ColorChoosingComponent((UiContainer)foregroundPanel, FOREGROUND_DEFAULT_COLOR);
        this.foregroundChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GaugePropertiesPanel.this.widgetPresentationModel.asMutable().setForegroundColor(GaugePropertiesPanel.this.foregroundChooser.getSelectedColor().getInfo());
            }
        });
        foregroundPanel.add((UiComponent)this.foregroundColorLabel);
        foregroundPanel.add((UiComponent)this.foregroundChooser);
        return foregroundPanel;
    }
}

