/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.designer.dashboardwizards.components.SeriesColorChooser;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

public class WidgetSeriesColorPanel
extends Panel {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private SeriesColorChooser seriesColorTable;
    private static final int SERIE = 0;

    public WidgetSeriesColorPanel(UiContainer parent, WidgetPresentationModel widgetModel) {
        super(parent);
        this.initGui(widgetModel);
    }

    public List<ColorInfo> getColorList() {
        return this.seriesColorTable.getSeriesColorModel().getColors();
    }

    public void setEnabled(boolean enabled) {
        this.seriesColorTable.setEnabled(enabled);
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void reload(final WidgetPresentationModel widgetModel) {
        this.seriesColorTable.setModel(widgetModel.getSeriesColor());
        this.seriesColorTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                widgetModel.asMutable().setSeriesColor(WidgetSeriesColorPanel.this.seriesColorTable.getColorList());
            }
        });
    }

    private void initGui(final WidgetPresentationModel widgetModel) {
        Panel mainPanel = new Panel((UiContainer)this);
        mainPanel.setLayout((Layout)new FormLayout("default", "pref, 2dlu, pref"));
        CellConstraints cc = new CellConstraints();
        Panel tablePanel = new Panel((UiContainer)mainPanel);
        tablePanel.setLayout((Layout)new BorderLayout());
        this.seriesColorTable = new SeriesColorChooser((UiContainer)tablePanel, widgetModel.getSeriesColor());
        this.seriesColorTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                widgetModel.asMutable().setSeriesColor(WidgetSeriesColorPanel.this.seriesColorTable.getColorList());
            }
        });
        this.seriesColorTable.getColumn(0).setWidth(100);
        Panel buttonsPanel = new Panel((UiContainer)mainPanel);
        buttonsPanel.setLayout((Layout)new FlowLayout(0, 3, 0));
        Button addButton = new Button((UiContainer)buttonsPanel, (BaseAction)this.seriesColorTable.getAddAction((UiComponent)this));
        addButton.setOptions(-2);
        addButton.setContentAreaFilled(false);
        this.makeButtonFocusable(addButton);
        buttonsPanel.add((UiComponent)addButton);
        Button removeButton = new Button((UiContainer)buttonsPanel, (BaseAction)this.seriesColorTable.getRemoveAction((UiComponent)this));
        removeButton.setOptions(-2);
        removeButton.setContentAreaFilled(false);
        this.makeButtonFocusable(removeButton);
        buttonsPanel.add((UiComponent)removeButton);
        tablePanel.add((UiComponent)this.seriesColorTable, (Object)"Center");
        mainPanel.add((UiComponent)buttonsPanel, (Object)cc.xy(1, 1));
        mainPanel.add((UiComponent)tablePanel, (Object)cc.xy(1, 3, "center, top"));
        this.add((UiComponent)mainPanel);
    }

    private void makeButtonFocusable(final Button button) {
        button.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
        button.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                button.setBorder(BorderFactory.createLineBorder((Color)Color.FUEGO_BLUE));
            }

            public void focusLost(FocusEvent e) {
                button.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
            }
        });
    }
}

