/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.List;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;

public class SeriesColorChooser
extends Table {
    private DesignerAction addAction;
    private DesignerAction removeAction;
    public static final int SERIES_NUMBER_COLUMN = 0;
    public static final int SERIES_COLOR = 1;

    public SeriesColorChooser(UiContainer parent, List<ColorInfo> colorList) {
        super(parent, ListSelectionMode.SINGLE_SELECTION);
        this.setModel(colorList);
        this.setCellSelectionEnabled(false);
        TableColumn column = this.getColumn(1);
    }

    public void setModel(List<ColorInfo> colorList) {
        this.setModel((TableModel)new SeriesColorModel(colorList));
        TableColumn column = this.getColumn(1);
        column.setCellEditor((TableCellEditor)new ColorEditor());
        LabelAndColorProvider colorProvider = new LabelAndColorProvider();
        column.setLabelProvider((LabelProvider)colorProvider);
        column.setColorProvider((ColorProvider)colorProvider);
        ((SeriesColorModel)this.getModel()).reload();
    }

    public DesignerAction getAddAction(UiComponent parent) {
        if (this.addAction == null) {
            this.addAction = new DesignerAction(UIMsg.ADD){

                @Override
                public boolean doIt() {
                    SeriesColorChooser.this.getSeriesColorModel().addColor(ColorInfo.WHITE);
                    int row = SeriesColorChooser.this.getModel().getRowCount();
                    SeriesColorChooser.this.setSelectionInterval(row, row);
                    return true;
                }

                public void unDoIt() {
                }
            };
        }
        return this.addAction;
    }

    public List<ColorInfo> getColorList() {
        return this.getSeriesColorModel().getColors();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addAction.setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
    }

    public DesignerAction getRemoveAction(final UiComponent parent) {
        if (this.removeAction == null) {
            this.removeAction = new DesignerAction(UIMsg.REMOVE){

                @Override
                public boolean doIt() {
                    int row = SeriesColorChooser.this.getSelectedRow();
                    if (row != -1) {
                        SeriesColorChooser.this.getSeriesColorModel().removeColor(row);
                        parent.revalidate();
                        if (SeriesColorChooser.this.getRowCount() != 0) {
                            int rowToSelect = row - 1 > 0 ? row - 1 : 0;
                            SeriesColorChooser.this.setSelectionInterval(rowToSelect, rowToSelect);
                        }
                    }
                    return true;
                }

                public void unDoIt() {
                }
            };
        }
        if (this.getSelectedRow() == -1) {
            this.removeAction.setEnabled(false);
        }
        return this.removeAction;
    }

    public SeriesColorModel getSeriesColorModel() {
        return (SeriesColorModel)this.getModel();
    }

    private static Panel createCenteredColorBox(UiComponent colorBox, final Panel editorPanel) {
        String cols = "0dlu:grow, pref, 0dlu:grow";
        String rows = "0dlu:grow, pref, 0dlu:grow";
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(editorPanel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add(colorBox, cc.xy(2, 2));
        editorPanel.setOpaque(false);
        editorPanel.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                editorPanel.setOpaque(true);
                editorPanel.setBackground(Color.FUEGO_LIGHT_BLUE);
                editorPanel.setBorder(BorderFactory.createLineBorder((Color)Color.RED));
            }

            public void focusLost(FocusEvent e) {
                editorPanel.setOpaque(false);
            }
        });
        return editorPanel;
    }

    private static class LabelAndColorProvider
    extends LabelProvider.Default<Color>
    implements ColorProvider<Color> {
        private static final Color NO_COLOR = Color.WHITE;

        private LabelAndColorProvider() {
        }

        public String getText(Color color) {
            if (color == null) {
                return UIMsg.PROPERTY_NO_COLOR.getString();
            }
            return "[ r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue() + " ]";
        }

        public Color getBackground(Color element) {
            return null;
        }

        public Color getForeground(Color color) {
            return color == null ? NO_COLOR : color;
        }
    }

    private static class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ColorChoosingComponent editor;

        private ColorEditor() {
        }

        public Object getCellEditorValue() {
            return this.editor.getSelectedColor();
        }

        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)parent, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            Panel editorPanel = new Panel(parent);
            this.editor = new ColorChoosingComponent((UiContainer)editorPanel, DesignerMsg.SERIES_COLOR, Color.WHITE, true, true, true){

                public void setSelectedColor(Color color, boolean updateRGBTextfield) {
                    super.setSelectedColor(color, updateRGBTextfield);
                    ColorEditor.this.fireEditingStopped();
                }
            };
            SeriesColorChooser.createCenteredColorBox((UiComponent)this.editor, editorPanel);
            return editorPanel;
        }
    }

    public static class SeriesColorModel
    extends AbstractTableModel {
        private List<ColorInfo> colors;
        public static final int COLUMN_NUMBER = 2;

        public SeriesColorModel(List<ColorInfo> colors) {
            this.colors = colors;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            boolean result = false;
            if (columnIndex == 1) {
                result = true;
            }
            return result;
        }

        public List<ColorInfo> getColors() {
            return this.colors;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            String result = "";
            switch (column) {
                case 0: {
                    result = DesignerMsg.SERIE.getString();
                    break;
                }
                case 1: {
                    result = DesignerMsg.COLOR.getString();
                }
            }
            return result;
        }

        public int getRowCount() {
            return this.colors.size();
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                this.colors.set(rowIndex, (ColorInfo)value);
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object result = null;
            switch (columnIndex) {
                case 0: {
                    result = rowIndex;
                    break;
                }
                case 1: {
                    result = this.colors.get(rowIndex);
                }
            }
            return result;
        }

        public void reload() {
            this.fireTableStructureChanged();
        }

        public void addColor(ColorInfo color) {
            this.colors.add(color);
            this.fireTableRowsInserted(this.colors.size(), this.colors.size());
        }

        public void removeColor(int index) {
            this.colors.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

