/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.ColumnSpec;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.RowSpec;

public class RadioPanel
extends Panel {
    private int distribution;
    private FormLayout layout;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int[] oddDistribution;
    private Map<Enum, RadioButton> radios = new TreeMap<Enum, RadioButton>();
    private Enum selectedEnum;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public RadioPanel(UiContainer parent, Enum enumeration, int distribution) {
        this(parent, enumeration, distribution, null);
    }

    public RadioPanel(UiContainer parent, Enum enumeration, int distribution, int[] oddDistribution) {
        super(parent);
        this.selectedEnum = enumeration;
        this.distribution = distribution;
        this.oddDistribution = oddDistribution;
        String columns = "left:pref";
        this.layout = new FormLayout(columns);
        this.setLayout((Layout)this.layout);
        this.layoutRadios();
    }

    public Enum getSelectedEnum() {
        return this.selectedEnum;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void selectEnum(Enum enumeration) {
        RadioButton radio = this.radios.get(enumeration);
        radio.setSelected(true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        List components = this.getComponents();
        for (UiComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    public void enableEnum(Enum enumeration, boolean enable) {
        RadioButton radio = this.radios.get(enumeration);
        radio.setEnabled(enable);
        if (!enable && radio.isSelected()) {
            Enum defaultEnum = this.getEnumMembers()[0];
            this.selectEnum(defaultEnum);
        }
    }

    public void enableEnums(List enums, boolean enable) {
        for (Object anEnum : enums) {
            this.enableEnum((Enum)anEnum, enable);
        }
    }

    void fireItemSelected() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private Enum[] getEnumMembers() {
        return (Enum[])this.selectedEnum.getClass().getEnumConstants();
    }

    private void addRadio(RadioButton radio) {
        if (this.distribution == 1) {
            if (this.oddDistribution != null && this.oddDistribution.length != 0) {
                boolean isNewColumn;
                int numberOfLayedOutRadios = this.radios.size() - 1;
                int actualLine = -1;
                int rowNumber = this.layout.getRowCount();
                for (int i = 0; i < this.oddDistribution.length; ++i) {
                    if (numberOfLayedOutRadios >= this.oddDistribution[i]) {
                        numberOfLayedOutRadios -= this.oddDistribution[i];
                        continue;
                    }
                    rowNumber = numberOfLayedOutRadios * 2 + 1;
                    actualLine = i;
                    break;
                }
                boolean bl = isNewColumn = numberOfLayedOutRadios <= 0 || actualLine == -1;
                if (isNewColumn && actualLine != 0) {
                    this.layout.appendColumn(new ColumnSpec("left:15dlu"));
                    this.layout.appendColumn(new ColumnSpec("left:pref"));
                }
                this.layout.appendRow(new RowSpec("pref"));
                this.add((UiComponent)radio, new CellConstraints(this.layout.getColumnCount(), rowNumber));
                this.layout.appendRow(new RowSpec("fill:2dlu:g(0.2)"));
            } else {
                this.layout.appendRow(new RowSpec("pref"));
                this.add((UiComponent)radio, new CellConstraints(this.layout.getColumnCount(), this.layout.getRowCount()));
                this.layout.appendRow(new RowSpec("fill:2dlu:g(0.2)"));
            }
        } else if (this.oddDistribution != null && this.oddDistribution.length != 0) {
            int numberOfLayedOutRadios = this.radios.size() - 1;
            int actualLine = -1;
            int columnNumber = this.layout.getColumnCount();
            for (int i = 0; i < this.oddDistribution.length; ++i) {
                if (numberOfLayedOutRadios >= this.oddDistribution[i]) {
                    numberOfLayedOutRadios -= this.oddDistribution[i];
                    continue;
                }
                columnNumber = numberOfLayedOutRadios * 2 + 1;
                actualLine = i;
                break;
            }
            if (this.layout.getColumnCount() != 1) {
                if (numberOfLayedOutRadios <= 0 || actualLine == -1) {
                    this.layout.appendRow(new RowSpec("pref"));
                }
                this.layout.appendColumn(new ColumnSpec("left:pref"));
            } else {
                this.layout.appendRow(new RowSpec("pref"));
            }
            this.add((UiComponent)radio, new CellConstraints(columnNumber, this.layout.getRowCount()));
            this.layout.appendColumn(new ColumnSpec("fill:2dlu:g(0.2)"));
        } else {
            if (this.layout.getColumnCount() != 1) {
                this.layout.appendColumn(new ColumnSpec("left:pref"));
            } else {
                this.layout.appendRow(new RowSpec("pref"));
            }
            this.add((UiComponent)radio, new CellConstraints(this.layout.getColumnCount(), this.layout.getRowCount()));
            this.layout.appendColumn(new ColumnSpec("fill:2dlu:g(0.2)"));
        }
    }

    private void layoutRadios() {
        List<Enum> values = Arrays.asList(this.getEnumMembers());
        ButtonGroup group = new ButtonGroup();
        Iterator<Enum> i$ = values.iterator();
        while (i$.hasNext()) {
            Enum value;
            final Enum enumItem = value = i$.next();
            RadioButton radio = new RadioButton((UiContainer)this, this.getEnumName(enumItem));
            radio.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        RadioPanel.this.selectedEnum = enumItem;
                        RadioPanel.this.fireItemSelected();
                    }
                }
            });
            if (enumItem.equals(this.selectedEnum)) {
                radio.setSelected(true);
            }
            this.radios.put(enumItem, radio);
            group.add((AbstractButton)radio);
            this.addRadio(radio);
        }
    }

    private String getEnumName(Enum enumItem) {
        String name = ((I18nProvider)((Object)enumItem)).getString();
        return name.toLowerCase();
    }
}

