/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.MeasurementKind;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.project.dashboard.MeasurementFactoryImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;

public class MeasurementsCombo
extends ComboBox<Measurement> {
    public MeasurementsCombo(Project project, UiContainer parent) {
        this(parent, new MeasurementModel(project));
    }

    public MeasurementsCombo(Project project, UiContainer parent, WidgetType type, ProjectObject element, Process process) {
        this(parent, new MeasurementModel(project, type, element, process));
    }

    private MeasurementsCombo(UiContainer parent, MeasurementModel model) {
        super(parent, false);
        this.setModel(model);
        this.setLabelProvider((LabelProvider)new LabelProvider.Default<Measurement>(){

            public String getText(Measurement element) {
                String text = "";
                if (element != null) {
                    text = element.getKind() == MeasurementKind.BUSINESS_MEASUREMENT ? element.getVariableLabel() : element.getName();
                }
                return text;
            }
        });
    }

    public void reload(WidgetType type, Process process) {
        this.reload(type, null, process);
    }

    public void reload(WidgetType type, ProjectObject element, Process process) {
        ((MeasurementModel)this.getModel()).reload(type, element, process);
    }

    public void reload(WidgetType type) {
        this.reload(type, null, null);
    }

    public void updateMeasurement(Measurement measurement) {
        ((MeasurementModel)this.getModel()).updateMeasurement(measurement);
    }

    public static class MeasurementModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List measurements;
        private Project project;
        private int selectedMeasurement;

        public MeasurementModel(Project project) {
            this(project, new ArrayList());
        }

        public MeasurementModel(Project project, WidgetType type, ProjectObject element, Process process) {
            this(project, new MeasurementFactoryImpl(project).getMeasurementsFor(type, element, process));
        }

        private MeasurementModel(Project project, List list) {
            this.project = project;
            this.measurements = list;
            this.selectedMeasurement = -1;
        }

        @Override
        public Object getElementAt(int index) {
            return this.measurements.get(index);
        }

        public void updateMeasurement(Measurement measurement) {
            for (Object measurement1 : this.measurements) {
                Measurement measurementToUpdate = (Measurement)measurement1;
                if (measurement == null || !measurementToUpdate.getVarId().equals(measurement.getVarId())) continue;
                measurementToUpdate.setOperationType(measurement.getOperationType());
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedMeasurement = this.measurements.indexOf(anItem);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedMeasurement != -1 && this.measurements.size() != 0 ? this.measurements.get(this.selectedMeasurement) : null;
        }

        @Override
        public int getSize() {
            return this.measurements.size();
        }

        public void reload(WidgetType type, ProjectObject element, Process process) {
            this.measurements = new MeasurementFactoryImpl(this.project).getMeasurementsFor(type, element, process);
            this.selectedMeasurement = -1;
            this.fireIntervalAdded(this, 0, this.measurements.size());
        }
    }
}

