/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.xobject.GraphicType;

public class GraphSubtypeComboModel
extends AbstractListModel
implements ComboBoxModel {
    private int selectedSubtype;
    private List<GraphicType> subtypes;

    public GraphSubtypeComboModel(String type) {
        this.loadSubtypes(type);
        this.selectedSubtype = -1;
    }

    @Override
    public Object getElementAt(int index) {
        return index >= 0 && index < this.subtypes.size() ? this.subtypes.get(index) : null;
    }

    public boolean isEmpty() {
        return this.subtypes.size() == 0;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedSubtype = this.subtypes.indexOf(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedSubtype != -1 && this.subtypes.size() != 0 ? this.subtypes.get(this.selectedSubtype) : null;
    }

    @Override
    public int getSize() {
        return this.subtypes.size();
    }

    public void loadSubtypes(String type) {
        this.subtypes = GraphicType.getSubtypes(type);
        if (type.equals("XY")) {
            this.subtypes.addAll(GraphicType.getSubtypes("XYZ"));
        }
    }

    public void reloadSubtypes(String type) {
        this.loadSubtypes(type);
        this.selectedSubtype = -1;
        this.fireContentsChanged(this, 0, this.subtypes.size());
    }
}

