/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import fuego.papi.msg.PapiMsg;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.RowSpec;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.utils.FontUtils;

public class FontPanel
extends Panel {
    private Color backgroundColor;
    private ColorChoosingComponent backgroundColorChooser;
    private Font currentFont;
    private FontUtils.FontPreviewPanel fontPreview;
    private NumericField<Integer> fontSizeSpinner;
    private ComboBox fontStyleCombo;
    private ComboBox fontTypeCombo;
    private Color foregroundColor;
    private ColorChoosingComponent foregroundColorChooser;
    private Label foregroundColorLabel;
    private List<ChangeListener> listeners;
    private int scale;
    private boolean showBackgroundColor;
    private boolean showForegroundColor;
    private boolean showPreview;
    public static final int DEFAULT_SCALE = 1;
    public static final int DEFAULT_FONT_TYPE = 0;
    public static final String DEFAULT_FONT_FACE = "Verdana";
    public static final int DEFAULT_FONT_SIZE = 15;
    public static final int MAX_FONT_SIZE = 72;

    public FontPanel(UiContainer parent) {
        this(parent, Color.WHITE, Color.BLACK, true, true, true, 1);
    }

    public FontPanel(UiContainer parent, int scale) {
        this(parent, Color.WHITE, Color.BLACK, true, true, true, scale);
    }

    public FontPanel(UiContainer parent, Font font, Color background, Color foreground) {
        this(parent, font, background, foreground, true, true, true, 1);
    }

    public FontPanel(UiContainer parent, Color background, Color foreground, boolean showBackgroundColor, boolean showForegroundColor, boolean showPreview) {
        this(parent, background, foreground, showBackgroundColor, showForegroundColor, showPreview, 1);
    }

    public FontPanel(UiContainer parent, Color background, Color foreground, boolean showBackgroundColor, boolean showForegroundColor, boolean showPreview, int scale) {
        this(parent, Font.valueOf((FontInfo)FontInfo.valueOf(DEFAULT_FONT_FACE, 0, 15)), background, foreground, showBackgroundColor, showForegroundColor, showPreview, scale);
    }

    public FontPanel(UiContainer parent, Font font, Color background, Color foreground, boolean showBackgroundColor, boolean showForegroundColor, boolean showPreview, int scale) {
        super(parent);
        this.currentFont = font;
        this.scale = scale;
        this.listeners = new ArrayList<ChangeListener>();
        this.backgroundColor = background;
        this.foregroundColor = foreground;
        this.showPreview = showPreview;
        this.showBackgroundColor = showBackgroundColor;
        this.showForegroundColor = showForegroundColor;
        this.fontTypeCombo = FontUtils.createDefaultFamily((UiContainer)this);
        this.fontTypeCombo.setSelectedItem((Object)this.currentFont.getFamily());
        this.fontStyleCombo = UiFactory.createComboBox((UiContainer)this, (Object[])FontStyle.values());
        this.fontStyleCombo.setSelectedItem((Object)this.currentFont.getStyle());
        this.fontSizeSpinner = NumericField.createIntegerNumericField((UiContainer)this);
        this.fontSizeSpinner.setRange((Number)0, (Number)72);
        this.fontSizeSpinner.setStepSize((Number)1);
        this.fontSizeSpinner.setValue((Number)this.currentFont.getSize());
        this.addFontChangedListeners();
        if (showBackgroundColor) {
            this.backgroundColorChooser = new ColorChoosingComponent((UiContainer)this, this.backgroundColor);
            this.backgroundColorChooser.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    FontPanel.this.backgroundColor = FontPanel.this.backgroundColorChooser.getSelectedColor();
                    FontPanel.this.fontPreview.updatePreview(FontPanel.this.backgroundColor, FontPanel.this.foregroundColor);
                    FontPanel.this.fireValueChanged();
                }
            });
        }
        if (showForegroundColor) {
            this.foregroundColorChooser = new ColorChoosingComponent((UiContainer)this, this.foregroundColor);
            this.foregroundColorChooser.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    FontPanel.this.foregroundColor = FontPanel.this.foregroundColorChooser.getSelectedColor();
                    if (FontPanel.this.fontPreview != null) {
                        FontPanel.this.fontPreview.updatePreview(FontPanel.this.backgroundColor, FontPanel.this.foregroundColor);
                    }
                    FontPanel.this.fireValueChanged();
                }
            });
        }
        this.layoutComponents();
    }

    public void enableForegroundColor(boolean enable) {
        this.foregroundColorChooser.setEnabled(enable);
        this.foregroundColorLabel.setEnabled(enable);
    }

    public void setEnabled(boolean enabled) {
        this.fontSizeSpinner.setEnabled(enabled);
        this.fontStyleCombo.setEnabled(enabled);
        this.fontTypeCombo.setEnabled(enabled);
        if (this.foregroundColorChooser != null) {
            this.foregroundColorChooser.setEnabled(enabled);
        }
        if (this.backgroundColorChooser != null) {
            this.backgroundColorChooser.setEnabled(enabled);
        }
        if (this.fontPreview != null) {
            this.fontPreview.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setCurrentFont(Font currentFont) {
        this.currentFont = currentFont == null ? Font.valueOf((FontInfo)FontInfo.valueOf(DEFAULT_FONT_FACE, 0, 15)) : currentFont;
        this.fontSizeSpinner.setValue((Number)this.currentFont.getSize());
        this.fontStyleCombo.setSelectedItem((Object)this.currentFont.getStyle());
        this.fontTypeCombo.setSelectedItem((Object)this.currentFont.getFamily());
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    public FontUtils.FontPreviewPanel getFontPreview(UiContainer parent) {
        Font previewFont = this.currentFont.scale(1.0f / (float)this.scale);
        this.fontPreview = FontUtils.createFontPreviewPanel((UiContainer)parent, (Font)previewFont, (Color)this.backgroundColor, (Color)this.foregroundColor);
        this.fontPreview.setPreferredSize(Dimension.valueOf(400 / this.scale, 100 / this.scale));
        this.fontPreview.setBorder(null);
        return this.fontPreview;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void changePreviewedText(String text) {
        this.fontPreview.setTextToPreview(text);
    }

    public void fireValueChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    public void layoutComponents() {
        String columns = "0dlu, pref, 2dlu, pref, 0dlu";
        String rows = "fill:2dlu:grow";
        FormLayout layout = new FormLayout("0dlu, pref, 2dlu, pref, 0dlu", "fill:2dlu:grow");
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        layout.appendRow(new RowSpec("fill:2dlu:grow"));
        layout.appendRow(new RowSpec("pref"));
        Label fontTypeLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.FONT);
        this.add((UiComponent)fontTypeLabel, cc.xy(2, layout.getRowCount()));
        this.add((UiComponent)this.fontTypeCombo, cc.xy(4, layout.getRowCount()));
        layout.appendRow(new RowSpec("fill:2dlu:grow"));
        layout.appendRow(new RowSpec("pref"));
        Label fontStyleLabel = Label.create((UiContainer)this, (Msg)UIMsg.STYLE);
        this.add((UiComponent)fontStyleLabel, cc.xy(2, layout.getRowCount()));
        this.add((UiComponent)this.fontStyleCombo, cc.xy(4, layout.getRowCount()));
        layout.appendRow(new RowSpec("fill:2dlu:grow"));
        layout.appendRow(new RowSpec("pref"));
        Label fontSizeLabel = Label.create((UiContainer)this, (Msg)PapiMsg.SIZE);
        this.add((UiComponent)fontSizeLabel, cc.xy(2, layout.getRowCount()));
        this.add((UiComponent)this.fontSizeSpinner, cc.xy(4, layout.getRowCount()));
        if (this.showBackgroundColor) {
            layout.appendRow(new RowSpec("fill:2dlu:grow"));
            layout.appendRow(new RowSpec("pref"));
            Label backgroundColorLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.BACKGROUND);
            this.add((UiComponent)backgroundColorLabel, cc.xy(2, layout.getRowCount()));
            this.add((UiComponent)this.backgroundColorChooser, cc.xy(4, layout.getRowCount()));
        }
        if (this.showForegroundColor) {
            layout.appendRow(new RowSpec("fill:2dlu:grow"));
            layout.appendRow(new RowSpec("pref"));
            this.foregroundColorLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.FOREGROUND);
            this.add((UiComponent)this.foregroundColorLabel, cc.xy(2, layout.getRowCount()));
            this.add((UiComponent)this.foregroundColorChooser, cc.xy(4, layout.getRowCount()));
        }
        if (this.showPreview) {
            layout.appendRow(new RowSpec("fill:2dlu:grow"));
            layout.appendRow(new RowSpec("pref"));
            this.add((UiComponent)this.getFontPreview((UiContainer)this), cc.xywh(2, layout.getRowCount(), 3, 1));
        }
        layout.appendRow(new RowSpec("fill:2dlu:grow"));
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColorChooser.setSelectedColor(backgroundColor);
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColorChooser.setSelectedColor(foregroundColor);
    }

    private void addFontChangedListeners() {
        this.fontTypeCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    String fontType = (String)e.getItem();
                    FontPanel.this.currentFont = Font.valueOf((String)fontType, (FontStyle)FontPanel.this.currentFont.getStyle(), (int)FontPanel.this.currentFont.getSize());
                    if (FontPanel.this.fontPreview != null) {
                        FontPanel.this.fontPreview.updatePreview(FontPanel.this.currentFont);
                    }
                    FontPanel.this.fireValueChanged();
                }
            }
        });
        this.fontStyleCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    FontPanel.this.currentFont = FontPanel.this.currentFont.applyStyle((FontStyle)e.getItem());
                    if (FontPanel.this.fontPreview != null) {
                        FontPanel.this.fontPreview.updatePreview(FontPanel.this.currentFont);
                    }
                    FontPanel.this.fireValueChanged();
                }
            }
        });
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FontPanel.this.currentFont = FontPanel.this.currentFont.resize(((Integer)FontPanel.this.fontSizeSpinner.getValue()).intValue());
                if (FontPanel.this.fontPreview != null) {
                    FontPanel.this.fontPreview.updatePreview(FontPanel.this.currentFont.scale(1.0f / (float)FontPanel.this.scale));
                }
                FontPanel.this.fireValueChanged();
            }
        });
    }
}

