/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionKind;
import oracle.bpm.dashboard.model.DimensionType;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.dashboard.DimensionFactoryImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.TableCellEditor;

public class DimensionsTable
extends Table {
    public DimensionsTable(Project project, UiContainer parent, List<Dimension> dimensions) {
        this(parent, new DimensionTableModel(project, dimensions));
    }

    public DimensionsTable(Project project, UiContainer parent, WidgetType type, ProjectObject element, Process process, List<Dimension> dimensions) {
        this(parent, new DimensionTableModel(project, type, element, process, dimensions));
    }

    private DimensionsTable(UiContainer parent, DimensionTableModel model) {
        super(parent, (TableModel)model);
        this.setDefaultLabelProvider(DimensionType.class, (LabelProvider)new DimensionTableModel.StateTableLabelProvider());
        this.setDefaultEditor(DimensionType.class, new StateTableEditor());
    }

    public List<Dimension> getDimensionedDimensions() {
        return ((DimensionTableModel)this.getModel()).getDimensionedDimensions();
    }

    public void reload(WidgetType type, ProjectObject element, Process process) {
        ((DimensionTableModel)this.getModel()).reload(type, element, process, null);
    }

    public void reload(WidgetType type) {
        this.reload(type, null, null);
    }

    public void reload(WidgetType type, ProjectObject element, Process selectedProcess, List<Dimension> dimensions) {
        ((DimensionTableModel)this.getModel()).reload(type, element, selectedProcess, dimensions);
    }

    private static class StateTableEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBox editor;

        private StateTableEditor() {
        }

        public UiComponent getTableCellEditor(Table component, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)component, value);
        }

        public Object getCellEditorValue() {
            return this.editor.getSelectedItem();
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.editor = StateTableEditor.createStateEditor(parent);
            this.editor.setSelectedItem(value);
            return this.editor;
        }

        private static ComboBox createStateEditor(UiContainer parent) {
            ComboBox editor = UiFactory.createComboBox((UiContainer)parent, (Object[])DimensionType.values());
            editor.setLabelProvider((LabelProvider)new LabelProvider.Default<DimensionType>(){

                public String getText(DimensionType element) {
                    return String.valueOf(element).toLowerCase();
                }
            });
            return editor;
        }
    }

    public static class DimensionTableModel
    extends AbstractTableModel {
        private List<Dimension> dimensions;
        private List<Dimension> nonTotalizedDimensions;
        private Project project;
        private static final int NUMBER_OF_COLUMNS = 2;
        protected static final int TYPE = 1;
        protected static final int DIMENSION_NAME = 0;

        public DimensionTableModel(Project project, List<Dimension> dimensionedDimensions) {
            this.project = project;
            this.dimensions = new ArrayList<Dimension>();
            this.nonTotalizedDimensions = new ArrayList<Dimension>();
            this.loadDimensions(dimensionedDimensions);
        }

        public DimensionTableModel(Project project, WidgetType type, ProjectObject element, Process process, List<Dimension> dimensionedDimensions) {
            this.project = project;
            this.dimensions = new DimensionFactoryImpl(project).getDimensionsFor(type, element, process);
            this.nonTotalizedDimensions = new ArrayList<Dimension>();
            this.loadDimensions(dimensionedDimensions);
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            boolean result = false;
            switch (columnIndex) {
                case 1: {
                    result = true;
                    break;
                }
                case 0: {
                    result = false;
                }
            }
            return result;
        }

        public Class getColumnClass(int columnIndex) {
            Class columnClass = null;
            switch (columnIndex) {
                case 1: {
                    columnClass = DimensionType.class;
                    break;
                }
                case 0: {
                    columnClass = String.class;
                }
            }
            return columnClass;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            String columnName = "";
            switch (column) {
                case 1: {
                    columnName = DesignerMsg.STATE.toString();
                    break;
                }
                case 0: {
                    columnName = DesignerMsg.NAME.toString();
                }
            }
            return columnName;
        }

        public List<Dimension> getDimensionedDimensions() {
            return this.nonTotalizedDimensions;
        }

        public int getDimensionsQuantity() {
            return this.nonTotalizedDimensions.size();
        }

        public int getRowCount() {
            return this.dimensions.size();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Dimension dimension = this.dimensions.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    DimensionType dimensionType = (DimensionType)aValue;
                    dimension.setDimensionType(dimensionType);
                    if (dimensionType.equals((Object)DimensionType.DIMENSION)) {
                        this.nonTotalizedDimensions.add(dimension);
                        break;
                    }
                    if (this.nonTotalizedDimensions.indexOf(dimension) == -1) break;
                    this.nonTotalizedDimensions.remove(dimension);
                }
            }
            this.fireTableDataChanged();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Dimension dimension = this.dimensions.get(rowIndex);
            Object result = null;
            switch (columnIndex) {
                case 1: {
                    result = dimension.getDimensionType();
                    break;
                }
                case 0: {
                    if (dimension.getKind() == DimensionKind.BUSINESS_DIMENSION) {
                        dimension.getVariableLabel();
                        break;
                    }
                    result = dimension.getName();
                }
            }
            return result;
        }

        public void reload(WidgetType type, ProjectObject element, Process process, List<Dimension> dimensionedDimensions) {
            this.dimensions = new DimensionFactoryImpl(this.project).getDimensionsFor(type, element, process);
            if (this.dimensions != null) {
                this.loadDimensions(dimensionedDimensions);
            }
            this.fireTableDataChanged();
        }

        private void loadDimensions(List<Dimension> dimensionedDimensions) {
            if (dimensionedDimensions != null) {
                for (int i = 0; i < this.dimensions.size(); ++i) {
                    Dimension dimension = this.dimensions.get(i);
                    for (Dimension dimensionedDimension : dimensionedDimensions) {
                        Dimension dimensionedDim = dimensionedDimension;
                        if (!dimensionedDim.getKind().equals((Object)dimension.getKind())) continue;
                        this.dimensions.set(i, dimensionedDim);
                    }
                }
                this.nonTotalizedDimensions = dimensionedDimensions;
            }
        }

        public static class StateTableLabelProvider
        extends LabelProvider.Default {
            public String getText(Object element) {
                return String.valueOf(element).toLowerCase();
            }
        }
    }
}

