/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionKind;
import oracle.bpm.dashboard.model.DimensionType;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListModelComboBoxModel;
import oracle.bpm.ui.MutableListListModel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;

public class DimensionChooser
extends Panel {
    boolean fireEvents;
    private List<ChangeListener> listeners;
    private WidgetDataModel model;
    private ComboBox<Dimension> serieDimensionComboBox;
    private ComboBox<Dimension> xDimensionComboBox;

    public DimensionChooser(UiContainer parent, WidgetDataModel model) {
        super(parent);
        this.model = model;
        String columns = "pref, 25dlu, 100dlu";
        String rows = "pref, 2dlu, pref";
        this.setLayout((Layout)new FormLayout(columns, rows));
        CellConstraints cc = new CellConstraints();
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.XAXIS), cc.xy(1, 1));
        this.buildXDimensionCombo();
        this.add((UiComponent)this.xDimensionComboBox, cc.xy(3, 1));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.SERIE), cc.xy(1, 3));
        this.buildSeriesDimensionCombo();
        this.add((UiComponent)this.serieDimensionComboBox, cc.xy(3, 3));
    }

    public void setModel(WidgetDataModel model) {
        this.model = model;
    }

    public void reload() {
        this.fireEvents = false;
        ListModelComboBoxModel listModelComboBoxModel = new ListModelComboBoxModel((ListModel)new MutableListListModel(this.model.getAvailableDimensionsForX()));
        this.xDimensionComboBox.setModel((ComboBoxModel)listModelComboBoxModel);
        this.xDimensionComboBox.setSelectedItem(listModelComboBoxModel.getSelectedItem());
        listModelComboBoxModel = new ListModelComboBoxModel((ListModel)new MutableListListModel(this.model.getAvailableDimensionsForSerie()));
        this.serieDimensionComboBox.setModel((ComboBoxModel)listModelComboBoxModel);
        this.serieDimensionComboBox.setSelectedItem(listModelComboBoxModel.getSelectedItem());
        this.fireEvents = true;
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(listener);
    }

    public int getDimensionQuantity() {
        return this.model.getDimensions().size();
    }

    public int getDimensionsQuantity() {
        DimensionKind selectionKind;
        int result = 0;
        Dimension xSelection = (Dimension)this.xDimensionComboBox.getSelectedItem();
        if (xSelection != null && (selectionKind = xSelection.getKind()) != null && selectionKind.equals((Object)DimensionKind.NONE)) {
            DimensionKind seriesKind;
            result = 1;
            Dimension seriesSelection = (Dimension)this.serieDimensionComboBox.getSelectedItem();
            if (seriesSelection != null && (seriesKind = seriesSelection.getKind()) != null && seriesKind.equals((Object)DimensionKind.NONE)) {
                result = 2;
            }
        }
        return result;
    }

    public void setSelectedXDimension(Dimension dimension) {
        this.fireEvents = false;
        this.xDimensionComboBox.setSelectedItem((Object)dimension);
        this.fireEvents = true;
    }

    public void setSelectedSeriesDimension(Dimension dimension) {
        this.fireEvents = false;
        this.serieDimensionComboBox.setSelectedItem((Object)dimension);
        this.serieDimensionComboBox.setEnabled(true);
        this.fireEvents = true;
    }

    public List<Dimension> getDimensions() {
        DimensionKind selectionKind;
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        Dimension xSelection = (Dimension)this.xDimensionComboBox.getSelectedItem();
        if (xSelection != null && (selectionKind = xSelection.getKind()) != null && selectionKind.equals((Object)DimensionKind.NONE)) {
            DimensionKind seriesKind;
            result.add(xSelection);
            Dimension seriesSelection = (Dimension)this.serieDimensionComboBox.getSelectedItem();
            if (seriesSelection != null && (seriesKind = seriesSelection.getKind()) != null && seriesKind.equals((Object)DimensionKind.NONE)) {
                result.add(seriesSelection);
            }
        }
        return result;
    }

    private void buildSeriesDimensionCombo() {
        this.serieDimensionComboBox = UiFactory.createComboBox((UiContainer)this);
        this.serieDimensionComboBox.setLabelProvider(this.getRenderer());
        this.serieDimensionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (DimensionChooser.this.fireEvents && e.isStateSelected()) {
                    List dimensions = DimensionChooser.this.model.asMutable().getDimensions();
                    Dimension dimension = (Dimension)e.getItem();
                    if (dimension != null && !dimension.getKind().equals((Object)DimensionKind.NONE)) {
                        dimension.setDimensionType(DimensionType.DIMENSION);
                        if (dimensions.size() > 1) {
                            dimensions.set(1, dimension);
                        } else {
                            dimensions.add(dimension);
                        }
                    } else if (dimensions.size() > 1) {
                        dimensions.remove(1);
                    }
                    DimensionChooser.this.model.asMutable().setDimensions(dimensions);
                    DimensionChooser.this.fireChangeEvent();
                }
            }
        });
        this.serieDimensionComboBox.setEnabled(false);
    }

    private void buildXDimensionCombo() {
        this.xDimensionComboBox = UiFactory.createComboBox((UiContainer)this);
        this.xDimensionComboBox.setLabelProvider(this.getRenderer());
        this.xDimensionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (DimensionChooser.this.fireEvents && e.isStateSelected()) {
                    List dimensions = DimensionChooser.this.model.asMutable().getDimensions();
                    Dimension dimension = (Dimension)e.getItem();
                    if (dimension != null) {
                        boolean none = dimension.getKind().equals((Object)DimensionKind.NONE);
                        if (!none) {
                            dimension.setDimensionType(DimensionType.DIMENSION);
                            if (dimensions.size() > 0) {
                                dimensions.set(0, dimension);
                            } else {
                                dimensions.add(dimension);
                            }
                        }
                        Dimension serieSelection = (Dimension)DimensionChooser.this.serieDimensionComboBox.getSelectedItem();
                        DimensionChooser.this.serieDimensionComboBox.setModel((ComboBoxModel)new ListModelComboBoxModel((ListModel)new MutableListListModel(DimensionChooser.this.model.getAvailableDimensionsForSerie())));
                        if (serieSelection != null) {
                            serieSelection.setDimensionType(DimensionType.TOTALIZED);
                            DimensionChooser.this.serieDimensionComboBox.setSelectedItem((Object)serieSelection);
                        }
                        if (none) {
                            DimensionChooser.this.serieDimensionComboBox.setSelectedIndex(0);
                            dimensions.clear();
                        }
                        DimensionChooser.this.serieDimensionComboBox.setEnabled(!none);
                        DimensionChooser.this.model.asMutable().setDimensions(dimensions);
                        DimensionChooser.this.fireChangeEvent();
                    }
                }
            }
        });
    }

    private LabelProvider<Dimension> getRenderer() {
        return new LabelProvider.Default<Dimension>(){

            public String getText(Dimension dimension) {
                String text = "";
                if (dimension != null) {
                    ProjectDataObject dataObject;
                    text = dimension.getKind() == DimensionKind.BUSINESS_DIMENSION ? ((dataObject = DimensionChooser.this.model.getProject().findDataObject(dimension.getVarId())) != null ? dataObject.getDefaultLabel() : "") : dimension.getName();
                }
                return text;
            }
        };
    }

    private void fireChangeEvent() {
        if (this.listeners != null) {
            for (ChangeListener listener : this.listeners) {
                listener.stateChanged(new ChangeEvent((Object)this));
            }
        }
    }
}

