/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.TextField;

public final class AxisChooser
extends Panel {
    private List<Dimension> dimensionList = new ArrayList<Dimension>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private TextField seriesValue;
    private TextField xAxisValue;
    private static final int X_AXIS = 0;
    private static final int SERIES_VALUE = 1;

    public AxisChooser(UiContainer parent) {
        super(parent);
        Label xAxisLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.XAXIS);
        this.xAxisValue = new TextField((UiContainer)this, 12);
        this.xAxisValue.setEditable(false);
        Button swapButton = new Button((UiContainer)this, DesignerMsg.DASHBOARD_SWAP, -2);
        swapButton.setBorder(BorderFactory.createEtchedBorder());
        swapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AxisChooser.this.swap();
            }
        });
        Label seriesLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.SERIE);
        this.seriesValue = new TextField((UiContainer)this, 12);
        this.seriesValue.setEditable(false);
        this.setLayout((Layout)new BoxLayout((UiContainer)this, 1));
        this.add((UiComponent)xAxisLabel);
        this.add((UiComponent)this.xAxisValue);
        this.add((UiComponent)swapButton);
        this.add((UiComponent)seriesLabel);
        this.add((UiComponent)this.seriesValue);
    }

    public List<Dimension> getDimensions() {
        return this.dimensionList;
    }

    public void add(List<Dimension> dimensions) {
        assert (dimensions.size() <= 2) : "Only two dimensions are allowed";
        this.dimensionList = dimensions;
        this.update(true);
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void swap() {
        Collections.reverse(this.dimensionList);
        this.update(true);
    }

    public void clear() {
        if (this.dimensionList.size() != 0) {
            this.dimensionList.clear();
            this.update(false);
        }
    }

    private void fireValuesChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private void update(boolean fireValuesChanged) {
        int dimensionQty = this.dimensionList.size();
        this.xAxisValue.setText("");
        this.seriesValue.setText("");
        if (dimensionQty > 0) {
            Dimension seriesValueDim;
            Dimension xAxisDim = this.dimensionList.get(0);
            if (xAxisDim != null) {
                this.xAxisValue.setText(xAxisDim.getName());
            }
            if (dimensionQty > 1 && (seriesValueDim = this.dimensionList.get(1)) != null) {
                this.seriesValue.setText(seriesValueDim.getName());
            }
        }
        if (fireValuesChanged) {
            this.fireValuesChanged();
        }
    }
}

