/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards.components;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.collections.Sequence;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.data.MeasurementType;
import oracle.bpm.designer.dashboardwizards.util.ActivitiesProvider;
import oracle.bpm.project.MeasurementImpl;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.util.ArrayUtils;

public class ActivitiesCombo
extends ComboBox {
    public ActivitiesCombo(UiContainer parent) {
        this(parent, new ActivitiesComboModel());
    }

    public ActivitiesCombo(UiContainer parent, ActivitiesComboModel model) {
        super(parent, false);
        this.setModel(model);
        this.setLabelProvider((LabelProvider)new ActivityLabelProvider());
    }

    public ActivitiesCombo(UiContainer parent, Process process, boolean startStop) {
        this(parent, new ActivitiesComboModel(process, startStop));
    }

    public void load(Process process, WidgetType type) {
        ActivitiesComboModel activitiesComboModel = (ActivitiesComboModel)this.getModel();
        if (process != null) {
            if (type.equals((Object)WidgetType.ACTIVITY_WORKLOAD)) {
                activitiesComboModel.loadActivitiesAndPairMeasurements(process);
            } else if (type.equals((Object)WidgetType.ACTIVITY_PERFORMANCE)) {
                activitiesComboModel.loadActivitiesAndMeasurements(process);
            } else {
                activitiesComboModel.empty();
            }
        }
    }

    static class ActivityLabelProvider
    extends LabelProvider.Default {
        ActivityLabelProvider() {
        }

        public String getText(Object element) {
            String result = "";
            if (element != null && !(element instanceof String)) {
                if (element instanceof FlowNode) {
                    result = ((FlowNode)element).getDefaultLabel();
                }
                if (element instanceof MeasurementImpl) {
                    MeasurementImpl measurement = (MeasurementImpl)element;
                    result = measurement.getDefaultLabel();
                    if (measurement.getMeasurementType().equals(MeasurementType.STOP)) {
                        result = result + " (" + measurement.getId() + ")";
                    }
                }
            }
            return result;
        }
    }

    public static class ActivitiesComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List activitiesList;
        private int selectedActivity;

        public ActivitiesComboModel() {
            this(new ArrayList());
        }

        public ActivitiesComboModel(List activitiesList) {
            this.activitiesList = activitiesList;
            this.selectedActivity = -1;
        }

        public ActivitiesComboModel(Process process, boolean startStop) {
            this(startStop ? ActivitiesComboModel.getActivitiesAndMeasurementMarkList(process) : ActivitiesComboModel.getActivitiesAndPairMeasurementsList(process));
        }

        @Override
        public Object getElementAt(int index) {
            return this.activitiesList.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedActivity = this.activitiesList.indexOf(anItem);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedActivity != -1 && this.activitiesList.size() != 0 ? this.activitiesList.get(this.selectedActivity) : null;
        }

        @Override
        public int getSize() {
            return this.activitiesList.size();
        }

        public void empty() {
            int lastIndex = this.activitiesList.size();
            this.activitiesList = new ArrayList();
            this.selectedActivity = -1;
            this.fireIntervalRemoved(this, 0, lastIndex);
        }

        public void loadActivitiesAndMeasurements(Process process) {
            this.activitiesList = ActivitiesComboModel.getActivitiesAndMeasurementMarkList(process);
            this.selectedActivity = -1;
            this.fireContentsChanged(this, 0, this.activitiesList.size());
        }

        public void loadActivitiesAndPairMeasurements(Process process) {
            this.activitiesList = ActivitiesProvider.getActivitiesList(process);
            this.activitiesList.addAll(ActivitiesComboModel.getActivitiesAndPairMeasurementsList(process));
            this.selectedActivity = -1;
            this.fireContentsChanged(this, 0, this.activitiesList.size());
        }

        private static List getActivitiesAndMeasurementMarkList(Process process) {
            ArrayList<FlowNode> list = new ArrayList<FlowNode>();
            Process processContent = process;
            list.addAll(ActivitiesProvider.getActivitiesList(process));
            return list;
        }

        private static List getActivitiesAndPairMeasurementsList(Process process) {
            Sequence list = process.getMeasurements();
            return ArrayUtils.asList(list.toArray());
        }
    }
}

