/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.project.io.serializers.dashboard.WidgetSerializer;
import oracle.bpm.project.model.Project;

public class WidgetsListModel
extends DefaultListModel {
    private Project project;
    private Set widgetNames;
    private List widgets = new ArrayList();

    WidgetsListModel(Project project) {
        this.widgetNames = new HashSet();
        this.project = project;
    }

    public static WidgetsListModel emptyModel(Project project) {
        return new WidgetsListModel(project);
    }

    public static WidgetsListModel loadWidgetModelList(Project project, ListFilter widgetFilter) {
        WidgetsListModel widgetsListModel = new WidgetsListModel(project);
        List list = project.getWidgetsList();
        ArrayList<WidgetModel> widgets = new ArrayList<WidgetModel>();
        for (WidgetModel widgetModel : list) {
            if (widgetFilter != null && !widgetFilter.accept(widgetModel)) continue;
            widgets.add(widgetModel);
        }
        widgetsListModel.widgets = widgets;
        widgetsListModel.addNames();
        return widgetsListModel;
    }

    public void load() {
        WidgetsListModel.loadWidgetModelList(this.project, null);
        this.fireContentsChanged(this, 0, this.widgets.size());
    }

    @Override
    public Object getElementAt(int index) {
        return this.widgets.get(index);
    }

    @Override
    public int getSize() {
        return this.widgets.size();
    }

    public void add(WidgetModel widgetModel) {
        WidgetSerializer.save((WidgetModel)widgetModel);
        int start = this.widgets.size();
        this.widgets.add(widgetModel);
        this.widgetNames.add(widgetModel.getName());
        this.fireIntervalAdded(this, start, start + 1);
    }

    public boolean exists(String name) {
        return this.widgetNames.contains(name);
    }

    public void remove(WidgetModel widgetModel) {
        int index = this.widgets.indexOf(widgetModel);
        this.widgets.remove(widgetModel);
        this.widgetNames.remove(widgetModel.getName());
        this.fireIntervalRemoved(this, index, index);
    }

    public void storeWidget(WidgetModel widget) {
        WidgetSerializer.save((WidgetModel)widget);
    }

    @Override
    public boolean isEmpty() {
        return this.widgets.size() <= 0;
    }

    public WidgetModel getFirst() {
        return (WidgetModel)this.widgets.get(0);
    }

    private void addNames() {
        for (int i = 0; this.widgets != null && i < this.widgets.size(); ++i) {
            WidgetModel widgetModel = (WidgetModel)this.widgets.get(i);
            this.widgetNames.add(widgetModel.getName());
        }
    }

    public static interface ListFilter {
        public boolean accept(WidgetModel var1);
    }
}

