/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import javax.swing.ListModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.designer.dashboardwizards.WidgetsListModel;
import oracle.bpm.geom.Point;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;

public class WidgetList
extends List {
    public WidgetList(UiContainer parent, WidgetsListModel model) {
        super(parent, (ListModel)model);
        this.setUp();
    }

    public WidgetModel getSelectedWidget() {
        return (WidgetModel)this.getSelectedValue();
    }

    public void add(WidgetModel widget) {
        ((WidgetsListModel)this.getModel()).add(widget);
    }

    public void removeWidget(WidgetModel widget) {
        ((WidgetsListModel)this.getModel()).remove(widget);
    }

    public boolean isEmpty() {
        return ((WidgetsListModel)this.getModel()).isEmpty();
    }

    public WidgetModel getFirst() {
        return ((WidgetsListModel)this.getModel()).getFirst();
    }

    private void setUp() {
        this.setLabelProvider((LabelProvider)new WidgetRenderer());
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (MouseEventUtilities.isPopupTrigger((MouseEvent)e)) {
                    this.showPopup(e.getPoint());
                }
            }

            private void showPopup(Point point) {
                PopupMenu menu = new PopupMenu((UiContainer)WidgetList.this);
                menu.show((UiComponent)WidgetList.this, point.getX(), point.getY());
            }
        });
    }

    public static class WidgetRenderer
    extends LabelProvider.Default<WidgetModel> {
        public Image getIcon(WidgetModel element) {
            Image icon = null;
            if (element != null) {
                icon = Image.create((Msg)element.getPresentationModel().getType().getMsg());
            }
            return icon;
        }

        public String getText(WidgetModel element) {
            String text = "";
            if (element != null) {
                text = element.getName();
            }
            return text;
        }
    }
}

