/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.designer.dashboardwizards.ChooseWidgetPanel;
import oracle.bpm.designer.dashboardwizards.WidgetChecker;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.layout.GridLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class WidgetChooser
extends Panel {
    private List<ChooseWidgetAction> chooseActions;
    private List<WidgetAddedListener> listeners;
    private Project project;
    private Map<Integer, WidgetModel> widgets;

    public WidgetChooser(UiContainer parent, DashboardModel dashboard) {
        super(parent);
        this.project = dashboard.getProject();
        this.widgets = new TreeMap<Integer, WidgetModel>();
        for (int i = 0; i < this.widgets.size(); ++i) {
            List widgetList = dashboard.getWidgetList();
            WidgetModel widget = (WidgetModel)widgetList.get(i);
            this.widgets.put(i, widget);
        }
        this.chooseActions = new ArrayList<ChooseWidgetAction>();
    }

    public void setWidgets(List widgets) {
        this.widgets = new TreeMap<Integer, WidgetModel>();
        for (int i = 0; i < widgets.size(); ++i) {
            WidgetModel widget = (WidgetModel)widgets.get(i);
            this.widgets.put(i, widget);
        }
    }

    public List<WidgetModel> getWidgetList() {
        ArrayList<WidgetModel> result = new ArrayList<WidgetModel>();
        for (Integer integer : this.widgets.keySet()) {
            result.add(this.widgets.get(integer));
        }
        return result;
    }

    public void clearSelection() {
        this.widgets.clear();
    }

    public void reLayout(int columns, int rows) {
        this.removeAll();
        this.chooseActions.removeAll(this.chooseActions);
        this.setLayout((Layout)new GridLayout(rows == 1 ? 0 : rows, columns));
        int qty = Math.max(this.widgets.values().size(), columns * rows);
        for (int i = 0; i < qty; ++i) {
            this.add((UiComponent)this.getWidgetSquare(i));
        }
        Iterator<ChooseWidgetAction> buttonIterator = this.chooseActions.iterator();
        Iterator<WidgetModel> widgetIterator = this.widgets.values().iterator();
        while (widgetIterator.hasNext() && buttonIterator.hasNext()) {
            WidgetModel widgetModel = widgetIterator.next();
            ChooseWidgetAction chooseWidgetAction = buttonIterator.next();
            this.setWidgetIcon(chooseWidgetAction.getButton(), widgetModel);
            this.setWidgetTitle(chooseWidgetAction.getLabel(), widgetModel);
        }
        this.revalidate();
        this.repaint();
    }

    public void addListener(WidgetAddedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<WidgetAddedListener>();
        }
        this.listeners.add(listener);
    }

    public void fireValueChanged(WidgetAddedEvent e) {
        for (WidgetAddedListener listener : this.listeners) {
            listener.widgetAdded(e);
        }
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        List components = this.getComponents();
        for (UiComponent component : components) {
            component.setOpaque(false);
        }
    }

    private Panel getWidgetSquare(int id) {
        Panel widgetPanel = new Panel((UiContainer)this);
        String widgetPanelColumns = "fill:5dlu:grow, pref, fill:5dlu:grow";
        String widgetPanelRows = "fill:5dlu:grow, pref, fill:5dlu:grow";
        FormLayout widgetpanelLayout = new FormLayout("fill:5dlu:grow, pref, fill:5dlu:grow", "fill:5dlu:grow, pref, fill:5dlu:grow");
        widgetPanel.setLayout((Layout)widgetpanelLayout);
        String cellColumns = "fill:2dlu, center:40dlu, fill:2dlu";
        String cellRows = "fill:5dlu, pref, 2dlu, pref,  2dlu, pref, fill:5dlu";
        FormLayout cellLayout = new FormLayout("fill:2dlu, center:40dlu, fill:2dlu", "fill:5dlu, pref, 2dlu, pref,  2dlu, pref, fill:5dlu");
        CellConstraints cellCellConstraints = new CellConstraints();
        Panel cell = new Panel((UiContainer)widgetPanel);
        cell.setLayout((Layout)cellLayout);
        ChooseWidgetAction action = new ChooseWidgetAction(id);
        Label widgetNameLabel = action.getLabel((UiContainer)cell);
        widgetNameLabel.setForeground(Color.GRAY);
        Button button = this.createWidgetButton((UiContainer)cell, action);
        this.chooseActions.add(action);
        Button removeButton = this.createRemoveButton((UiContainer)cell, id, widgetNameLabel, button);
        cell.setBorder(BorderFactory.createLineBorder((Color)Color.GRAY));
        cell.add((UiComponent)widgetNameLabel, (Object)cellCellConstraints.xy(2, 2));
        cell.add((UiComponent)button, (Object)cellCellConstraints.xy(2, 4));
        cell.add((UiComponent)removeButton, (Object)cellCellConstraints.xy(2, 6));
        cell.setBackground(Color.WHITE);
        CellConstraints widgetPanelCellConstraints = new CellConstraints();
        widgetPanel.setOpaque(false);
        widgetPanel.add((UiComponent)cell, (Object)widgetPanelCellConstraints.xy(2, 2, "center, center"));
        return widgetPanel;
    }

    private Button createRemoveButton(UiContainer parent, int i, Label widgetNameLabel, Button button) {
        Button removeButton = new Button(parent, (BaseAction)new RemoveWidgetAction(i, widgetNameLabel, button));
        removeButton.setOptions(-2);
        removeButton.setPressedIcon(Image.create((Msg)DesignerMsg.REMOVE_PRESSED));
        removeButton.setContentAreaFilled(false);
        removeButton.setBorderPainted(false);
        removeButton.setBorder(null);
        return removeButton;
    }

    private Button createWidgetButton(UiContainer parent, ChooseWidgetAction action) {
        Button button = action.getButton(parent);
        button.setOptions(-2);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setBorder(null);
        return button;
    }

    private void setWidgetIcon(Button button, WidgetModel widget) {
        button.setIcon(Image.create((Msg)widget.getPresentationModel().getType().getMsg()));
        button.repaint();
    }

    private void setWidgetTitle(Label label, WidgetModel widget) {
        label.setText(widget.getName());
        label.repaint();
    }

    private class RemoveWidgetAction
    extends BaseAction {
        private Button button;
        private int id;
        private Label label;

        public RemoveWidgetAction(int id, Label label, Button button) {
            super(DesignerMsg.REMOVE_PRESSED);
            this.id = id;
            this.label = label;
            this.button = button;
        }

        public void actionPerformed(ActionEvent e) {
            this.label.setText(DesignerMsg.UNSELECTED_WIDGET.getString());
            this.label.repaint();
            this.button.setIcon(Image.create((Msg)DesignerMsg.UNSELECTED_WIDGET));
            this.button.repaint();
            WidgetChooser.this.widgets.remove(this.id);
        }
    }

    private class ChooseWidgetAction
    extends BaseAction {
        private ChooseWidgetPanel chooseWidgetPanel;
        private OkCancelDialog dialog;
        private int id;
        private Button widgetActionButton;
        private Label widgetActionlabel;

        public ChooseWidgetAction(int id) {
            super(DesignerMsg.UNSELECTED_WIDGET);
            this.id = id;
        }

        public Button getButton(UiContainer parent) {
            this.widgetActionButton = new Button(parent, (BaseAction)this);
            return this.widgetActionButton;
        }

        public Button getButton() {
            return this.widgetActionButton;
        }

        public Label getLabel(UiContainer parent) {
            this.widgetActionlabel = Label.create((UiContainer)parent, (Msg)DesignerMsg.UNSELECTED_WIDGET);
            return this.widgetActionlabel;
        }

        public Label getLabel() {
            return this.widgetActionlabel;
        }

        public void actionPerformed(ActionEvent e) {
            WidgetModel widget;
            UiComponent parent = WidgetChooser.this.getTopLevelAncestor();
            if (this.showWidgetCreationDialog(parent) && (widget = this.chooseWidgetPanel.getWidgetModel()) != null) {
                WidgetModel replacedWidget = (WidgetModel)WidgetChooser.this.widgets.get(this.id);
                WidgetChooser.this.widgets.put(this.id, widget);
                WidgetChooser.this.setWidgetTitle(this.widgetActionlabel, widget);
                WidgetChooser.this.setWidgetIcon(this.widgetActionButton, widget);
                WidgetChooser.this.fireValueChanged(new WidgetAddedEvent((Object)this, widget, replacedWidget));
            }
        }

        private boolean showWidgetCreationDialog(UiComponent parent) {
            WidgetModel currentWidget;
            if (this.dialog == null) {
                this.dialog = new OkCancelDialog((UiWindow)parent, DesignerMsg.CHOOSE_WIDGET, true){

                    public void ok() {
                        WidgetModel selectedWidget = ChooseWidgetAction.this.chooseWidgetPanel.getSelectedWidget();
                        if (selectedWidget != null) {
                            WidgetChecker widgetChecker = new WidgetChecker(selectedWidget);
                            if (widgetChecker.check()) {
                                if (ChooseWidgetAction.this.chooseWidgetPanel.storeSelectedWidget()) {
                                    this.close();
                                }
                            } else {
                                MessageDialog.showError((Msg)UIMsg.TO_MSG((String)widgetChecker.getErrorMessage()));
                            }
                        }
                    }
                };
                this.dialog.makeRecyclable();
            }
            if (this.chooseWidgetPanel == null) {
                this.chooseWidgetPanel = new ChooseWidgetPanel(this.dialog.getContentPane(), WidgetChooser.this.project);
                this.chooseWidgetPanel.makeRecyclable();
            }
            if ((currentWidget = (WidgetModel)WidgetChooser.this.widgets.get(this.id)) != null) {
                this.chooseWidgetPanel.setSelectedWidget(currentWidget);
            } else {
                this.chooseWidgetPanel.selectFirstWidget();
            }
            this.dialog.getContentPane().add((UiComponent)this.chooseWidgetPanel, (Object)"Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo((UiComponent)this.dialog.getParent());
            this.dialog.setVisible(true);
            return this.dialog.userAccepted();
        }
    }

    static class WidgetAddedEvent
    extends EventObject {
        private WidgetModel addedWidget;
        private WidgetModel replacedWidget;

        public WidgetAddedEvent(Object source, WidgetModel addedWidget, WidgetModel replacedWidget) {
            super(source);
            this.addedWidget = addedWidget;
            this.replacedWidget = replacedWidget;
        }

        public WidgetModel getAddedWidget() {
            return this.addedWidget;
        }

        public WidgetModel getReplacedWidget() {
            return this.replacedWidget;
        }
    }

    public static interface WidgetAddedListener {
        public void widgetAdded(WidgetAddedEvent var1);
    }
}

