/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.Iterator;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;

public class WidgetChecker {
    private MsgList errorList;
    private WidgetModel widget;

    public WidgetChecker(WidgetModel widget) {
        this.widget = widget;
        this.errorList = MsgList.create();
    }

    public boolean check() {
        boolean ouOk = this.checkOuNotNull();
        boolean processOk = this.checkProcessNotNull();
        boolean activityOk = this.checkActivityNotNull();
        boolean dimensionsOk = this.checkDimensionsQuantity();
        boolean measurementOK = this.checkMeasurementNotNull();
        boolean drillDownOk = this.checkDrillDownNotNull();
        return ouOk && processOk && activityOk && dimensionsOk && measurementOK && drillDownOk;
    }

    public String getErrorMessage() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(DesignerMsg.ERRORS_IN_WIDGET);
        stringBuffer.append("\n");
        Iterator i$ = this.errorList.iterator();
        while (i$.hasNext()) {
            Msg anErrorList;
            Msg error = anErrorList = (Msg)i$.next();
            stringBuffer.append("\n");
            stringBuffer.append("- ");
            stringBuffer.append(error.getString());
        }
        stringBuffer.append("\n\n");
        stringBuffer.append(DesignerMsg.CORRECT_ERRORS_IN_WIDGET);
        return stringBuffer.toString();
    }

    private boolean checkOuNotNull() {
        boolean result;
        WidgetDataModel dataModel = this.widget.getDataModel();
        WidgetType type = dataModel.getType();
        boolean needsOU = type == WidgetType.OU_WORKLOAD || type == WidgetType.OU_ACTIVITY_PERFORMANCE || type == WidgetType.OU_PROCESS_PERFORMANCE;
        boolean bl = result = !needsOU || dataModel.getOuName() != null;
        if (!result) {
            this.errorList.add(DesignerMsg.NOT_SELECTED(DesignerMsg.ORGANIZATIONAL_UNIT.getString()));
        }
        return result;
    }

    private boolean checkDrillDownNotNull() {
        boolean result = true;
        WidgetDataModel dataModel = this.widget.getDataModel();
        if (dataModel.hasDrillDown()) {
            boolean bl = result = dataModel.getDrillDown() != null;
            if (!result) {
                this.errorList.add(DesignerMsg.NOT_SELECTED(DesignerMsg.DRILL_DOWN.getString()));
            }
        }
        return result;
    }

    private boolean checkMeasurementNotNull() {
        boolean result;
        WidgetDataModel dataModel = this.widget.getDataModel();
        boolean bl = result = dataModel.getMeasurement() != null;
        if (!result) {
            this.errorList.add(DesignerMsg.NOT_SELECTED(DesignerMsg.MEASURE.getString()));
        }
        return result;
    }

    private boolean checkDimensionsQuantity() {
        boolean result;
        WidgetDataModel dataModel = this.widget.getDataModel();
        boolean bl = result = dataModel.getDimensionQuantity() <= 2;
        if (!result) {
            this.errorList.add(DesignerMsg.DIMENSION_QTY_EXCEEDS_ALLOWED);
        }
        return result;
    }

    private boolean checkActivityNotNull() {
        boolean result;
        WidgetDataModel dataModel = this.widget.getDataModel();
        WidgetType type = dataModel.getType();
        boolean needsActivity = type == WidgetType.ACTIVITY_WORKLOAD || type == WidgetType.ACTIVITY_PERFORMANCE;
        boolean bl = result = !needsActivity || dataModel.getActivityId() != null;
        if (!result) {
            this.errorList.add(DesignerMsg.NOT_SELECTED(DesignerMsg.ACTIVITY.getString()));
        }
        return result;
    }

    private boolean checkProcessNotNull() {
        boolean result;
        WidgetDataModel dataModel = this.widget.getDataModel();
        WidgetType type = dataModel.getType();
        boolean needsProcess = type == WidgetType.ACTIVITY_WORKLOAD || type == WidgetType.ALL_ACTIVITIES_WORKLOAD || type == WidgetType.ACTIVITY_PERFORMANCE || type == WidgetType.ALL_ACTIVITIES_PERFORMANCE || type == WidgetType.PROCESS_PERFORMANCE;
        boolean bl = result = !needsProcess || dataModel.getProcessId() != null;
        if (!result) {
            this.errorList.add(DesignerMsg.NOT_SELECTED(DesignerMsg.PROCESS.getString()));
        }
        return result;
    }
}

