/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;

public class LayoutChooser
extends Panel {
    private int columns;
    private boolean doNotFireSelectionEvent;
    private ButtonGroup group;
    private Map<String, ToggleButton> layouts;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private int rows;

    public LayoutChooser(UiContainer parent, DashboardModel model) {
        super(parent, DesignerMsg.LAYOUT);
        this.columns = model.getColumns();
        this.rows = model.getRows();
        this.group = new ButtonGroup();
        this.init();
        ToggleButton layoutButton = this.layouts.get(this.columns + "x" + this.rows);
        layoutButton.setSelected(true);
    }

    public void loadLayout(int rows, int columns) {
        ToggleButton layoutButton = this.layouts.get(columns + "x" + rows);
        this.doNotFireSelectionEvent = true;
        layoutButton.setSelected(true);
        this.doNotFireSelectionEvent = false;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public boolean fireEvents() {
        return !this.doNotFireSelectionEvent;
    }

    private ToggleButton create1x1Button() {
        ToggleButton button = this.createButton(DesignerMsg.X11LAYOUT, 1, 1);
        button.setSelected(true);
        return button;
    }

    private ToggleButton create1x3Button() {
        return this.createButton(DesignerMsg.X13LAYOUT, 1, 3);
    }

    private ToggleButton create2x1Button() {
        return this.createButton(DesignerMsg.X21LAYOUT, 2, 1);
    }

    private ToggleButton create2x2Button() {
        return this.createButton(DesignerMsg.X22LAYOUT, 2, 2);
    }

    private ToggleButton create3x1Button() {
        return this.createButton(DesignerMsg.X31LAYOUT, 3, 1);
    }

    private ToggleButton create3x2Button() {
        return this.createButton(DesignerMsg.X32LAYOUT, 3, 2);
    }

    private ToggleButton create3x3Button() {
        return this.createButton(DesignerMsg.X33LAYOUT, 3, 3);
    }

    private ToggleButton createButton(Msg image, final int columns, final int rows) {
        ToggleButton button = new ToggleButton((UiContainer)this, Image.create((Msg)image));
        button.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    LayoutChooser.this.columns = columns;
                    LayoutChooser.this.rows = rows;
                    LayoutChooser.this.fireLayoutChanged();
                }
            }
        });
        this.group.add((AbstractButton)button);
        return button;
    }

    private void fireLayoutChanged() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent((Object)this));
        }
    }

    private void init() {
        this.layouts = new LinkedHashMap<String, ToggleButton>();
        this.setLayout((Layout)new FlowLayout(0));
        ToggleButton layout1x1 = this.create1x1Button();
        ToggleButton layout2x1 = this.create2x1Button();
        ToggleButton layout1x3 = this.create1x3Button();
        ToggleButton layout3x1 = this.create3x1Button();
        ToggleButton layout2x2 = this.create2x2Button();
        ToggleButton layout3x2 = this.create3x2Button();
        ToggleButton layout3x3 = this.create3x3Button();
        this.layouts.put("1x1", layout1x1);
        this.layouts.put("2x1", layout2x1);
        this.layouts.put("1x3", layout1x3);
        this.layouts.put("3x1", layout3x1);
        this.layouts.put("2x2", layout2x2);
        this.layouts.put("3x2", layout3x2);
        this.layouts.put("3x3", layout3x3);
        for (ToggleButton toggleButton : this.layouts.values()) {
            this.add((UiComponent)toggleButton);
        }
    }
}

