/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.List;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.designer.StructureTree;
import oracle.bpm.designer.view.gui.components.ViewChooser;
import oracle.bpm.designer.view.gui.tree.ViewTreeNode;
import oracle.bpm.designer.view.gui.tree.ViewsTreeNode;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public class DrillDownViewChooser
extends ViewChooser {
    private List<ProjectDataObject> dataObjects;
    private Project project;
    private StructureTree tree;
    private WidgetModel widgetModel;

    public DrillDownViewChooser(UiContainer parent, WidgetModel widgetModel, List<ProjectDataObject> dataObjects) {
        super(parent);
        this.project = widgetModel.getProject();
        this.widgetModel = widgetModel;
        this.dataObjects = dataObjects;
    }

    public static DrillDownViewChooser create(UiContainer parent, WidgetModel widgetModel, List<ProjectDataObject> dataObjects) {
        return new DrillDownViewChooser(parent, widgetModel, dataObjects);
    }

    public void reload(List<ProjectDataObject> dataObjects, WidgetModel widgetModel) {
        this.widgetModel = widgetModel;
        this.dataObjects = dataObjects;
        if (this.project != null && this.tree != null && !this.tree.isDisposed()) {
            ViewsTreeNode viewsNode = new ViewsTreeNode(this.project.getViewManager(), this.dataObjects, DrillDownViewChooser.doShowAll(this.widgetModel));
            this.tree.setRoot(viewsNode);
        }
    }

    protected Tree createTree(UiContainer parent) {
        this.tree = new StructureTree(parent, false);
        this.tree.setColorProvider(new ColorProvider(){

            public Color getBackground(Object element) {
                return null;
            }

            public Color getForeground(Object element) {
                boolean selectable = DrillDownViewChooser.doShowAll(DrillDownViewChooser.this.widgetModel) || element instanceof ViewsTreeNode || element instanceof ViewTreeNode;
                return selectable ? Color.BLACK : Color.LIGHT_GRAY;
            }
        });
        ViewsTreeNode viewsNode = new ViewsTreeNode(this.project.getViewManager(), this.dataObjects, DrillDownViewChooser.doShowAll(this.widgetModel));
        this.tree.setRoot(viewsNode);
        return this.tree;
    }

    protected boolean doChange(TreeNode treeNode) {
        return treeNode instanceof ViewTreeNode;
    }

    private static boolean doShowAll(WidgetModel widgetModel) {
        return "GAUGE".equals(widgetModel.getPresentationModel().getSubType().getGraphicType());
    }
}

