/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.List;
import javax.swing.ListModel;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.designer.dashboardwizards.AbstractDashboardsListModel;
import oracle.bpm.designer.dashboardwizards.CustomDashboardsListModel;
import oracle.bpm.designer.dashboardwizards.PredefinedDashboardsListModel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.dashboard.DashboardModelImpl;
import oracle.bpm.project.io.serializers.dashboard.DashboardException;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.UiContainer;

public class DashboardList
extends oracle.bpm.ui.List {
    private boolean predefined;
    private Project project;

    public DashboardList(UiContainer parent, Project project, boolean predefined) {
        this(project, parent, predefined ? PredefinedDashboardsListModel.loadDashboardModelList(project) : new CustomDashboardsListModel(project), predefined);
        this.predefined = predefined;
    }

    public DashboardList(Project project, UiContainer parent, AbstractDashboardsListModel model) {
        this(project, parent, model, false);
    }

    public DashboardList(Project project, UiContainer parent, AbstractDashboardsListModel model, boolean predefined) {
        super(parent, (ListModel)model, predefined ? ListSelectionMode.MULTIPLE_INTERVAL_SELECTION : ListSelectionMode.SINGLE_SELECTION);
        this.project = project;
        this.setLabelProvider((LabelProvider)new DashboardRenderer());
    }

    public DashboardModelImpl getSelectedDashboard() {
        return (DashboardModelImpl)this.getSelectedValue();
    }

    public List getSelectedDashboards() {
        return this.getSelectedValues();
    }

    public void add(DashboardModel dashboard) throws DashboardException {
        ((CustomDashboardsListModel)this.getModel()).add(dashboard);
    }

    public void load() {
        CustomDashboardsListModel model = new CustomDashboardsListModel(this.project);
        model.loadDashboardModelList();
        this.setModel(model);
    }

    public void removeDashboard(DashboardModel dashboard) {
        ((CustomDashboardsListModel)this.getModel()).remove(dashboard);
    }

    public boolean isEmpty() {
        return ((CustomDashboardsListModel)this.getModel()).isEmpty();
    }

    public int getDashboardCount() {
        return this.getModel().getSize();
    }

    public DashboardModelImpl getFirst() {
        return ((CustomDashboardsListModel)this.getModel()).getFirst();
    }

    public class DashboardRenderer
    extends LabelProvider.Default<DashboardModel> {
        public Image getIcon(DashboardModel element) {
            return Image.create((Msg)DesignerMsg.DASHBOARD);
        }

        public String getText(DashboardModel dashboard) {
            String name = dashboard.getId();
            String text = null;
            if (DashboardList.this.predefined) {
                text = dashboard.getTitle(dashboard.getProject().getDefaultLanguage());
                if (text == null || text.trim().length() == 0) {
                    text = name;
                }
            } else {
                text = name;
            }
            return text;
        }
    }
}

