/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.designer.dashboardwizards.AbstractDashboardsListModel;
import oracle.bpm.project.io.serializers.dashboard.DashboardException;
import oracle.bpm.project.io.serializers.dashboard.DashboardSerializer;
import oracle.bpm.project.model.Project;

public class CustomDashboardsListModel
extends AbstractDashboardsListModel {
    private Project project;

    CustomDashboardsListModel(Project project) {
        this.project = project;
        this.loadDashboardModelList();
    }

    public static AbstractDashboardsListModel emptyModel(Project project) {
        return new CustomDashboardsListModel(project);
    }

    public void loadDashboardModelList() {
        this.dashboards = this.project.getDashboardList();
        this.addNames();
        this.fireContentsChanged(this, 0, this.dashboards.size());
    }

    @Override
    public void add(DashboardModel dashboardModel) throws DashboardException {
        DashboardSerializer.save((DashboardModel)dashboardModel);
        int start = this.dashboards.size();
        this.dashboards.add(dashboardModel);
        this.dashboardNames.add(dashboardModel.getName());
        this.fireIntervalAdded(this, start, start + 1);
    }

    @Override
    public void remove(DashboardModel dashboardModel) {
        DashboardSerializer.remove((DashboardModel)dashboardModel);
        int index = this.dashboards.indexOf(dashboardModel);
        this.dashboards.remove(dashboardModel);
        this.dashboardNames.remove(dashboardModel.getName());
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void storeDashboard(DashboardModel dashboardModel) throws DashboardException {
        DashboardSerializer.save((DashboardModel)dashboardModel);
    }
}

