/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.dashboardwizards.LayoutChooser;
import oracle.bpm.designer.dashboardwizards.WidgetChooser;
import oracle.bpm.designer.dashboardwizards.components.FontPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.dashboard.DashboardModelImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.colorchoosingcomponent.ColorChoosingComponent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;

public class CreateDashboardPanel
extends Panel {
    private ColorChoosingComponent backgroundColorChooser;
    private Label chooseWidgetLabel;
    private Box closeButtonBox;
    private Panel dashboardPropertiesPanel;
    private Panel dashPreview;
    private Panel descriptionPanel;
    private TextArea descriptionTextArea;
    private String descriptionTmp;
    private boolean doNotFireEvents;
    private FontPanel fontPanel;
    private LayoutChooser layoutChooser;
    private DashboardModel model;
    private Label name;
    private Label nameLabel;
    private Panel titlePanel;
    private TextField titleTextField;
    private WidgetChooser widgetChooser;
    public static FontInfo DEFAULT_DASHBOARD_TITLE_FONT = FontInfo.valueOf("Verdana", 1, 22);
    public static ColorInfo DEFAULT_DASHBOARD_TITLE_BACKGROUND_COLOR = ColorInfo.valueOf(0, 114, 234);
    public static ColorInfo DDEFAULT_DASHBOARD_TITLE_FOREGROUND_COLOR = ColorInfo.WHITE;

    public CreateDashboardPanel(UiContainer parent, DashboardModelImpl dashModel) {
        super(parent, UIMsg.TO_MSG((String)""));
        this.model = dashModel;
        this.buildNameTextField();
        this.buildDescriptionPanel();
        this.buildTitlePanel();
        this.buildPreview();
        this.buildDashboardPropertiesPanel();
        this.buildLayoutChooser();
        this.layoutComponents();
        this.load();
    }

    public DashboardModel getModel() {
        return this.model;
    }

    public void reloadModel(DashboardModelImpl model) {
        this.model = model;
        this.load();
    }

    public void setModel(DashboardModel model) {
        this.model = model;
    }

    public List getWidgetList() {
        return this.widgetChooser.getWidgetList();
    }

    private static String getTitleForDashboardPreview(String title) {
        return title + "   ";
    }

    private void buildDashboardPropertiesPanel() {
        String columns = "2dlu, pref, 2dlu, pref, 2dlu";
        String rows = "3dlu, pref, 3dlu";
        FormLayout layout = new FormLayout("2dlu, pref, 2dlu, pref, 2dlu", "3dlu, pref, 3dlu");
        CellConstraints cc = new CellConstraints();
        this.dashboardPropertiesPanel = new Panel((UiContainer)this);
        this.dashboardPropertiesPanel.setLayout((Layout)layout);
        this.backgroundColorChooser = new ColorChoosingComponent((UiContainer)this.dashboardPropertiesPanel);
        this.backgroundColorChooser.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Color selectedColor = CreateDashboardPanel.this.backgroundColorChooser.getSelectedColor();
                CreateDashboardPanel.this.dashPreview.setBackground(selectedColor);
                CreateDashboardPanel.this.widgetChooser.setOpaque(false);
                CreateDashboardPanel.this.closeButtonBox.setOpaque(false);
                CreateDashboardPanel.this.model.asMutable().setBackground(selectedColor.getInfo());
            }
        });
        Label label = Label.create((UiContainer)this.dashboardPropertiesPanel, (Msg)DesignerMsg.BACKGROUND);
        this.dashboardPropertiesPanel.add((UiComponent)label, (Object)cc.xy(2, 2));
        this.dashboardPropertiesPanel.add((UiComponent)this.backgroundColorChooser, (Object)cc.xy(4, 2));
    }

    private void buildFontPanel(UiContainer parent) {
        this.fontPanel = new FontPanel(parent, Font.valueOf((FontInfo)DEFAULT_DASHBOARD_TITLE_FONT), Color.valueOf((ColorInfo)DEFAULT_DASHBOARD_TITLE_BACKGROUND_COLOR), Color.valueOf((ColorInfo)DDEFAULT_DASHBOARD_TITLE_FOREGROUND_COLOR), true, true, false, 1);
        this.fontPanel.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!CreateDashboardPanel.this.doNotFireEvents) {
                    DashboardModel.Mutable mutableModel = CreateDashboardPanel.this.model.asMutable();
                    mutableModel.setTitleFont(CreateDashboardPanel.this.fontPanel.getCurrentFont().getInfo());
                    mutableModel.setTitleBackground(CreateDashboardPanel.this.fontPanel.getBackgroundColor().getInfo());
                    mutableModel.setTitleForeground(CreateDashboardPanel.this.fontPanel.getForegroundColor().getInfo());
                }
            }
        });
    }

    private void buildLayoutChooser() {
        this.layoutChooser = new LayoutChooser((UiContainer)this, this.model);
        this.layoutChooser.setBackground(Color.PINK);
        this.layoutChooser.addListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (CreateDashboardPanel.this.layoutChooser.fireEvents()) {
                    CreateDashboardPanel.this.widgetChooser.clearSelection();
                    int rows = CreateDashboardPanel.this.layoutChooser.getRows();
                    int columns = CreateDashboardPanel.this.layoutChooser.getColumns();
                    DashboardModel.Mutable mutableModel = CreateDashboardPanel.this.model.asMutable();
                    mutableModel.setRows(rows);
                    mutableModel.setColumns(columns);
                    List widgetList = CreateDashboardPanel.this.model.getWidgetList();
                    widgetList.removeAll(widgetList);
                    CreateDashboardPanel.this.widgetChooser.reLayout(columns, rows);
                }
            }
        });
    }

    private void buildNameTextField() {
        this.nameLabel = Label.create((UiContainer)this, (Msg)CoreMsg.NAME.withColon());
        this.name = Label.create((UiContainer)this);
    }

    private void buildPreview() {
        this.dashPreview = new Panel((UiContainer)this);
        this.chooseWidgetLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.CHOOSE_WIDGET_IN_CELL);
        BorderLayout borderLayout = new BorderLayout();
        this.dashPreview.setLayout((Layout)borderLayout);
        this.widgetChooser = new WidgetChooser((UiContainer)this.dashPreview, this.model);
        this.widgetChooser.reLayout(this.model.getColumns(), this.model.getRows());
        this.widgetChooser.addListener(new WidgetChooser.WidgetAddedListener(){

            @Override
            public void widgetAdded(WidgetChooser.WidgetAddedEvent e) {
                DashboardModel model = CreateDashboardPanel.this.getModel();
                model.asMutable().addWidget(e.getAddedWidget());
                WidgetModel replacedWidget = e.getReplacedWidget();
                if (replacedWidget != null) {
                    model.getWidgetList().remove(replacedWidget);
                }
            }
        });
        this.dashPreview.add((UiComponent)this.fontPanel.getFontPreview((UiContainer)this.dashPreview), (Object)"North");
        this.dashPreview.add((UiComponent)this.widgetChooser, (Object)"Center");
        this.closeButtonBox = this.createCloseButton((UiContainer)this.dashPreview);
        this.dashPreview.add((UiComponent)this.closeButtonBox, (Object)"South");
    }

    private void buildTitlePanel() {
        this.titlePanel = new Panel((UiContainer)this, DesignerMsg.TITLE);
        this.titlePanel.setLayout((Layout)new BorderLayout(5, 5));
        Panel titleTextFieldPanel = new Panel((UiContainer)this.titlePanel);
        titleTextFieldPanel.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.titleTextField = new TextField((UiContainer)titleTextFieldPanel, 25);
        this.titleTextField.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String title = CreateDashboardPanel.this.titleTextField.getText();
                CreateDashboardPanel.this.model.asMutable().setTitle(title, CreateDashboardPanel.this.model.getProject().getDefaultLanguage());
                CreateDashboardPanel.this.fontPanel.changePreviewedText(CreateDashboardPanel.getTitleForDashboardPreview(title));
            }
        });
        titleTextFieldPanel.add((UiComponent)this.titleTextField);
        titleTextFieldPanel.add((UiComponent)this.getLocalizationButtonForTitle((UiContainer)titleTextFieldPanel));
        this.titlePanel.add((UiComponent)titleTextFieldPanel, (Object)"North");
        this.buildFontPanel((UiContainer)this.titlePanel);
        this.titlePanel.add((UiComponent)this.fontPanel, (Object)"Center");
    }

    private Button getLocalizationButtonForTitle(UiContainer parent) {
        return DesignerResources.buildLocalizationButton(this.model.getProject(), parent, this.model.getLocalizedTitles(), (TextComponent)this.titleTextField, DesignerMsg.LOCALIZE_LABEL.getString(), true);
    }

    private void buildDescriptionPanel() {
        this.descriptionPanel = new Panel((UiContainer)this, DesignerMsg.DESCRIPTION);
        this.descriptionPanel.setBackground(Color.YELLOW);
        this.descriptionPanel.setLayout((Layout)new BorderLayout(5, 5));
        this.descriptionTextArea = new TextArea((UiContainer)this.descriptionPanel, ScrollPolicy.ALWAYS, ScrollPolicy.AS_NEEDED);
        this.descriptionTextArea.setRows(5);
        this.descriptionTmp = "";
        this.descriptionTextArea.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                CreateDashboardPanel.this.descriptionTmp = CreateDashboardPanel.this.descriptionTextArea.getText();
            }
        });
        this.descriptionTextArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                CreateDashboardPanel.this.model.asMutable().setDescription(CreateDashboardPanel.this.descriptionTmp, CreateDashboardPanel.this.model.getProject().getDefaultLanguage());
            }
        });
        Panel locationPanel = new Panel((UiContainer)this.descriptionPanel);
        locationPanel.setLayout((Layout)new FlowLayout(0, 0, 0));
        DesignerResources.LocalizationButton localizationButton = DesignerResources.buildLocalizationButton(this.model.getProject(), (UiContainer)locationPanel, this.model.getLocalizedDescriptions(), (TextComponent)this.descriptionTextArea, DesignerMsg.LOCALIZE_LABEL.getString(), true);
        locationPanel.add((UiComponent)localizationButton);
        this.descriptionPanel.add((UiComponent)this.descriptionTextArea, (Object)"Center");
        this.descriptionPanel.add((UiComponent)locationPanel, (Object)"East");
    }

    private Box createCloseButton(UiContainer parent) {
        Box closeButtonBox = Box.createHorizontalBox((UiContainer)parent);
        closeButtonBox.add(Box.createHorizontalGlue((UiContainer)closeButtonBox));
        Button button = new Button((UiContainer)closeButtonBox, LibMsg.CLOSE);
        button.setOpaque(false);
        closeButtonBox.add((UiComponent)button);
        closeButtonBox.add(Box.createHorizontalGlue((UiContainer)closeButtonBox));
        closeButtonBox.setOpaque(false);
        return closeButtonBox;
    }

    private void layoutComponents() {
        String columns = "5dlu, pref, 10dlu, fill:170dlu, 10dlu, fill:170dlu, 5dlu";
        String rows = "5dlu, pref, 1dlu, pref, 5dlu, pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref:grow, 5dlu";
        FormLayout layout = new FormLayout("5dlu, pref, 10dlu, fill:170dlu, 10dlu, fill:170dlu, 5dlu", "5dlu, pref, 1dlu, pref, 5dlu, pref:grow, 5dlu, pref, 5dlu, pref, 5dlu, pref:grow, 5dlu");
        CellConstraints cc = new CellConstraints();
        this.setLayout((Layout)layout);
        this.add((UiComponent)this.nameLabel, cc.xy(2, 2));
        this.add((UiComponent)this.name, cc.xy(4, 2));
        this.add((UiComponent)this.layoutChooser, cc.xyw(2, 6, 3));
        this.add((UiComponent)this.dashboardPropertiesPanel, cc.xyw(2, 8, 3));
        this.add((UiComponent)this.titlePanel, cc.xyw(2, 10, 3));
        this.add((UiComponent)this.descriptionPanel, cc.xyw(2, 12, 3));
        this.add((UiComponent)this.chooseWidgetLabel, cc.xy(6, 2));
        this.add((UiComponent)this.dashPreview, cc.xywh(6, 4, 1, 9));
    }

    private void load() {
        Locale language = this.model.getProject().getDefaultLanguage();
        if (this.model != null) {
            this.name.setText(this.model.getName());
            this.titleTextField.setText(this.model.getTitle(language));
            LocaleStringMap description = this.model.getDescription();
            if (description != null) {
                this.descriptionTextArea.setText((String)description.get((Object)language));
            }
            this.backgroundColorChooser.setSelectedColor(Color.valueOf((ColorInfo)this.model.getBackground()));
            this.doNotFireEvents = true;
            this.fontPanel.setCurrentFont(Font.valueOf((FontInfo)this.model.getTitleFont()));
            this.fontPanel.setBackgroundColor(Color.valueOf((ColorInfo)this.model.getTitleBackground()));
            this.fontPanel.setForegroundColor(Color.valueOf((ColorInfo)this.model.getTitleForeground()));
            this.doNotFireEvents = false;
            int rows = this.model.getRows();
            int columns = this.model.getColumns();
            this.layoutChooser.loadLayout(rows, columns);
            this.widgetChooser.setWidgets(this.model.getWidgetList());
            this.widgetChooser.reLayout(columns, rows);
        }
    }
}

