/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.dashboardwizards.WidgetList;
import oracle.bpm.designer.dashboardwizards.WidgetsListModel;
import oracle.bpm.designer.dashboardwizards.WizardPreferencesPanel;
import oracle.bpm.designer.dashboardwizards.components.ReplacementForSplit;
import oracle.bpm.designer.dashboardwizards.configurationpanels.WidgetDisplayPreferencesBuilder;
import oracle.bpm.designer.dashboardwizards.util.WidgetBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.io.serializers.dashboard.WidgetSerializer;
import oracle.bpm.project.model.Project;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

public class ChooseWidgetPanel
extends Panel {
    public Panel emptyPanel;
    public ReplacementForSplit split;
    private Label chooseWidgetLabel;
    private IdentifierTextField nameTextField;
    private Project project;
    private boolean saveOnDeselection;
    private WidgetList widgetList;
    private WidgetModel widgetModel;
    private WizardPreferencesPanel widgetPreferencesPanel;

    public ChooseWidgetPanel(UiContainer parent, Project project) {
        super(parent);
        this.project = project;
        this.widgetModel = null;
        this.chooseWidgetLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.CHOOSE_WIDGET_MSG);
        this.buildAndLayoutComponents();
    }

    public WidgetModel getWidgetModel() {
        return this.widgetModel;
    }

    public boolean storeSelectedWidget() {
        boolean result = true;
        if (this.widgetList.getModel().getSize() > 0) {
            this.widgetModel = this.getSelectedWidget();
            ((WidgetsListModel)this.widgetList.getModel()).storeWidget(this.widgetModel);
        }
        return result;
    }

    public Panel getWidgetTabPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        Box box = Box.createHorizontalBox((UiContainer)panel);
        panel.setLayout((Layout)new BorderLayout(5, 5));
        this.nameTextField = new IdentifierTextField((UiContainer)box, WidgetBuilder.getDefaultName(this.project), 15, true, false);
        this.nameTextField.setPreferredSize(Dimension.valueOf(150, 25));
        box.add((UiComponent)this.nameTextField);
        ToolBar toolBar = new ToolBar((UiContainer)box);
        toolBar.add((BaseAction)new CreateWidgetAction());
        toolBar.add((BaseAction)new RemoveWidgetAction());
        box.add((UiComponent)toolBar);
        panel.add((UiComponent)box, (Object)"North");
        if (this.widgetList == null) {
            this.buildWidgetList((UiContainer)panel);
        }
        panel.add((UiComponent)this.widgetList, (Object)"Center");
        return panel;
    }

    public void setSelectedWidget(WidgetModel widgetModel) {
        this.widgetList.setSelectedValue(widgetModel, false);
        WidgetModel widget = (WidgetModel)this.widgetList.getSelectedValue();
        if (widget != null) {
            this.widgetPreferencesPanel.setModel(widget);
            this.widgetModel = widget;
        }
    }

    public Panel createEmptyPanel(UiContainer parent) {
        if (this.emptyPanel == null) {
            this.emptyPanel = new Panel(parent);
            this.emptyPanel.setPreferredSize(Dimension.valueOf(550, 700));
            this.emptyPanel.add((UiComponent)Label.create((UiContainer)this.emptyPanel, (Msg)DesignerMsg.ADD_WIDGET));
        }
        return this.emptyPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public void selectFirstWidget() {
        this.widgetList.setSelectedIndex(0);
    }

    WidgetModel getSelectedWidget() {
        return this.widgetList.getSelectedWidget();
    }

    private void buildWigetPreferencesPanel(UiContainer parent) {
        if (!this.widgetList.isEmpty()) {
            this.widgetModel = this.widgetList.getFirst();
            this.widgetPreferencesPanel = new WidgetDisplayPreferencesBuilder().build(parent, this.widgetModel);
            this.widgetList.setSelectedIndex(0);
            this.saveOnDeselection = true;
        }
    }

    private boolean checkIfSafeToStoreWidget(String name) {
        boolean exists = false;
        try {
            exists = ((WidgetsListModel)this.widgetList.getModel()).exists(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exists) {
            MessageDialog.showError((Msg)DesignerMsg.WIDGET_NAME_ALREADY_EXISTS);
        }
        return !exists;
    }

    private void buildWidgetList(UiContainer parent) {
        WidgetsListModel widgetsListModel = WidgetsListModel.loadWidgetModelList(this.project, null);
        this.widgetList = new WidgetList(parent, widgetsListModel);
        this.widgetList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evnt) {
                if (!evnt.getValueIsAdjusting()) {
                    WidgetModel widget = (WidgetModel)ChooseWidgetPanel.this.widgetList.getSelectedValue();
                    if (ChooseWidgetPanel.this.widgetModel != null && widget != null && ChooseWidgetPanel.this.saveOnDeselection) {
                        ((WidgetsListModel)ChooseWidgetPanel.this.widgetList.getModel()).storeWidget(ChooseWidgetPanel.this.widgetModel);
                        ChooseWidgetPanel.this.widgetPreferencesPanel.setModel(widget);
                        ChooseWidgetPanel.this.widgetModel = widget;
                    }
                }
            }
        });
    }

    private void buildAndLayoutComponents() {
        Panel preferencesPanel;
        this.split = new ReplacementForSplit((UiContainer)this);
        Panel tabPanel = this.getWidgetTabPanel((UiContainer)this.split);
        this.setLayout((Layout)new BorderLayout(2, 2));
        this.add((UiComponent)this.chooseWidgetLabel, "North");
        if (this.widgetList.isEmpty()) {
            preferencesPanel = this.createEmptyPanel((UiContainer)this.split);
        } else {
            this.buildWigetPreferencesPanel((UiContainer)this.split);
            preferencesPanel = this.widgetPreferencesPanel;
        }
        this.split.setLeftComponent((UiComponent)tabPanel);
        this.split.setRightComponent((UiComponent)preferencesPanel);
        this.add((UiComponent)this.split, "Center");
    }

    public class RemoveWidgetAction
    extends DesignerAction {
        public RemoveWidgetAction() {
            super(UIMsg.REMOVE);
        }

        @Override
        public boolean doIt() {
            boolean result = false;
            WidgetModel widgetToRemove = (WidgetModel)ChooseWidgetPanel.this.widgetList.getSelectedValue();
            if (widgetToRemove != null) {
                int previousWidget = ChooseWidgetPanel.this.widgetList.getSelectedIndex() - 1;
                if (previousWidget >= 0) {
                    ChooseWidgetPanel.this.widgetList.setSelectedIndex(previousWidget);
                    WidgetModel widget = (WidgetModel)ChooseWidgetPanel.this.widgetList.getSelectedValue();
                    ChooseWidgetPanel.this.widgetPreferencesPanel.setModel(widget);
                    ChooseWidgetPanel.this.widgetModel = widget;
                } else if (!ChooseWidgetPanel.this.widgetList.isEmpty()) {
                    ChooseWidgetPanel.this.widgetList.setSelectedIndex(ChooseWidgetPanel.this.widgetList.getSelectedIndex() + 1);
                }
                result = previousWidget > -1;
                ChooseWidgetPanel.this.widgetList.removeWidget(widgetToRemove);
                WidgetSerializer.remove((WidgetModel)widgetToRemove);
                if (ChooseWidgetPanel.this.widgetList.isEmpty()) {
                    ChooseWidgetPanel.this.split.remove((UiComponent)ChooseWidgetPanel.this.widgetPreferencesPanel);
                    ChooseWidgetPanel.this.split.setRightComponent((UiComponent)ChooseWidgetPanel.this.createEmptyPanel((UiContainer)ChooseWidgetPanel.this.split));
                }
            }
            return result;
        }

        public void unDoIt() {
        }
    }

    public class CreateWidgetAction
    extends DesignerAction {
        public CreateWidgetAction() {
            super(UIMsg.ADD);
        }

        @Override
        public boolean doIt() {
            boolean result;
            String name = ChooseWidgetPanel.this.nameTextField.getText();
            if (name == null || "".equals(name)) {
                name = WidgetBuilder.getDefaultName(ChooseWidgetPanel.this.project);
            }
            if (result = ChooseWidgetPanel.this.checkIfSafeToStoreWidget(name)) {
                ChooseWidgetPanel.this.widgetModel = WidgetBuilder.buildDefaultWidget(ChooseWidgetPanel.this.project, name);
                boolean pack = false;
                if (ChooseWidgetPanel.this.widgetList.isEmpty()) {
                    ChooseWidgetPanel.this.widgetPreferencesPanel = new WidgetDisplayPreferencesBuilder().build((UiContainer)ChooseWidgetPanel.this.split, ChooseWidgetPanel.this.widgetModel);
                    if (ChooseWidgetPanel.this.emptyPanel != null) {
                        ChooseWidgetPanel.this.split.remove((UiComponent)ChooseWidgetPanel.this.emptyPanel);
                    }
                    ChooseWidgetPanel.this.split.setRightComponent((UiComponent)ChooseWidgetPanel.this.widgetPreferencesPanel);
                    ChooseWidgetPanel.this.saveOnDeselection = true;
                    pack = true;
                }
                ChooseWidgetPanel.this.widgetList.add(ChooseWidgetPanel.this.widgetModel);
                ChooseWidgetPanel.this.widgetList.setSelectedValue(ChooseWidgetPanel.this.widgetModel, true);
                ChooseWidgetPanel.this.widgetPreferencesPanel.setModel(ChooseWidgetPanel.this.widgetModel);
                if (pack) {
                    Dialog dialog = (Dialog)ChooseWidgetPanel.this.getTopLevelAncestor();
                    dialog.pack();
                    dialog.setLocationRelativeTo((UiComponent)dialog.getParent());
                }
                ChooseWidgetPanel.this.nameTextField.setText(WidgetBuilder.getDefaultName(ChooseWidgetPanel.this.project));
            }
            return result;
        }

        public void unDoIt() {
        }
    }
}

