/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboardwizards;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.msg.DashboardMsg;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.catalog.CatalogUtils;
import oracle.bpm.designer.dashboardwizards.CreateDashboardPanel;
import oracle.bpm.designer.dashboardwizards.CustomDashboardsListModel;
import oracle.bpm.designer.dashboardwizards.DashboardList;
import oracle.bpm.designer.dashboardwizards.components.ReplacementForSplit;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.dashboard.DashboardModelImpl;
import oracle.bpm.project.io.serializers.dashboard.DashboardException;
import oracle.bpm.project.io.serializers.dashboard.DashboardSerializer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

class ChooseDashboardPanel
extends Panel {
    private boolean adding;
    private Label chooseDashboardLabel;
    private DashboardList dashboardList;
    private DashboardModelImpl dashboardModel;
    private CreateDashboardPanel dashboardPreferencesPanel;
    private Panel emptyPanel;
    private boolean fireEvents;
    private IdentifierTextField nameTextField;
    private Project project;
    private ReplacementForSplit split;
    private ObjectTypeDescription type;
    private static final String DEFAULT_TITLE = "Title";
    private static final int DEFAULT_COLUMNS = 1;
    private static final int DEFAULT_ROWS = 1;
    private static final String NEW_DASHBOARD = "NewDashboard";

    public ChooseDashboardPanel(UiContainer parent, Project project, CatalogObject type) {
        super(parent);
        this.project = project;
        this.type = type.getObjectType();
        this.dashboardModel = null;
        this.chooseDashboardLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.CHOOSE_DASHBOARD_MSG);
        this.fireEvents = true;
        this.adding = false;
        this.init();
    }

    public DashboardModel getDashboardModel() {
        return this.dashboardModel;
    }

    public boolean storeSelectedDashboard() {
        boolean result = true;
        this.dashboardModel = this.dashboardList.getSelectedDashboard();
        DashboardSerializer.save((DashboardModel)this.dashboardModel);
        return result;
    }

    public Panel getDashboardTabPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        this.buildDashboardList((UiContainer)panel);
        panel.setLayout((Layout)new BorderLayout(5, 5));
        Box box = Box.createHorizontalBox((UiContainer)panel);
        this.nameTextField = new IdentifierTextField((UiContainer)box, ChooseDashboardPanel.getDefaultName(this.type), 15, true);
        ToolBar toolBar = new ToolBar((UiContainer)box);
        toolBar.add((BaseAction)new CreateDashboardAction());
        toolBar.add((BaseAction)new RemoveDashboardAction());
        box.add((UiComponent)this.nameTextField);
        box.add((UiComponent)toolBar);
        panel.add((UiComponent)box, (Object)"North");
        panel.add((UiComponent)this.dashboardList, (Object)"Center");
        return panel;
    }

    public List getWidgetList() {
        return this.dashboardPreferencesPanel.getWidgetList();
    }

    private static DashboardModelImpl createDefaultDashboard(String defaultName, Project project) {
        DashboardModelImpl dashboard = new DashboardModelImpl(project);
        dashboard.setName(defaultName);
        dashboard.setColumns(1);
        dashboard.setRows(1);
        dashboard.setTitle(DEFAULT_TITLE);
        dashboard.setTitleFont(CreateDashboardPanel.DEFAULT_DASHBOARD_TITLE_FONT);
        dashboard.setTitleBackground(CreateDashboardPanel.DEFAULT_DASHBOARD_TITLE_BACKGROUND_COLOR);
        dashboard.setTitleForeground(CreateDashboardPanel.DDEFAULT_DASHBOARD_TITLE_FOREGROUND_COLOR);
        dashboard.setBackground(ColorInfo.WHITE);
        dashboard.setWidgetList(new ArrayList());
        return dashboard;
    }

    private static String getDefaultName(ObjectTypeDescription type) {
        Project project = CatalogUtils.getCatalogObject(type).getProject();
        String result = "";
        int counter = 1;
        HashSet<String> dashboardIds = new HashSet<String>();
        List dashboardList = project.getDashboardList();
        for (DashboardModel dashboardModel : dashboardList) {
            dashboardIds.add(dashboardModel.getId());
        }
        try {
            while (dashboardIds.contains(result = NEW_DASHBOARD + counter++)) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    private Panel createEmptyPanel(UiContainer parent) {
        if (this.emptyPanel == null) {
            this.emptyPanel = new Panel(parent);
            Label label = Label.create((UiContainer)this.emptyPanel, (Msg)DesignerMsg.ADD_DASHBOARD);
            this.emptyPanel.add((UiComponent)label);
        }
        return this.emptyPanel;
    }

    private void init() {
        Panel preferencesPanel;
        this.split = new ReplacementForSplit((UiContainer)this);
        this.setLayout((Layout)new BorderLayout(5, 5));
        this.add((UiComponent)this.chooseDashboardLabel, "North");
        Panel dashboardChoosingPanel = this.getDashboardTabPanel((UiContainer)this.split);
        if (this.dashboardList.isEmpty()) {
            preferencesPanel = this.createEmptyPanel((UiContainer)this.split);
        } else {
            this.buildDashboardPreferencesPanel((UiContainer)this.split);
            preferencesPanel = this.dashboardPreferencesPanel;
        }
        this.split.setLeftComponent((UiComponent)dashboardChoosingPanel);
        this.split.setRightComponent((UiComponent)preferencesPanel);
        this.add((UiComponent)this.split, "Center");
    }

    private void buildDashboardPreferencesPanel(UiContainer parent) {
        if (!this.dashboardList.isEmpty()) {
            this.dashboardModel = this.dashboardList.getFirst();
        }
        this.fireEvents = false;
        this.dashboardList.setSelectedValue(this.dashboardModel, false);
        this.fireEvents = true;
        if (!this.dashboardList.isEmpty()) {
            this.dashboardPreferencesPanel = new CreateDashboardPanel(parent, this.dashboardModel);
        }
    }

    private boolean checkIfSafeToStoreDashboard(String name) {
        boolean exists = false;
        try {
            exists = ((CustomDashboardsListModel)this.dashboardList.getModel()).exists(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exists) {
            MessageDialog.showError((Msg)DesignerMsg.DASHBOARD_NAME_ALREADY_EXISTS);
        }
        return !exists;
    }

    private void buildDashboardList(UiContainer parent) {
        CustomDashboardsListModel dashboardsListModel = new CustomDashboardsListModel(this.project);
        this.dashboardList = new DashboardList(this.project, parent, dashboardsListModel);
        this.dashboardList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evnt) {
                if (ChooseDashboardPanel.this.fireEvents) {
                    DashboardModelImpl dashboard;
                    if (ChooseDashboardPanel.this.dashboardModel != null) {
                        DashboardSerializer.save((DashboardModel)ChooseDashboardPanel.this.dashboardModel);
                    }
                    if ((dashboard = (DashboardModelImpl)ChooseDashboardPanel.this.dashboardList.getSelectedValue()) != null) {
                        ChooseDashboardPanel.this.dashboardPreferencesPanel.reloadModel(dashboard);
                    }
                    ChooseDashboardPanel.this.dashboardModel = dashboard;
                }
            }
        });
        this.dashboardList.load();
    }

    private class RemoveDashboardAction
    extends DesignerAction {
        public RemoveDashboardAction() {
            super(UIMsg.REMOVE);
        }

        @Override
        public boolean doIt() {
            boolean result = true;
            DashboardModel dashboardToRemove = (DashboardModel)ChooseDashboardPanel.this.dashboardList.getSelectedValue();
            if (dashboardToRemove != null) {
                int previousDashboard = ChooseDashboardPanel.this.dashboardList.getSelectedIndex() - 1;
                ChooseDashboardPanel.this.dashboardList.setSelectedIndex(previousDashboard);
                if (ChooseDashboardPanel.this.dashboardList.getDashboardCount() == 1) {
                    ChooseDashboardPanel.this.dashboardModel = null;
                }
                ChooseDashboardPanel.this.dashboardList.removeDashboard(dashboardToRemove);
                if (ChooseDashboardPanel.this.dashboardList.isEmpty()) {
                    ChooseDashboardPanel.this.split.remove((UiComponent)ChooseDashboardPanel.this.dashboardPreferencesPanel);
                    if (ChooseDashboardPanel.this.emptyPanel == null) {
                        ChooseDashboardPanel.this.emptyPanel = ChooseDashboardPanel.this.createEmptyPanel((UiContainer)ChooseDashboardPanel.this.split);
                    }
                    ChooseDashboardPanel.this.split.setRightComponent((UiComponent)ChooseDashboardPanel.this.emptyPanel);
                } else {
                    ChooseDashboardPanel.this.dashboardModel = ChooseDashboardPanel.this.dashboardList.getSelectedDashboard();
                }
            }
            return result;
        }

        public void unDoIt() {
        }
    }

    private class CreateDashboardAction
    extends DesignerAction {
        public CreateDashboardAction() {
            super(UIMsg.ADD);
        }

        @Override
        public boolean doIt() {
            boolean result = false;
            if (!ChooseDashboardPanel.this.adding) {
                result = this.doAdd();
            }
            return result;
        }

        public void unDoIt() {
        }

        private boolean doAdd() {
            boolean result;
            ChooseDashboardPanel.this.adding = true;
            Project project = CatalogUtils.getCatalogObject(ChooseDashboardPanel.this.type).getProject();
            String name = ChooseDashboardPanel.this.nameTextField.getText();
            if (name == null || "".equals(name)) {
                name = ChooseDashboardPanel.getDefaultName(ChooseDashboardPanel.this.type);
            }
            if (result = ChooseDashboardPanel.this.checkIfSafeToStoreDashboard(name)) {
                ChooseDashboardPanel.this.dashboardModel = ChooseDashboardPanel.createDefaultDashboard(name, project);
                try {
                    if (ChooseDashboardPanel.this.dashboardList.isEmpty()) {
                        ChooseDashboardPanel.this.dashboardPreferencesPanel = new CreateDashboardPanel((UiContainer)ChooseDashboardPanel.this.split, ChooseDashboardPanel.this.dashboardModel);
                        ChooseDashboardPanel.this.split.setRightComponent((UiComponent)ChooseDashboardPanel.this.dashboardPreferencesPanel);
                    }
                    ChooseDashboardPanel.this.dashboardList.add((DashboardModel)ChooseDashboardPanel.this.dashboardModel);
                    ChooseDashboardPanel.this.dashboardList.repaint();
                    ChooseDashboardPanel.this.dashboardList.setSelectedValue(ChooseDashboardPanel.this.dashboardModel, true);
                    ChooseDashboardPanel.this.dashboardPreferencesPanel.reloadModel(ChooseDashboardPanel.this.dashboardModel);
                    ChooseDashboardPanel.this.nameTextField.setText(ChooseDashboardPanel.getDefaultName(ChooseDashboardPanel.this.type));
                    ChooseDashboardPanel.this.nameTextField.repaint();
                }
                catch (DashboardException e) {
                    MessageDialog.showError((Msg)DashboardMsg.ERROR_SAVING_DASHBOARDS, (Throwable)e);
                }
            }
            ChooseDashboardPanel.this.adding = false;
            return result;
        }
    }
}

