/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.dashboard.generation;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.dashboard.model.Dimension;
import oracle.bpm.dashboard.model.DimensionType;
import oracle.bpm.dashboard.model.Measurement;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.WidgetValueType;
import oracle.bpm.dashboard.model.drilldown.DrillDown;
import oracle.bpm.dashboard.model.drilldown.DrillDownType;
import oracle.bpm.dashboard.model.drilldown.ViewDrillDown;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.dashboard.drilldown.ViewDrillDownAdapter;
import oracle.bpm.project.dashboard.drilldown.WidgetDrillDownAdapter;
import oracle.bpm.project.dashboard.generation.DashboardMethodFactory;
import oracle.bpm.project.dashboard.generation.DashboardSQL;
import oracle.bpm.project.model.Project;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.ui.ColorInfo;
import oracle.bpm.ui.FontInfo;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.xobject.Utilities;
import oracle.bpm.xobject.XObjectFactory;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;
import oracle.bpm.xobject.presentationmodel.XFormButton;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormChart;
import oracle.bpm.xobject.presentationmodel.XFormGauge;
import oracle.bpm.xobject.presentationmodel.XFormGraphic;
import oracle.bpm.xobject.presentationmodel.XFormLabel;
import oracle.bpm.xobject.presentationmodel.XFormPie;
import oracle.bpm.xobject.presentationmodel.XFormPresentation;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import oracle.bpm.xobject.presentationmodel.XFormRow;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormText;
import oracle.bpm.xobject.presentationmodel.XFormValue;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class DashboardFactory {
    private static final String XYZ_DATA_MODEL = "Fuego.Chart.DefaultXYZDataSource";
    private static final String XY_DATA_MODEL = "Fuego.Chart.DefaultXYDataSource";
    private static final String JFREE_CHART_PERCENTAGE = "{0} = {2}";
    private static final String METHOD_DB_QUERY_SUFFIX = "Query";
    private static final String METHOD_FILLING_SUFFIX = "DataSource";
    private static final String TITLE_UPDATE_METHOD_SUFFIX = "WithTitleUpdate";
    private static final String PRESENTATION_NAME = "Presentation";

    public static String buildDatabaseQueryCode(WidgetModel widgetModel) {
        DashboardSQL dashboardSQL = DashboardFactory.buildQuery(widgetModel.getDataModel());
        String sqlQuery = dashboardSQL.getSqlQuery();
        DashboardSQL.Argument[] sqlArgs = dashboardSQL.getSqlArgs();
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        codePrinter.println("//SQL query");
        codePrinter.println("query as String");
        codePrinter.print("query = ");
        DashboardFactory.printQuery(sqlQuery, codePrinter);
        codePrinter.println();
        codePrinter.println();
        codePrinter.println("//SQL query arguments");
        codePrinter.println("queryArgs as Any[]");
        codePrinter.print("queryArgs = [");
        for (int i = 0; i < sqlArgs.length; ++i) {
            DashboardSQL.Argument sqlArg = sqlArgs[i];
            if (i > 0) {
                codePrinter.print(",");
            }
            if (sqlArg.isParametric()) {
                codePrinter.print(sqlArg.getName());
                if (!sqlArg.hasSuffix()) continue;
                codePrinter.print("+");
                codePrinter.printQuoted(sqlArg.getSuffix());
                continue;
            }
            if (sqlArg.hasSuffix()) {
                codePrinter.printQuoted(sqlArg.getName() + sqlArg.getSuffix());
                continue;
            }
            codePrinter.printQuoted(sqlArg.getName());
        }
        codePrinter.print("]");
        codePrinter.println();
        codePrinter.println();
        codePrinter.println("//Executing query");
        codePrinter.println("bamQuery as BAMQuery");
        codePrinter.println("bamQuery = BAMQuery()");
        codePrinter.println("iterator as Iterator(Any[String])");
        codePrinter.println("iterator = execute(BAMQuery, sql : query, inParameters : queryArgs)");
        codePrinter.print("return iterator");
        codePrinter.flush();
        codePrinter.close();
        return codeWriter.toString();
    }

    public static MethodTypeDescription createGenerateFullProcessIdMethod() {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        String methodName = "generateFullProcessId";
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        DashboardFactory.buildGenerateFullProcessIdCode(codePrinter);
        codePrinter.flush();
        codePrinter.close();
        Argument processArgument = new Argument("process", TypeFactory.getString(), 1L);
        Argument[] arguments = new Argument[]{processArgument};
        MethodTypeDescription method = XObjectTypeDescriptionHelper.createMethod((String)"generateFullProcessId", (TypeDescription)TypeFactory.getString(), (Argument[])arguments, (String)codeWriter.toString(), (String)language);
        method.addModifiers(65536L);
        return method;
    }

    public static MethodTypeDescription createDatabaseQueryMethod(WidgetModel widgetModel) {
        String language;
        String code = DashboardFactory.buildDatabaseQueryCode(widgetModel);
        String methodName = DashboardFactory.buildQueryMethodName(widgetModel);
        TypeDescription returnType = TypeFactory.getIterator(TypeFactory.getMap(TypeFactory.getAny(), TypeFactory.getString()));
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        MethodTypeDescription methodType = XObjectTypeDescriptionHelper.createMethod((String)methodName, (TypeDescription)returnType, null, (String)code, (String)language);
        methodType.addModifiers(65536L);
        return methodType;
    }

    public static DashboardSQL buildQuery(WidgetDataModel widgetDataModel) {
        return new DashboardSQL(widgetDataModel);
    }

    public List<XObjectTypeDescription> createDashboard(DashboardModel dashboardModel, ComponentCatalog componentCatalog, String name) {
        List<XObjectTypeDescription> result = new Stack<XObjectTypeDescription>();
        result = this.createDashboard(dashboardModel, componentCatalog, result, false, name);
        return result;
    }

    public List<XObjectTypeDescription> createDashboard(DashboardModel dashboardModel, ComponentCatalog componentCatalog, List<XObjectTypeDescription> dashboards, boolean isDrillDown) {
        return this.createDashboard(dashboardModel, componentCatalog, dashboards, isDrillDown, dashboardModel.getName());
    }

    public List<XObjectTypeDescription> createDashboard(DashboardModel dashboardModel, ComponentCatalog componentCatalog, List<XObjectTypeDescription> dashboards, boolean isDrillDown, String name) {
        XObjectTypeDescription xotd = XObjectFactory.createXObjectTypeDescription(name, true, componentCatalog);
        DashboardFactory.localizeDashboard(xotd, dashboardModel);
        List widgetList = dashboardModel.getWidgetList();
        MethodTypeDescription[] methods = this.createDashboardMethods(widgetList, componentCatalog);
        boolean titleHandlingNeeded = false;
        for (WidgetModel widgetModel : widgetList) {
            WidgetDrillDownAdapter drillDown;
            WidgetDataModel dataModel = widgetModel.getDataModel();
            DashboardFactory.addAttributesFromParametricValues(xotd, dataModel);
            if (dataModel.hasDrillDown() && dataModel.getDrillDown().getType().equals((Object)DrillDownType.WIDGET_DRILL_DOWN) && xotd.findInnerType((drillDown = (WidgetDrillDownAdapter)dataModel.getDrillDown()).getName() + "DrillDown" + "Dashboard") == null) {
                dashboards = this.createDashboard(dashboardModel.createDashboardFromTemplate(drillDown.getWidget()), componentCatalog, dashboards, true);
            }
            titleHandlingNeeded = titleHandlingNeeded || dataModel.getValueType() == WidgetValueType.AUTOMATIC_TIME_HANDLING;
            DashboardFactory.localizeWidget(xotd, widgetModel);
        }
        for (MethodTypeDescription method : methods) {
            xotd.addMember(method);
        }
        if (titleHandlingNeeded) {
            DashboardFactory.addMembersForAutomaticTimeHandling(xotd);
        }
        XFormPresentationModel presentation = this.createPresentation(dashboardModel, xotd, isDrillDown);
        presentation.setReference(xotd);
        xotd.setPModel(presentation, PRESENTATION_NAME);
        xotd.setCatalog(componentCatalog);
        XObjectTypeDescriptionHelper.setXOPresentable((XObjectTypeDescription)xotd, (boolean)true);
        dashboards.add(xotd);
        return dashboards;
    }

    public MethodTypeDescription[] createDashboardMethods(List<WidgetModel> widgetList, ComponentCatalog componentCatalog) {
        TreeSet<MethodTypeDescription> methods = new TreeSet<MethodTypeDescription>();
        if (widgetList != null) {
            for (WidgetModel widgetModel : widgetList) {
                MethodTypeDescription queryMethod = DashboardFactory.createDatabaseQueryMethod(widgetModel);
                MethodTypeDescription[] fillingMethod = this.createDashboardFillingMethods(widgetModel, componentCatalog);
                if (widgetModel.getDataModel().hasDrillDown()) {
                    MethodTypeDescription[] drillDownMethods;
                    for (MethodTypeDescription drillDownMethod : drillDownMethods = widgetModel.getDataModel().getDrillDown().createDrillDownMethods(widgetModel)) {
                        methods.add(drillDownMethod);
                    }
                }
                methods.add(queryMethod);
                for (MethodTypeDescription aFillingMethod : fillingMethod) {
                    methods.add(aFillingMethod);
                }
            }
        }
        return methods.toArray(new MethodTypeDescription[0]);
    }

    public MethodTypeDescription[] createDashboardFillingMethods(WidgetModel widgetModel, ComponentCatalog componentCatalog) {
        String language;
        TypeDescription returnType;
        String methodName;
        IndentedPrintWriter codePrinter;
        StringWriter codeWriter;
        ArrayList<MethodTypeDescription> methods;
        block12: {
            boolean xyOrXyzGraphic;
            methods = new ArrayList<MethodTypeDescription>();
            codeWriter = new StringWriter();
            codePrinter = new IndentedPrintWriter(codeWriter);
            methodName = DashboardFactory.buildFillingMethodName(widgetModel);
            returnType = TypeFactory.getInt();
            try {
                language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
            }
            catch (InvalidLanguageException e) {
                language = "Fuego";
            }
            codePrinter.println("//Getting data from DB");
            codePrinter.println("iterator as Iterator(Any[Any])");
            codePrinter.print("iterator = ");
            codePrinter.print(DashboardFactory.buildQueryMethodName(widgetModel));
            codePrinter.print("()");
            codePrinter.println();
            codePrinter.println();
            WidgetDataModel widgetDataModel = widgetModel.getDataModel();
            Measurement measurement = widgetDataModel.getMeasurement();
            List dimensions = widgetDataModel.getDimensions();
            Dimension dimension1 = null;
            Dimension dimension2 = null;
            TypeDescription measurementType = measurement.getType().getDelegate();
            assert (measurementType != null) : "The measurement type can not be null!";
            if (dimensions != null) {
                for (Dimension dimension : dimensions) {
                    if (dimension.getDimensionType() != DimensionType.DIMENSION) continue;
                    if (dimension1 == null) {
                        dimension1 = dimension;
                        continue;
                    }
                    dimension2 = dimension;
                }
            }
            WidgetValueType valueType = widgetModel.getDataModel().getValueType();
            boolean bl = xyOrXyzGraphic = dimension1 != null;
            if (xyOrXyzGraphic) {
                try {
                    boolean xyzGraphic = dimension2 != null;
                    returnType = xyzGraphic ? componentCatalog.find(XYZ_DATA_MODEL).get() : componentCatalog.find(XY_DATA_MODEL).get();
                    if (valueType == WidgetValueType.PERCENTAGE) {
                        DashboardFactory.generatePercentageFillingDataSourceCode(codePrinter, measurement, dimension2, dimension1, methods, methodName, widgetModel, returnType, measurementType);
                        break block12;
                    }
                    this.generateFillingDataSourceCode(codePrinter, dimension2, dimension1, valueType, methods, methodName, widgetModel, returnType, measurement, measurementType);
                }
                catch (AmbiguousTypeNameException e) {}
            } else {
                returnType = measurementType;
                this.generateFillingMethodForGauge(codePrinter, measurementType, measurement, valueType, methods, methodName, widgetModel, returnType);
            }
        }
        codePrinter.flush();
        codePrinter.close();
        MethodTypeDescription methodType = XObjectTypeDescriptionHelper.createMethod((String)methodName, (TypeDescription)returnType, null, (String)codeWriter.toString(), (String)language);
        methodType.addModifiers(65536L);
        methods.add(0, methodType);
        MethodTypeDescription[] result = new MethodTypeDescription[methods.size()];
        for (int i = 0; i < methods.size(); ++i) {
            result[i] = (MethodTypeDescription)methods.get(i);
        }
        return result;
    }

    public XFormPresentationModel createPresentation(DashboardModel dashboardModel, ObjectTypeDescription objectType, boolean isDrillDown) {
        assert (dashboardModel != null) : "Dashboard model can not be null!";
        XFormGraphic xgraphic = null;
        int columns = dashboardModel.getColumns();
        int rows = dashboardModel.getRows();
        List widgets = dashboardModel.getWidgetList();
        int widgetQty = widgets != null ? widgets.size() : 0;
        int widgetIndex = 0;
        ArrayList<XFormRow> rowList = new ArrayList<XFormRow>(rows + 2);
        XFormLabel xtitlelabel = new XFormLabel();
        xtitlelabel.id = "title";
        LocaleStringMap localizedTitles = dashboardModel.getLocalizedTitles();
        xtitlelabel.value = localizedTitles != null && localizedTitles.size() > 0 ? new XFormValue((String)localizedTitles.get((Object)dashboardModel.getProject().getDefaultLanguage())) : new XFormValue(dashboardModel.getTitle());
        xtitlelabel.setFgcolor(Utilities.getString((ColorInfo)dashboardModel.getTitleForeground()));
        Font font = Font.valueOf((FontInfo)dashboardModel.getTitleFont());
        if (font != null) {
            FontStyle style = font.getStyle();
            xtitlelabel.setFontStyle(style == null ? FontStyle.PLAIN : style);
            xtitlelabel.setFonttype(font.getFamily());
            xtitlelabel.setFontsize(font.getSize());
        }
        XFormCell xtitlecell = new XFormCell();
        xtitlecell.label = xtitlelabel;
        Color titleBackground = Color.valueOf((ColorInfo)dashboardModel.getTitleBackground());
        xtitlecell.setBgcolor(Utilities.getString((ColorInfo)dashboardModel.getTitleBackground()));
        DashboardFactory.setBorderToCell(xtitlecell, BorderStyle.SOLID, titleBackground, 7);
        xtitlecell.alignment = "right";
        XFormRow xtitlerow = new XFormRow();
        xtitlerow.cell = new XFormCell[]{xtitlecell};
        rowList.add(xtitlerow);
        ArrayList<XFormRow> widgetRows = new ArrayList<XFormRow>();
        for (int i = 0; i < rows; ++i) {
            XFormCell[] xcells = new XFormCell[columns];
            for (int j = 0; j < columns; ++j) {
                XFormCell xcell = new XFormCell();
                if (widgetIndex < widgetQty) {
                    assert (widgets != null) : "Widgets list should not be null!";
                    WidgetModel widgetModel = (WidgetModel)widgets.get(widgetIndex++);
                    WidgetPresentationModel widgetPresentationModel = widgetModel.getPresentationModel();
                    assert (widgetPresentationModel != null) : "Widget presentation model can not be null!";
                    String graphicType = widgetPresentationModel.getSubType().getGraphicType();
                    int graphicSubType = widgetPresentationModel.getSubType().getGraphicCode();
                    if (graphicType.equals("XYZ")) {
                        XFormChart xchart = new XFormChart();
                        List dimensions = widgetModel.getDataModel().getDimensions();
                        assert (dimensions.size() > 0) : "Trying to build a chart with a model with no dimensions. Please report this bug";
                        if (dimensions.size() < 2) {
                            xchart.showlegend = false;
                        }
                        LocaleStringMap localizedCategoryLabel = ((Dimension)dimensions.get(0)).getLocalizedNames(dashboardModel.getProject());
                        xchart.categorylabel = (String)localizedCategoryLabel.get((Object)widgetModel.getProject().getDefaultLanguage());
                        List serieColors = widgetPresentationModel.getSeriesColor();
                        if (serieColors != null) {
                            String[] serieColorStrings = new String[serieColors.size()];
                            for (int k = 0; k < serieColors.size(); ++k) {
                                Color color = (Color)serieColors.get(k);
                                serieColorStrings[k] = Utilities.getString((ColorInfo)color.getInfo());
                            }
                            xchart.seriescolors = serieColorStrings;
                        }
                        xchart.shadowcolor = Utilities.getString((ColorInfo)widgetPresentationModel.getShadowColor());
                        xchart.outlinecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getOutlineColor());
                        xchart.valuecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getSeriesDataLabelColor());
                        Font seriesDataLabelFont = Font.valueOf((FontInfo)widgetPresentationModel.getSeriesDataLabelFont());
                        xchart.valuefontface = seriesDataLabelFont.getStyle();
                        xchart.valuefonttype = seriesDataLabelFont.getFamily();
                        xchart.valuefontsize = seriesDataLabelFont.getSize();
                        xchart.order = widgetPresentationModel.getOrientation();
                        WidgetValueType valueType = widgetModel.getDataModel().getValueType();
                        if (valueType.needsToShowUnits()) {
                            Locale projectLanguage = widgetModel.getProject().getDefaultLanguage();
                            xchart.valuelabel = widgetModel.getDataModel().getValueType().getMsg().getString(projectLanguage);
                        }
                        xcell.chart = xchart;
                        xgraphic = xchart;
                    } else if (graphicType.equals("XY")) {
                        XFormPie xpie = new XFormPie();
                        List serieColors = widgetPresentationModel.getSeriesColor();
                        if (serieColors != null) {
                            String[] serieColorStrings = new String[serieColors.size()];
                            for (int k = 0; k < serieColors.size(); ++k) {
                                Color color = (Color)serieColors.get(k);
                                serieColorStrings[k] = Utilities.getString((ColorInfo)color.getInfo());
                            }
                            xpie.seriescolors = serieColorStrings;
                        }
                        xpie.shadowcolor = Utilities.getString((ColorInfo)widgetPresentationModel.getShadowColor());
                        xpie.outlinecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getOutlineColor());
                        xpie.valuecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getSeriesDataLabelColor());
                        Font seriesDataLabelFont = Font.valueOf((FontInfo)widgetPresentationModel.getSeriesDataLabelFont());
                        xpie.setFontStyle(seriesDataLabelFont.getStyle());
                        xpie.valuefonttype = seriesDataLabelFont.getFamily();
                        xpie.valuefontsize = seriesDataLabelFont.getSize();
                        WidgetValueType valueType = widgetModel.getDataModel().getValueType();
                        if (valueType.needsToShowUnits() && valueType == WidgetValueType.PERCENTAGE) {
                            xpie.itemlabelmask = JFREE_CHART_PERCENTAGE;
                        }
                        xcell.pie = xpie;
                        xgraphic = xpie;
                    } else if (graphicType.equals("GAUGE")) {
                        XFormGauge xgauge = new XFormGauge();
                        BusinessVariableData.Range criticalRange = widgetPresentationModel.getCriticalRange();
                        xgauge.setAlarm_level(criticalRange.getStart().doubleValue());
                        xgauge.setAlarm_level_max(criticalRange.getFinish().doubleValue());
                        xgauge.setCriticalcolor(Utilities.getString((ColorInfo)widgetPresentationModel.getCriticalRangeColor()));
                        BusinessVariableData.Range warningRange = widgetPresentationModel.getWarningRange();
                        xgauge.setWarning_level(warningRange.getStart().doubleValue());
                        xgauge.setWarning_level_max(warningRange.getFinish().doubleValue());
                        xgauge.setWarningcolor(Utilities.getString((ColorInfo)widgetPresentationModel.getWarningRangeColor()));
                        BusinessVariableData.Range normalRange = widgetPresentationModel.getNormalRange();
                        xgauge.setNormal_level(normalRange.getStart().doubleValue());
                        xgauge.setNormal_level_max(normalRange.getFinish().doubleValue());
                        xgauge.setNormalcolor(Utilities.getString((ColorInfo)widgetPresentationModel.getNormalRangeColor()));
                        BusinessVariableData.Range totalRange = widgetPresentationModel.getTotalRange();
                        xgauge.setMin_limit(totalRange.getStart().doubleValue());
                        xgauge.setMax_limit(totalRange.getFinish().doubleValue());
                        xgauge.outlinecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getOutlineColor());
                        xgauge.contentcolor = Utilities.getString((ColorInfo)widgetPresentationModel.getForegroundColor());
                        xgauge.valuecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getValueColor());
                        Font valueFont = Font.valueOf((FontInfo)widgetPresentationModel.getValueFont());
                        xgauge.setFontStyle(valueFont.getStyle());
                        xgauge.valuefonttype = valueFont.getFamily();
                        xgauge.valuefontsize = valueFont.getSize();
                        WidgetValueType valueType = widgetModel.getDataModel().getValueType();
                        if (valueType.needsToShowUnits()) {
                            String unit;
                            Locale projectLanguage = widgetModel.getProject().getDefaultLanguage();
                            xgauge.unit = unit = widgetModel.getDataModel().getValueType().getMsg().getString(projectLanguage);
                        }
                        xcell.gauge = xgauge;
                        xgraphic = xgauge;
                    }
                    if (xgraphic != null) {
                        WidgetDataModel dataModel;
                        xgraphic.id = widgetModel.getName();
                        xgraphic.setType(graphicSubType);
                        LocaleStringMap localizedWidgetTitles = widgetModel.getPresentationModel().getLocalizedTitles();
                        String title = localizedWidgetTitles != null && localizedWidgetTitles.size() > 0 ? (String)localizedWidgetTitles.get((Object)widgetModel.getProject().getDefaultLanguage()) : widgetPresentationModel.getTitle();
                        xgraphic.setTitle(title);
                        Font titleFont = Font.valueOf((FontInfo)widgetPresentationModel.getTitleFont());
                        if (titleFont != null) {
                            xgraphic.setFontStyle(titleFont.getStyle());
                            xgraphic.setFonttype(titleFont.getFamily());
                            xgraphic.setFontsize(titleFont.getSize());
                        }
                        xgraphic.setTitlebackground(Utilities.getString((ColorInfo)widgetPresentationModel.getTitleBackgroundColor()));
                        xgraphic.setTitleforeground(Utilities.getString((ColorInfo)widgetPresentationModel.getTitleForegroundColor()));
                        xgraphic.setWidth(widgetPresentationModel.getWidth());
                        xgraphic.setHeight(widgetPresentationModel.getHeight());
                        xgraphic.setBorderstyle(widgetPresentationModel.getBorder().getTopStyle());
                        xgraphic.setBordercolor(widgetPresentationModel.getBorder().getTopColor());
                        xgraphic.setBorderwidth(widgetPresentationModel.getBorder().getTopWidth());
                        if (objectType != null) {
                            MethodTypeDescription handlingMethod = objectType.findMethod(DashboardFactory.buildTitleUpdateMethodName(widgetModel));
                            if (handlingMethod != null) {
                                xgraphic.setMethodinvocation(handlingMethod.getSignature());
                            } else {
                                MethodTypeDescription fillingMethod = objectType.findMethod(DashboardFactory.buildFillingMethodName(widgetModel));
                                if (fillingMethod != null) {
                                    xgraphic.setMethodinvocation(fillingMethod.getSignature());
                                }
                            }
                        }
                        if ((dataModel = widgetModel.getDataModel()).hasDrillDown() && objectType != null) {
                            TypeDescription onClickMethod = null;
                            if (dataModel.getDrillDown() != null) {
                                String onClickMethodName;
                                DrillDown drillDown = dataModel.getDrillDown();
                                DrillDownType drillDownType = drillDown.getType();
                                if (drillDownType == DrillDownType.WIDGET_DRILL_DOWN) {
                                    WidgetModel widgetToDrillTo = ((WidgetDrillDownAdapter)drillDown).getWidget();
                                    onClickMethodName = DashboardMethodFactory.buildWidgetDrillDownMethodName((WidgetModel)widgetToDrillTo);
                                } else if (drillDownType == DrillDownType.VIEW_DRILL_DOWN) {
                                    ViewDrillDownAdapter viewToDrillTo = (ViewDrillDownAdapter)drillDown;
                                    onClickMethodName = DashboardMethodFactory.buildViewDrillDownMethodName((ViewDrillDown)viewToDrillTo);
                                } else {
                                    onClickMethodName = DashboardMethodFactory.buildInstancesViewDrillDownMethodName();
                                }
                                onClickMethod = objectType.findMethod(onClickMethodName);
                            }
                            if (onClickMethod != null) {
                                xgraphic.setOnClickArgumentQty(widgetModel.getDrillDownArgumentQuantity());
                                xgraphic.setOnclick(onClickMethod.getSignature());
                            }
                        }
                        xgraphic.setRefreshrate(widgetPresentationModel.getRefreshRate());
                        xgraphic.plotoutlinecolor = Utilities.getString((ColorInfo)widgetPresentationModel.getPlotOutlineColor());
                        xgraphic.plotbgcolor = Utilities.getString((ColorInfo)widgetPresentationModel.getPlotBackgroundColor());
                        xgraphic.bgcolor = Utilities.getString((ColorInfo)widgetPresentationModel.getBackgroundColor());
                        xgraphic.setHasdynamictype(widgetPresentationModel.isTypeSelectionAllowed());
                        xgraphic.setHasforcedrefresh(widgetPresentationModel.isUsrSelectionAllowed());
                    }
                }
                xcells[j] = xcell;
            }
            XFormRow widgetsRow = new XFormRow();
            widgetsRow.cell = xcells;
            widgetRows.add(widgetsRow);
        }
        if (isDrillDown && widgets.size() == 1) {
            WidgetDataModel widget = ((WidgetModel)widgets.get(0)).getDataModel();
            DashboardFactory.createDrillDownTitle(widget.isParametricOu(), widget.isParametricProcess(), widget.isParametricActivity(), dashboardModel, rowList);
        }
        XFormTable table = new XFormTable();
        table.id = "widgetstable";
        XFormRow[] tableRow = new XFormRow[widgetRows.size()];
        for (int i = 0; i < widgetRows.size(); ++i) {
            tableRow[i] = (XFormRow)widgetRows.get(i);
        }
        table.row = tableRow;
        XFormRow containerRow = new XFormRow();
        containerRow.expand(1);
        containerRow.cell[0].table = table;
        rowList.add(containerRow);
        DashboardFactory.setBorderToCell(containerRow.cell[0], BorderStyle.SOLID, Color.valueOf((int)128, (int)128, (int)128), 1);
        XFormButton xbutton = new XFormButton();
        xbutton.setAction(0);
        xbutton.display = LibMsg.CLOSE.getString(dashboardModel.getProject().getDefaultLanguage());
        xbutton.display = isDrillDown ? LibMsg.BACK.getString(dashboardModel.getProject().getDefaultLanguage()) : LibMsg.CLOSE.getString(dashboardModel.getProject().getDefaultLanguage());
        XFormCell xbuttoncell = new XFormCell();
        xbuttoncell.hexpand = columns;
        xbuttoncell.button = xbutton;
        XFormRow xbuttonrow = new XFormRow();
        xbuttonrow.cell = new XFormCell[]{xbuttoncell};
        rowList.add(xbuttonrow);
        XFormTable xtable = new XFormTable();
        xtable.id = "table";
        xtable.row = rowList.toArray(new XFormRow[0]);
        xtable.cellspacing = 8;
        xtable.width = "80%";
        XFormPresentation xpresentation = new XFormPresentation();
        xpresentation.table = xtable;
        xpresentation.bgcolor = Utilities.getString((ColorInfo)dashboardModel.getBackground());
        XFormPresentationModel xprePresentationModel = new XFormPresentationModel(objectType);
        xprePresentationModel.presentation_d = xpresentation;
        xprePresentationModel.setPresentationName(PRESENTATION_NAME);
        XObjectTypeDescriptionHelper.ensureParents((XFormXMLObject)xprePresentationModel);
        return xprePresentationModel;
    }

    private static void localizeDashboard(XObjectTypeDescription xotd, DashboardModel dashboardModel) {
        Project project = dashboardModel.getProject();
        LocaleStringMap localizedTitles = dashboardModel.getLocalizedTitles();
        xotd.setResource((String)localizedTitles.get((Object)project.getDefaultLanguage()), 0, localizedTitles);
        LocaleStringMap closeTranslations = LibMsg.CLOSE.getAllAvailableTranslationsForProjectLanguages();
        xotd.setResource((String)closeTranslations.get((Object)project.getDefaultLanguage()), 0, closeTranslations);
    }

    private static void buildGenerateFullProcessIdCode(IndentedPrintWriter codePrinter) {
        codePrinter.println("//SQL query");
        codePrinter.println("query as String");
        codePrinter.println("query = ");
        codePrinter.printQuoted("select name, parentIn, ouIn from bam_OUs");
        codePrinter.println();
        codePrinter.println("//Executing query");
        codePrinter.println("bamQuery as BAMQuery");
        codePrinter.println("bamQuery = BAMQuery()");
        codePrinter.println("iterator as Iterator(Any[String])");
        codePrinter.println("iterator = execute(BAMQuery, sql : query, inParameters : [])");
        codePrinter.println();
        codePrinter.println("ouNames as String[Int]");
        codePrinter.println("ouParents as Int[Int]");
        codePrinter.println();
        codePrinter.println("for each row in iterator");
        codePrinter.println("do");
        codePrinter.indent();
        codePrinter.print("ouIn as Int = Int(row[");
        codePrinter.printQuoted("ouIn");
        codePrinter.println("])");
        codePrinter.print("name as String = String(row[");
        codePrinter.printQuoted("name");
        codePrinter.println("])");
        codePrinter.print("parentIn as Int = Int(row[");
        codePrinter.printQuoted("parentIn");
        codePrinter.println("])");
        codePrinter.println("ouNames[ouIn] = name");
        codePrinter.println("ouParents[ouIn] = parentIn");
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.println();
        codePrinter.println("currentIn as Int");
        codePrinter.println();
        codePrinter.println("for each ouIn in ouNames.keys do");
        codePrinter.indent();
        codePrinter.println("if  ouNames[ouIn] == ou then");
        codePrinter.indent();
        codePrinter.println("currentIn  = ouIn");
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.println();
        codePrinter.println("currentParentIn as Int = ouParents[currentIn]");
        codePrinter.println("currentName as String");
        codePrinter.println();
        codePrinter.print("fullProcessName as String = ");
        codePrinter.printQuoted("/");
        codePrinter.println("+ process");
        codePrinter.println();
        codePrinter.println("while currentParentIn != -1 do");
        codePrinter.indent();
        codePrinter.println("currentName = ouNames[currentIn]");
        codePrinter.print("fullProcessName = ");
        codePrinter.printQuoted("/");
        codePrinter.println("+ currentName + fullProcessName");
        codePrinter.println("currentIn = currentParentIn");
        codePrinter.println("currentParentIn = ouParents[currentIn]");
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.println("");
        codePrinter.println("return fullProcessName");
    }

    private static void localizeWidget(XObjectTypeDescription xotd, WidgetModel widgetModel) {
        WidgetValueType valueType;
        Locale defaultLanguage = widgetModel.getProject().getDefaultLanguage();
        LocaleStringMap localizedTitles = widgetModel.getPresentationModel().getLocalizedTitles();
        xotd.setResource((String)localizedTitles.get((Object)defaultLanguage), 0, localizedTitles);
        List dimensions = widgetModel.getDataModel().getDimensions();
        if (dimensions != null && dimensions.size() > 0) {
            Dimension dimension = (Dimension)dimensions.get(0);
            LocaleStringMap localizedCategoryLabel = dimension.getLocalizedNames(widgetModel.getProject());
            xotd.setResource((String)localizedCategoryLabel.get((Object)defaultLanguage), 0, localizedCategoryLabel);
        }
        if ((valueType = widgetModel.getDataModel().getValueType()) == WidgetValueType.AUTOMATIC_TIME_HANDLING) {
            LocaleStringMap localizedSeconds = WidgetValueType.SECONDS.getMsg().getAllAvailableTranslationsForProjectLanguages();
            xotd.setResource((String)localizedSeconds.get((Object)defaultLanguage), 0, localizedSeconds);
            LocaleStringMap localizedMinutes = WidgetValueType.MINUTES.getMsg().getAllAvailableTranslationsForProjectLanguages();
            xotd.setResource((String)localizedMinutes.get((Object)defaultLanguage), 0, localizedMinutes);
            LocaleStringMap localizedHours = WidgetValueType.HOURS.getMsg().getAllAvailableTranslationsForProjectLanguages();
            xotd.setResource((String)localizedHours.get((Object)defaultLanguage), 0, localizedHours);
            LocaleStringMap localizedDays = WidgetValueType.DAYS.getMsg().getAllAvailableTranslationsForProjectLanguages();
            xotd.setResource((String)localizedDays.get((Object)defaultLanguage), 0, localizedDays);
        } else if (valueType.needsToShowUnits()) {
            LocaleStringMap localizedUnits = valueType.getMsg().getAllAvailableTranslationsForProjectLanguages();
            xotd.setResource((String)localizedUnits.get((Object)defaultLanguage), 0, localizedUnits);
        }
    }

    private static void createDrillDownTitle(boolean parametricOu, boolean parametricProcess, boolean parametricActivity, DashboardModel dashboardModel, List<XFormRow> rowList) {
        XFormRow xdrilldowntitlerow = new XFormRow();
        xdrilldowntitlerow.cell = DashboardFactory.createBreadCrumb(parametricOu, parametricProcess, parametricActivity, dashboardModel);
        XFormTable drillDownTitleTable = new XFormTable();
        drillDownTitleTable.id = "drilldowntable";
        drillDownTitleTable.row = new XFormRow[]{xdrilldowntitlerow};
        drillDownTitleTable.cellpadding = 2;
        XFormRow tableRow = new XFormRow();
        tableRow.expand(1);
        tableRow.cell[0].table = drillDownTitleTable;
        tableRow.cell[0].alignment = "left";
        rowList.add(tableRow);
    }

    private static void printQuery(String sqlQuery, IndentedPrintWriter codePrinter) {
        StringTokenizer tokenizer = new StringTokenizer(sqlQuery, "\n");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            if (!first) {
                codePrinter.print(" + ");
            }
            codePrinter.printQuoted(tokenizer.nextToken());
            codePrinter.println();
            first = false;
        }
    }

    private static XFormCell[] createBreadCrumb(boolean parametricOu, boolean parametricProcess, boolean parametricActivity, DashboardModel dashboardModel) {
        String reference;
        Font font = Font.valueOf((FontInfo)dashboardModel.getTitleFont());
        ArrayList<XFormCell> breadCrumb = new ArrayList<XFormCell>();
        if (parametricOu) {
            reference = "ou";
            breadCrumb.add(DashboardFactory.createLabelCell(font, reference));
            breadCrumb.add(DashboardFactory.createSuffixCell(font, reference));
        }
        if (parametricProcess) {
            reference = "process";
            breadCrumb.add(DashboardFactory.createLabelCell(font, reference));
            breadCrumb.add(DashboardFactory.createSuffixCell(font, reference));
        }
        if (parametricActivity) {
            reference = "activity";
            breadCrumb.add(DashboardFactory.createLabelCell(font, reference));
            breadCrumb.add(DashboardFactory.createSuffixCell(font, reference));
        }
        return breadCrumb.toArray(new XFormCell[breadCrumb.size()]);
    }

    private static XFormCell createLabelCell(Font font, String reference) {
        XFormText xdrilldowntitletext = new XFormText();
        xdrilldowntitletext.id = reference + "label";
        xdrilldowntitletext.reference = reference;
        if (font != null) {
            xdrilldowntitletext.setFontStyle(font.getStyle());
            xdrilldowntitletext.setFonttype(font.getFamily());
            xdrilldowntitletext.setFontsize(10);
        }
        xdrilldowntitletext.displayaslabel = true;
        xdrilldowntitletext.editable = false;
        XFormCell xdrilldowntitlecell = new XFormCell();
        xdrilldowntitlecell.text = xdrilldowntitletext;
        xdrilldowntitlecell.alignment = "left";
        return xdrilldowntitlecell;
    }

    private static XFormCell createSuffixCell(Font font, String reference) {
        XFormLabel xdrilldownsuffixlabel = new XFormLabel();
        xdrilldownsuffixlabel.id = reference + "Suffix";
        xdrilldownsuffixlabel.value = new XFormValue(">");
        if (font != null) {
            xdrilldownsuffixlabel.setFontStyle(font.getStyle());
            xdrilldownsuffixlabel.setFonttype(font.getFamily());
            xdrilldownsuffixlabel.setFontsize(10);
        }
        XFormCell xdrilldownsuffixcell = new XFormCell();
        xdrilldownsuffixcell.label = xdrilldownsuffixlabel;
        xdrilldownsuffixcell.alignment = "left";
        return xdrilldownsuffixcell;
    }

    private static void generatePercentageFillingDataSourceCode(IndentedPrintWriter codePrinter, Measurement measurement, Dimension dimension2, Dimension dimension1, List<MethodTypeDescription> methods, String methodName, WidgetModel widgetModel, TypeDescription returnType, TypeDescription measurementType) {
        boolean xyzGraphic;
        DashboardFactory.printCalculateTotalCode(codePrinter, measurement, dimension2, dimension1);
        codePrinter.println("//Filling data source");
        boolean bl = xyzGraphic = dimension2 != null;
        if (xyzGraphic) {
            codePrinter.println("result as Fuego.Chart.DefaultXYZDataSource");
            codePrinter.println("result = Fuego.Chart.DefaultXYZDataSource()");
        } else {
            codePrinter.println("result as Fuego.Chart.DefaultXYDataSource");
            codePrinter.print("result = Fuego.Chart.DefaultXYDataSource(");
            codePrinter.printQuoted(dimension1.getName());
            codePrinter.print(");");
        }
        codePrinter.println();
        codePrinter.println();
        codePrinter.println("for each element in data");
        codePrinter.println("do");
        codePrinter.indent();
        codePrinter.print("addValue result using value = ");
        codePrinter.print("(");
        codePrinter.print(measurementType.getName());
        codePrinter.print("(element[0])*100)/total");
        if (xyzGraphic) {
            codePrinter.print(", rowHeader = String(element[1])");
            codePrinter.print(", columnHeader = String(element[2])");
        } else {
            codePrinter.print(", columnHeader = String(element[1])");
        }
        codePrinter.println();
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.print("return result");
    }

    private static void addMembersForAutomaticTimeHandling(XObjectTypeDescription xotd) {
        ArrayTypeDescription titlesMap = (ArrayTypeDescription)TypeFactory.getMap(TypeFactory.getString(), TypeFactory.getString());
        try {
            XObjectTypeDescriptionHelper.addAttribute((ObjectTypeDescription)xotd, (String)"valueLabels", (TypeRef)titlesMap.getRef(), null);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private static MethodTypeDescription createWidgetHandlerMethod(String dataSourceMethodName, WidgetModel widgetModel, TypeDescription returnType) {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        codePrinter.println("result as " + returnType.getName() + " = " + dataSourceMethodName + "()");
        codePrinter.println();
        codePrinter.println("changeValueLabel()");
        codePrinter.println();
        codePrinter.println("return result");
        codePrinter.flush();
        codePrinter.close();
        String methodName = DashboardFactory.buildTitleUpdateMethodName(widgetModel);
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        return XObjectTypeDescriptionHelper.createMethod((String)methodName, (TypeDescription)returnType, null, (String)codeWriter.toString(), (String)language);
    }

    private static MethodTypeDescription createChangeValueLabelMethod() {
        return DashboardFactory.createChangeValueLabelMethod(true);
    }

    private static MethodTypeDescription createChangeValueLabelMethod(boolean xyOrXyzGraphic) {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        codePrinter.println("for each key in valueLabels.keys");
        codePrinter.println("do");
        codePrinter.indent();
        if (xyOrXyzGraphic) {
            codePrinter.println("setChartValueLabel this");
        } else {
            codePrinter.println("setGaugeUnit this");
        }
        codePrinter.indent();
        codePrinter.println("using chartId = key,");
        codePrinter.indent();
        codePrinter.println("value = valueLabels[key]");
        codePrinter.dedent();
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.flush();
        codePrinter.close();
        String methodName = "changeValueLabel";
        TypeDescription returnType = TypeFactory.getVoid();
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        return XObjectTypeDescriptionHelper.createMethod((String)"changeValueLabel", (TypeDescription)returnType, null, (String)codeWriter.toString(), (String)language);
    }

    private static void addUnitCalculationCode(IndentedPrintWriter codePrinter, String widgetName, String widgetTitle) {
        codePrinter.dedent();
        codePrinter.println("else");
        codePrinter.indent();
        codePrinter.print("result = result / calculateUnits(result, ");
        codePrinter.printQuoted(widgetName);
        codePrinter.print(", ");
        codePrinter.printQuoted(widgetTitle);
        codePrinter.println(")");
    }

    private static String getDenominatorUnits(WidgetValueType valueType) {
        String result = "";
        if (valueType == WidgetValueType.DAYS) {
            result = "/(3600*24)";
        } else if (valueType == WidgetValueType.HOURS) {
            result = "/3600";
        } else if (valueType == WidgetValueType.MINUTES) {
            result = "/60";
        } else if (valueType == WidgetValueType.SECONDS || valueType == WidgetValueType.VALUE || valueType == WidgetValueType.PERCENTAGE) {
            // empty if block
        }
        return result;
    }

    private static void printCalculateTotalCode(IndentedPrintWriter codePrinter, Measurement measurement, Dimension dimension2, Dimension dimension1) {
        boolean xyzGraphic;
        codePrinter.println("//Calculate total");
        codePrinter.println("total as Decimal");
        codePrinter.println("total = 0");
        codePrinter.println();
        codePrinter.println("counter as Int");
        codePrinter.println("counter = 0");
        codePrinter.println();
        codePrinter.println("data as Any[][]");
        codePrinter.println();
        codePrinter.println("for each row in iterator");
        codePrinter.println("do");
        codePrinter.indent();
        codePrinter.print("total = total + Decimal");
        codePrinter.print("(row[");
        codePrinter.printQuoted(measurement.getColumnName());
        codePrinter.print("])");
        codePrinter.println();
        codePrinter.print("data[counter] = [ ");
        codePrinter.print("row[");
        codePrinter.printQuoted(measurement.getColumnName());
        codePrinter.print("]");
        boolean bl = xyzGraphic = dimension2 != null;
        if (xyzGraphic) {
            codePrinter.print(", row[");
            codePrinter.printQuoted(dimension2.hasDescription() ? dimension2.getDescriptionColumnName() : dimension2.getColumnName());
            codePrinter.print("]");
        }
        codePrinter.print(", row[");
        codePrinter.printQuoted(dimension1.hasDescription() ? dimension1.getDescriptionColumnName() : dimension1.getColumnName());
        codePrinter.print("] ]");
        codePrinter.println();
        codePrinter.print("counter = counter + 1");
        codePrinter.println();
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.println();
    }

    private static void setBorderToCell(XFormCell cell, BorderStyle style, Color color, int width) {
        cell.setTopborderstyle(style);
        cell.setTopColor(Utilities.getString((ColorInfo)color.getInfo()));
        cell.setTopWidth(width);
        cell.setBottomborderstyle(style);
        cell.setBottomColor(Utilities.getString((ColorInfo)color.getInfo()));
        cell.setBottomWidth(width);
        cell.setRightborderstyle(style);
        cell.setRightColor(Utilities.getString((ColorInfo)color.getInfo()));
        cell.setRightWidth(width);
        cell.setLeftborderstyle(style);
        cell.setLeftColor(Utilities.getString((ColorInfo)color.getInfo()));
        cell.setLeftWidth(width);
    }

    private static void addAttributesFromParametricValues(XObjectTypeDescription xotd, WidgetDataModel dataModel) {
        if (dataModel.isParametricActivity()) {
            DashboardFactory.addAttribute(xotd, "activity");
        }
        if (dataModel.isParametricProcess()) {
            DashboardFactory.addAttribute(xotd, "process");
        }
        if (dataModel.isParametricOu()) {
            DashboardFactory.addAttribute(xotd, "ou");
        }
    }

    private static void addAttribute(XObjectTypeDescription xotd, String attributeName) {
        try {
            XObjectTypeDescriptionHelper.addAttribute((ObjectTypeDescription)xotd, (String)attributeName, (TypeRef)TypeFactory.getString(), null);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Throwable)e);
        }
    }

    private static String getWidgetModelNameAsMethodName(WidgetModel widgetModel) {
        assert (widgetModel != null) : "The widgetModel can not be null!";
        String widgetName = widgetModel.getName();
        widgetName = DashboardMethodFactory.getAsMethodName((String)widgetName);
        return widgetName;
    }

    private static String buildFillingMethodName(WidgetModel widgetModel) {
        return DashboardFactory.getWidgetModelNameAsMethodName(widgetModel) + METHOD_FILLING_SUFFIX;
    }

    private static String buildTitleUpdateMethodName(WidgetModel widgetModel) {
        return DashboardFactory.buildFillingMethodName(widgetModel) + TITLE_UPDATE_METHOD_SUFFIX;
    }

    private static String buildQueryMethodName(WidgetModel widgetModel) {
        return DashboardFactory.getWidgetModelNameAsMethodName(widgetModel) + METHOD_DB_QUERY_SUFFIX;
    }

    private void generateFillingMethodForGauge(IndentedPrintWriter codePrinter, TypeDescription measurementType, Measurement measurement, WidgetValueType valueType, List<MethodTypeDescription> methods, String methodName, WidgetModel widgetModel, TypeDescription returnType) {
        codePrinter.println("//Filling data source");
        codePrinter.print("result as ");
        codePrinter.println(measurementType.getName());
        codePrinter.println();
        codePrinter.println("for each row in iterator");
        codePrinter.println("do");
        codePrinter.indent();
        codePrinter.print("result = ");
        codePrinter.print(measurementType.getName());
        codePrinter.print("(row[");
        codePrinter.printQuoted(measurement.getColumnName());
        codePrinter.print("])");
        codePrinter.print(DashboardFactory.getDenominatorUnits(valueType));
        codePrinter.println();
        codePrinter.println("if result == null then");
        codePrinter.indent();
        codePrinter.println("result = Decimal(0)");
        if (valueType == WidgetValueType.AUTOMATIC_TIME_HANDLING) {
            boolean xyOrXyzGraphic;
            methods.add(DashboardFactory.createWidgetHandlerMethod(methodName, widgetModel, returnType));
            WidgetDataModel widgetDataModel = widgetModel.getDataModel();
            List dimensions = widgetDataModel.getDimensions();
            Dimension dimension1 = null;
            boolean bl = xyOrXyzGraphic = dimension1 != null;
            if (dimensions != null) {
                for (int i = 0; i < dimensions.size(); ++i) {
                    Dimension dimension = (Dimension)dimensions.get(i);
                    if (dimension.getDimensionType() != DimensionType.DIMENSION || dimension1 != null) continue;
                    dimension1 = dimension;
                }
            }
            methods.add(DashboardFactory.createChangeValueLabelMethod(xyOrXyzGraphic));
            methods.add(this.createCalculateUnitsMethod(widgetModel.getProject()));
            DashboardFactory.addUnitCalculationCode(codePrinter, widgetModel.getName(), widgetModel.getPresentationModel().getTitle());
        }
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.println();
        codePrinter.print("return result");
    }

    private void generateFillingDataSourceCode(IndentedPrintWriter codePrinter, Dimension dimension2, Dimension dimension1, WidgetValueType valueType, List<MethodTypeDescription> methods, String methodName, WidgetModel widgetModel, TypeDescription returnType, Measurement measurement, TypeDescription measurementType) {
        boolean xyzGraphic;
        codePrinter.println("//Filling data source");
        boolean bl = xyzGraphic = dimension2 != null;
        if (xyzGraphic) {
            codePrinter.println("result as Fuego.Chart.DefaultXYZDataSource");
            codePrinter.println("result = Fuego.Chart.DefaultXYZDataSource()");
        } else {
            codePrinter.println("result as Fuego.Chart.DefaultXYDataSource");
            codePrinter.print("result = Fuego.Chart.DefaultXYDataSource(");
            codePrinter.printQuoted(dimension1.getName());
            codePrinter.print(");");
        }
        codePrinter.println();
        codePrinter.println();
        if (valueType == WidgetValueType.AUTOMATIC_TIME_HANDLING) {
            methods.add(DashboardFactory.createWidgetHandlerMethod(methodName, widgetModel, returnType));
            methods.add(DashboardFactory.createChangeValueLabelMethod());
            methods.add(this.createCalculateUnitsMethod(widgetModel.getProject()));
            String dim2ArrayName = "";
            if (xyzGraphic) {
                dim2ArrayName = dimension2.hasDescription() ? dimension2.getDescriptionColumnName() : dimension2.getColumnName();
                codePrinter.print(dim2ArrayName + "s as String[]");
                codePrinter.println();
            }
            String dim1ArrayName = dimension1.hasDescription() ? dimension1.getDescriptionColumnName() : dimension1.getColumnName();
            codePrinter.print(dim1ArrayName + "s as String[]");
            codePrinter.println();
            String measurementName = measurement.getColumnName();
            codePrinter.print(measurementName + "s as Real[]");
            codePrinter.println();
            codePrinter.println();
            codePrinter.println("greatestValue as Real = 0");
            codePrinter.println();
            codePrinter.println("for each row in iterator");
            codePrinter.println("do");
            codePrinter.indent();
            if (xyzGraphic) {
                codePrinter.print(dim2ArrayName + "s[] = String(row[");
                codePrinter.printQuoted(dim2ArrayName);
                codePrinter.print("])");
                codePrinter.println();
            }
            codePrinter.print(dim1ArrayName + "s[] = String(row[");
            codePrinter.printQuoted(dim1ArrayName);
            codePrinter.print("])");
            codePrinter.println();
            codePrinter.print(measurementName + "s[] = Real(row[");
            codePrinter.printQuoted(measurementName);
            codePrinter.print("])");
            codePrinter.println();
            codePrinter.println("if greatestValue < " + measurementName + "s.last then");
            codePrinter.indent();
            codePrinter.println("greatestValue = " + measurementName + "s.last");
            codePrinter.dedent();
            codePrinter.println("end");
            codePrinter.dedent();
            codePrinter.println("end");
            codePrinter.println();
            codePrinter.println();
            codePrinter.println("denominator as Decimal");
            codePrinter.print("denominator = calculateUnits(greatestValue, ");
            codePrinter.printQuoted(widgetModel.getName());
            codePrinter.print(", ");
            codePrinter.printQuoted(widgetModel.getPresentationModel().getTitle());
            codePrinter.println(")");
            codePrinter.println();
            codePrinter.println("for i in 0 .. length(" + dim1ArrayName + "s)-1");
            codePrinter.println("do");
            codePrinter.indent();
            codePrinter.println("addValue result");
            codePrinter.indent();
            codePrinter.println("using");
            codePrinter.indent();
            codePrinter.println("value = " + measurementName + "s[i] / denominator,");
            codePrinter.indent();
            if (xyzGraphic) {
                codePrinter.println("rowHeader = " + dim2ArrayName + "s[i],");
                codePrinter.indent();
            }
            codePrinter.println("columnHeader = " + dim1ArrayName + "s[i]");
            codePrinter.dedent();
            codePrinter.dedent();
            if (xyzGraphic) {
                codePrinter.dedent();
            }
            codePrinter.dedent();
            codePrinter.dedent();
            codePrinter.println("end");
        } else {
            codePrinter.println("for each row in iterator");
            codePrinter.println("do");
            codePrinter.indent();
            codePrinter.print("addValue result using value = ");
            codePrinter.print(measurementType.getName());
            codePrinter.print("(row[");
            codePrinter.printQuoted(measurement.getColumnName());
            codePrinter.print("])");
            codePrinter.print(DashboardFactory.getDenominatorUnits(valueType));
            if (xyzGraphic) {
                codePrinter.print(", rowHeader = String(row[");
                codePrinter.printQuoted(dimension2.hasDescription() ? dimension2.getDescriptionColumnName() : dimension2.getColumnName());
                codePrinter.print("])");
            }
            codePrinter.print(", columnHeader = String(row[");
            codePrinter.printQuoted(dimension1.hasDescription() ? dimension1.getDescriptionColumnName() : dimension1.getColumnName());
            codePrinter.print("])");
            codePrinter.println();
            codePrinter.dedent();
            codePrinter.println("end");
        }
        codePrinter.print("return result");
    }

    private MethodTypeDescription createCalculateUnitsMethod(Project project) {
        String language;
        StringWriter codeWriter = new StringWriter();
        IndentedPrintWriter codePrinter = new IndentedPrintWriter(codeWriter);
        codePrinter.println("denominator as Decimal");
        codePrinter.println("valueLabel as String");
        codePrinter.println();
        codePrinter.println("if value / 60 > 60 then");
        codePrinter.indent();
        codePrinter.println("//days");
        codePrinter.println("if value / 3600 > 24 then");
        codePrinter.indent();
        codePrinter.println("denominator = 3600 * 24");
        codePrinter.print("valueLabel = ");
        Locale defaultLanguage = project.getDefaultLanguage();
        codePrinter.printQuoted(CoreMsg.DAYS.getString(defaultLanguage));
        codePrinter.println();
        codePrinter.dedent();
        codePrinter.println("else");
        codePrinter.indent();
        codePrinter.println("//hours");
        codePrinter.println("denominator = 3600");
        codePrinter.print("valueLabel = ");
        codePrinter.printQuoted(CoreMsg.HOURS.getString(defaultLanguage));
        codePrinter.println();
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.dedent();
        codePrinter.println("else");
        codePrinter.indent();
        codePrinter.println("//minutes");
        codePrinter.println("if value / 60 > 1 then");
        codePrinter.indent();
        codePrinter.println("denominator = 60");
        codePrinter.print("valueLabel = ");
        codePrinter.printQuoted(CoreMsg.MINUTES.getString(defaultLanguage));
        codePrinter.println();
        codePrinter.dedent();
        codePrinter.println("else");
        codePrinter.indent();
        codePrinter.println("//seconds");
        codePrinter.println("denominator = 1");
        codePrinter.print("valueLabel = ");
        codePrinter.printQuoted(CoreMsg.SECONDS.getString(defaultLanguage));
        codePrinter.println();
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.dedent();
        codePrinter.println("end");
        codePrinter.println();
        codePrinter.print("valueLabels[graphicId] = valueLabel");
        codePrinter.println();
        codePrinter.println("return denominator");
        codePrinter.flush();
        codePrinter.close();
        TypeDescription returnType = TypeFactory.getDecimal();
        try {
            language = LanguageSpec.getLanguageSpec((String)"Fuego").getId();
        }
        catch (InvalidLanguageException e) {
            language = "Fuego";
        }
        Argument valueArgument = new Argument("value", TypeFactory.getReal(), 1L);
        Argument graphicIdArgument = new Argument("graphicId", TypeFactory.getString(), 1L);
        Argument titleArgument = new Argument("title", TypeFactory.getString(), 1L);
        Argument[] arguments = new Argument[]{valueArgument, graphicIdArgument, titleArgument};
        String methodName = "calculateUnits";
        MethodTypeDescription methodType = XObjectTypeDescriptionHelper.createMethod((String)"calculateUnits", (TypeDescription)returnType, (Argument[])arguments, (String)codeWriter.toString(), (String)language);
        methodType.addModifiers(65536L);
        return methodType;
    }
}

