/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.thrower;

import java.util.Locale;
import oracle.bpm.designer.ParticipantEditorPanel;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ConversationOption;
import oracle.bpm.designer.conversation.ConversationOptionLabelProvider;
import oracle.bpm.designer.conversation.editor.common.ConversationNotImplementedEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationProcessEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationServiceEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ConversationThrowerInitiatorPanel
extends ComboBoxSelectorPanel<ThrowerInitiatorOptions, ConversationEnabled> {
    private ConversationThrowerInitiatorPanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        super(parent, DesignerMsg.PROPERTIES, conversationalNode, DesignerMsg.CONVERSATION_IMPLEMENTATION, 5);
        this.init();
    }

    public static ConversationThrowerInitiatorPanel create(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        ConversationThrowerInitiatorPanel result = new ConversationThrowerInitiatorPanel(parent, conversationalNode);
        result.setLabelProvider(new ConversationOptionLabelProvider());
        return result;
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        if (conversationalNode != null) {
            ThrowerInitiatorOptions option = null;
            if (!ConversationHelper.hasImplementation((ConversationEnabled)conversationalNode)) {
                option = ThrowerInitiatorOptions.NOT_IMPLEMENTED;
            } else if (ConversationHelper.usesProcess((ConversationEnabled)conversationalNode)) {
                option = ThrowerInitiatorOptions.PROCESS;
            } else if (ConversationHelper.usesService((ConversationEnabled)conversationalNode)) {
                option = ThrowerInitiatorOptions.SERVICE;
            }
            if (option != null) {
                this.setSelectedOption(option);
                this.getInnerEditor().objectToEditor(null);
            } else {
                MessageDialog.showNotice((Msg)DesignerMsg.CONVERSATION_INVALID_IMPLEMENTATION_NOTICE);
            }
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        conversationalNode.setConversationInitiator(null);
        ProjectObjectEditorPanel innerEditor = this.getInnerEditor();
        if (innerEditor != null) {
            innerEditor.editorToObject();
        }
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        this.getInnerEditor().validatePanel();
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor(@NotNull UiContainer container, @NotNull ThrowerInitiatorOptions selectedItem) {
        ProjectObjectEditorPanel result = null;
        switch (selectedItem) {
            case SERVICE: {
                result = new ConversationServiceEditor(container, (ParticipantEnabled)this.getProjectObject(), ParticipantEditorPanel.ServiceEditorServiceType.INVOKE, ParticipantEditorPanel.ServiceEditorSynchronicityType.ASYNCHRONOUS, ParticipantEditorPanel.ServiceEditorInterfaceType.SERVICE);
                break;
            }
            case PROCESS: {
                result = ConversationProcessEditor.createThrowerInitiatorEditor(container, (ConversationEnabled)this.getProjectObject());
                break;
            }
            case NOT_IMPLEMENTED: {
                result = new ConversationNotImplementedEditor(container, (ConversationEnabled)this.getProjectObject());
            }
        }
        return result;
    }

    private void init() {
        if (!ConversationHelper.mustImplement((ConversationEnabled)((ConversationEnabled)this.getProjectObject()))) {
            this.addOption(ThrowerInitiatorOptions.SERVICE);
            this.addOption(ThrowerInitiatorOptions.PROCESS);
        }
        this.addOption(ThrowerInitiatorOptions.NOT_IMPLEMENTED);
        this.setSelectedOption(this.getOptions().iterator().next());
    }

    public static enum ThrowerInitiatorOptions implements ConversationOption
    {
        SERVICE(DesignerMsg.SERVICE_CALL),
        PROCESS(DesignerMsg.PROCESS_CALL),
        NOT_IMPLEMENTED(DesignerMsg.NOT_IMPLEMENTED);

        private Msg msg;

        private ThrowerInitiatorOptions(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }

        @Override
        public Image getIcon() {
            return Image.create((Msg)this.msg);
        }
    }
}

