/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.thrower;

import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.editor.AbstractConversationContinuatorEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationDefinitionEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationNotImplementedEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationProcessEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationServiceEditor;
import oracle.bpm.designer.conversation.editor.thrower.ConversationThrowEventContinuatorCatchDefinePanel;
import oracle.bpm.designer.conversation.editor.thrower.ConversationThrowEventContinuatorCatchUsePanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ConversationThrowerContinuatorPanel
extends AbstractConversationContinuatorEditor {
    public ConversationThrowerContinuatorPanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        super(parent, null, conversationalNode, selectedInitiator);
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor() {
        ProjectObjectEditorPanel result;
        ConversationEnabled initiator = this.getSelectedInitiator();
        ConversationEnabled node = (ConversationEnabled)this.getProjectObject();
        if (!ConversationHelper.hasImplementation((ConversationEnabled)initiator)) {
            result = new ConversationNotImplementedEditor((UiContainer)this, node, DesignerMsg.CONVERSATION_INITIATOR_NOT_IMPLEMENTED);
        } else if (ConversationHelper.isCatcher((ConversationEnabled)initiator)) {
            if (ConversationHelper.usesService((ConversationEnabled)initiator)) {
                InterfaceObject service = (InterfaceObject)initiator.getParticipant();
                if (Event.class.isAssignableFrom(((ConversationEnabled)this.getProjectObject()).getRawClass()) && service.isSync()) {
                    result = ConversationThrowEventContinuatorCatchUsePanel.create((UiContainer)this, node, initiator);
                } else {
                    if (!service.isSync()) {
                        service = ConversationHelper.getCallbackInterface((InterfaceObject)service);
                    }
                    result = new ConversationServiceEditor((UiContainer)this, (ParticipantEnabled)node, (CatalogObject)service);
                }
            } else if (Event.class.isAssignableFrom(((ConversationEnabled)this.getProjectObject()).getRawClass()) && initiator.isSync()) {
                result = ConversationThrowEventContinuatorCatchDefinePanel.create((UiContainer)this, node, initiator);
            } else {
                boolean isSync = initiator.isSync();
                String operationName = initiator.isSync() ? initiator.getDefinedOperationName() : null;
                result = new ConversationDefinitionEditor((UiContainer)this, node, operationName, isSync);
            }
        } else if (ConversationHelper.usesProcess((ConversationEnabled)initiator)) {
            result = ConversationProcessEditor.createThrowerContinuesThrowerEditor((UiContainer)this, node, this.getSelectedInitiator());
        } else {
            CatalogObject service = initiator.getParticipant();
            result = new ConversationServiceEditor((UiContainer)this, (ParticipantEnabled)node, service);
        }
        return result;
    }
}

