/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.thrower;

import java.util.Locale;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ConversationOption;
import oracle.bpm.designer.conversation.ConversationOptionLabelProvider;
import oracle.bpm.designer.conversation.editor.common.ConversationErrorEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationNotImplementedEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationServiceEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class ConversationThrowEventContinuatorCatchUsePanel
extends ComboBoxSelectorPanel<ThrowEventContinuatorCatchUseOptions, ConversationEnabled> {
    private ConversationEnabled selectedInitiator;

    private ConversationThrowEventContinuatorCatchUsePanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        super(parent, DesignerMsg.PROPERTIES, conversationalNode, DesignerMsg.CONVERSATION_IMPLEMENTATION, 5);
        this.selectedInitiator = selectedInitiator;
        this.init();
    }

    public static ConversationThrowEventContinuatorCatchUsePanel create(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        ConversationThrowEventContinuatorCatchUsePanel result = new ConversationThrowEventContinuatorCatchUsePanel(parent, conversationalNode, selectedInitiator);
        result.setLabelProvider(new ConversationOptionLabelProvider());
        return result;
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        if (conversationalNode != null) {
            ThrowEventContinuatorCatchUseOptions option = null;
            if (!ConversationHelper.hasImplementation((ConversationEnabled)conversationalNode)) {
                option = ThrowEventContinuatorCatchUseOptions.NOT_IMPLEMENTED;
            } else if (ConversationHelper.usesService((ConversationEnabled)conversationalNode)) {
                option = ThrowEventContinuatorCatchUseOptions.USE;
            } else if (ConversationHelper.usesError((ConversationEnabled)conversationalNode)) {
                option = ThrowEventContinuatorCatchUseOptions.ERROR;
            }
            if (option != null) {
                this.setSelectedOption(option);
                this.getInnerEditor().objectToEditor(null);
            } else {
                MessageDialog.showNotice((Msg)DesignerMsg.CONVERSATION_INVALID_IMPLEMENTATION_NOTICE);
            }
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        ProjectObjectEditorPanel innerEditor = this.getInnerEditor();
        if (innerEditor != null) {
            innerEditor.editorToObject();
        }
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        this.getInnerEditor().validatePanel();
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor(@NotNull UiContainer container, @NotNull ThrowEventContinuatorCatchUseOptions selectedItem) {
        ProjectObjectEditorPanel result = null;
        switch (selectedItem) {
            case USE: {
                InterfaceObject service = (InterfaceObject)this.selectedInitiator.getParticipant();
                if (!service.isSync()) {
                    service = ConversationHelper.getCallbackInterface((InterfaceObject)service);
                    result = new ConversationServiceEditor((UiContainer)this, (ParticipantEnabled)this.getProjectObject(), (CatalogObject)service);
                    break;
                }
                CatalogMember operation = this.selectedInitiator.getOperation();
                result = new ConversationServiceEditor((UiContainer)this, (ParticipantEnabled)this.getProjectObject(), operation);
                break;
            }
            case ERROR: {
                CatalogMember exceptionsProvider = this.selectedInitiator.getOperation();
                result = new ConversationErrorEditor(container, (ConversationEnabled)this.getProjectObject(), exceptionsProvider);
                break;
            }
            case NOT_IMPLEMENTED: {
                result = new ConversationNotImplementedEditor(container, (ConversationEnabled)this.getProjectObject());
            }
        }
        return result;
    }

    private void init() {
        if (!ConversationHelper.mustImplement((ConversationEnabled)((ConversationEnabled)this.getProjectObject()))) {
            this.addOption(ThrowEventContinuatorCatchUseOptions.USE);
            this.addOption(ThrowEventContinuatorCatchUseOptions.ERROR);
        }
        this.addOption(ThrowEventContinuatorCatchUseOptions.NOT_IMPLEMENTED);
        this.setSelectedOption(this.getOptions().iterator().next());
    }

    public static enum ThrowEventContinuatorCatchUseOptions implements ConversationOption
    {
        USE(DesignerMsg.USE_FROM_CATALOG),
        ERROR(DesignerMsg.EXCEPTION),
        NOT_IMPLEMENTED(DesignerMsg.NOT_IMPLEMENTED);

        private Msg msg;

        private ThrowEventContinuatorCatchUseOptions(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }

        @Override
        public Image getIcon() {
            return Image.create((Msg)this.msg);
        }
    }
}

