/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.common;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProcessCommunicationEditorPanel;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessCommunicationEnabled;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public abstract class ConversationProcessEditor
extends ProcessCommunicationEditorPanel {
    protected ConversationEnabled selectedInitiator;

    public ConversationProcessEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        super(parent, (ProcessCommunicationEnabled)conversationalNode);
    }

    public ConversationProcessEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        super(parent, (ProcessCommunicationEnabled)conversationalNode, selectedInitiator.getAssociatedProcess());
        this.selectedInitiator = selectedInitiator;
    }

    public static ConversationProcessEditor createThrowerInitiatorEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        return new AsyncInitiatorNodesProcessEditor(parent, conversationalNode);
    }

    public static ConversationProcessEditor createThrowerContinuesThrowerEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        return ConversationProcessEditor.createCatcherContinuatorEditor(parent, conversationalNode, selectedInitiator, false);
    }

    public static ConversationProcessEditor createCatcherContinuesThrowerEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        return ConversationProcessEditor.createCatcherContinuatorEditor(parent, conversationalNode, selectedInitiator, true);
    }

    public ConversationEnabled getSelectedInitiator() {
        return this.selectedInitiator;
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = this.getProjectObject();
        conversationalNode.setOperation(null);
        conversationalNode.setSync(false);
        conversationalNode.setDefinedOperationName(null);
        conversationalNode.setAssociatedError(null);
        super.editorToObject();
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        ConversationEnabled projectObject = this.getProjectObject();
        String label = ((FlowNode)projectObject).getDefaultLabel();
        if (this.processBrowser.getValue() == null) {
            throw new ProjectException((ProjectObject)projectObject, ProjectCompileMsg.PROCESS_NULL((String)label));
        }
        if (this.nodeComboBox.getSelectedItem() == null) {
            throw new ProjectException((ProjectObject)projectObject, ProjectCompileMsg.NODE_NULL((String)label));
        }
        super.validatePanel();
    }

    @Override
    protected ConversationEnabled getProjectObject() {
        return (ConversationEnabled)super.getProjectObject();
    }

    private static ConversationProcessEditor createCatcherContinuatorEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator, boolean showThrowers) {
        ContinuatorNodesProcessEditor processEditor = new ContinuatorNodesProcessEditor(parent, conversationalNode, selectedInitiator, showThrowers);
        processEditor.reloadNodeComboBox();
        return processEditor;
    }

    private static class ContinuatorNodesProcessEditor
    extends ConversationProcessEditor {
        private boolean showThrowers;

        public ContinuatorNodesProcessEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator, boolean showThrowers) {
            super(parent, conversationalNode, selectedInitiator);
            this.showThrowers = showThrowers;
        }

        @Override
        protected Sequence<ConversationEnabled> getNodes() {
            ConversationEnabled relatedInitiatorNode;
            Sequence result = CollectionUtils.emptySequence();
            ConversationEnabled initiator = this.getSelectedInitiator();
            if (initiator != null && (relatedInitiatorNode = initiator.getAssociatedNode()) != null) {
                result = this.showThrowers ? ConversationHelper.getContinuatorsThrowers((ConversationEnabled)relatedInitiatorNode, (boolean)true) : ConversationHelper.getContinuatorsCatchers((ConversationEnabled)relatedInitiatorNode);
            }
            return result;
        }
    }

    private static class AsyncInitiatorNodesProcessEditor
    extends ConversationProcessEditor {
        public AsyncInitiatorNodesProcessEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
            super(parent, conversationalNode);
        }

        @Override
        protected Sequence<ConversationEnabled> getNodes() {
            Sequence result = CollectionUtils.emptySequence();
            Process selectedProcess = this.getSelectedProcess();
            if (selectedProcess != null) {
                result = ConversationHelper.getAsyncInitiatorCatchers((Process)selectedProcess, (BpmnType)this.getProjectObjectBpmnType());
            }
            return result;
        }
    }
}

