/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.common;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ProjectObjectBrowser;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ConversationErrorEditor
extends ProjectObjectEditorPanel<ConversationEnabled> {
    private ProjectObjectBrowser<ErrorObject> errorBrowser;
    private CatalogMember exceptionsMember;

    public ConversationErrorEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        this(parent, conversationalNode, null);
    }

    public ConversationErrorEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, CatalogMember exceptionsMember) {
        super(parent, conversationalNode);
        this.exceptionsMember = exceptionsMember;
        this.init();
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        ErrorObject error = conversationalNode.getAssociatedError();
        if (error != null) {
            this.errorBrowser.setValue(error);
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        conversationalNode.setAssociatedNode(null);
        conversationalNode.setSync(false);
        conversationalNode.setDefinedOperationName(null);
        conversationalNode.setOperation(null);
        conversationalNode.setAssociatedError(this.errorBrowser.getValue());
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        Object projectObject = this.getProjectObject();
        if (this.errorBrowser.getValue() == null || !this.errorBrowser.isValidSelection()) {
            throw new ProjectException(projectObject, ProjectCompileMsg.EXCEPTION_INVALID((String)((ConversationEnabled)this.getProjectObject()).getDefaultLabel()));
        }
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.EXCEPTION));
        this.errorBrowser = this.createErrorBrowser((UiContainer)this);
        this.add((UiComponent)this.errorBrowser, "growx, gapx 5");
    }

    private ProjectObjectBrowser<ErrorObject> createErrorBrowser(@NotNull UiContainer container) {
        CatalogModule root = ((ConversationEnabled)this.getProjectObject()).getProject().getCatalogRoot();
        ProjectObjectBrowser<ErrorObject> result = new ProjectObjectBrowser<ErrorObject>(container, this.getFilter(), (ProjectObjectContainer)root);
        LabelProvider.Default<ErrorObject> labelProvider = new LabelProvider.Default<ErrorObject>(){

            public String getText(ErrorObject element) {
                return element.getName();
            }
        };
        result.setLabelProvider((LabelProvider<ErrorObject>)labelProvider);
        return result;
    }

    private ProjectFilter getFilter() {
        if (this.exceptionsMember != null) {
            return new ProjectFilter(){

                @NotNull
                public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
                    Sequence result = object == ((ConversationEnabled)ConversationErrorEditor.this.getProjectObject()).getProject().getCatalogRoot() ? ConversationErrorEditor.this.exceptionsMember.getExceptions() : CollectionUtils.emptySequence();
                    return result;
                }

                public ProjectObjectContainer getParent(ProjectObject object) {
                    return (ProjectObjectContainer)object.getParentObject();
                }
            };
        }
        return ProjectFilters.FAULT_OBJECTS;
    }
}

