/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.common;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.argumentsdefinition.ArgumentsDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CollapsablePanel;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class ConversationDefinitionEditor
extends ProjectObjectEditorPanel<ConversationEnabled> {
    private ArgumentsDefinitionPanel argumentsDefinitionPanel;
    private OperationNamePanel operationNamePanel;
    private SynchronicityPanel synchronicityPanel;

    public ConversationDefinitionEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        this(parent, conversationalNode, null, null);
    }

    public ConversationDefinitionEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled fixedReference) {
        super(parent, conversationalNode);
        this.init(fixedReference, fixedReference.getDefinedOperationName(), fixedReference.isSync());
    }

    public ConversationDefinitionEditor(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, String fixedOperation, Boolean fixedSync) {
        super(parent, conversationalNode);
        this.init(null, fixedOperation, fixedSync);
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        if (ConversationHelper.isDefiner((ConversationEnabled)conversationalNode) && this.argumentsDefinitionPanel.isEnabled()) {
            UiContainer container = this.argumentsDefinitionPanel.getParent();
            container.remove((UiComponent)this.argumentsDefinitionPanel);
            ProcessArgumentContainer inputsContainer = this.getInputsContainer(conversationalNode) != null ? new ProcessArgumentContainer(this.getInputsContainer(conversationalNode)) : null;
            ProcessArgumentContainer outputsContainer = this.getOutputsContainer(conversationalNode) != null ? new ProcessArgumentContainer(this.getOutputsContainer(conversationalNode)) : null;
            this.argumentsDefinitionPanel = this.createArgumentsDefinitionPanel(container, (DataDeclarationContainer)inputsContainer, (DataDeclarationContainer)outputsContainer);
            container.add((UiComponent)this.argumentsDefinitionPanel, (Object)"Center");
        }
        this.synchronicityPanel.setSynchronicity(conversationalNode.isSync());
        String definedOperationName = conversationalNode.getDefinedOperationName();
        if (definedOperationName != null) {
            this.operationNamePanel.setOperationName(definedOperationName);
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        conversationalNode.setAssociatedNode(null);
        conversationalNode.setOperation(null);
        conversationalNode.setAssociatedError(null);
        conversationalNode.setSync(this.synchronicityPanel.getSynchronicity());
        conversationalNode.setDefinedOperationName(this.operationNamePanel.getOperationName());
        if (this.argumentsDefinitionPanel.isEnabled()) {
            DataDeclarationContainer newOutputsContainer;
            DataDeclarationContainer newInputsContainer = this.getInputsContainer(conversationalNode);
            if (newInputsContainer != null) {
                this.copyArguments(this.argumentsDefinitionPanel.getInputArgumentsContainer(), newInputsContainer);
            }
            if ((newOutputsContainer = this.getOutputsContainer(conversationalNode)) != null) {
                this.copyArguments(this.argumentsDefinitionPanel.getOutputsArgumentsContainer(), newOutputsContainer);
            }
        }
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        Object projectObject = this.getProjectObject();
        String label = ((ConversationEnabled)this.getProjectObject()).getDefaultLabel();
        if (Str.isEmpty(this.operationNamePanel.getOperationName())) {
            throw new ProjectException(projectObject, ProjectCompileMsg.CONVERSATION_OPERATION_NULL((String)label));
        }
        if (this.operationNamePanel.isEnabled() && !this.operationNamePanel.getOperationName().equals(((ConversationEnabled)this.getProjectObject()).getDefinedOperationName()) && ConversationHelper.operationNameExists((String)this.operationNamePanel.getOperationName(), (ConversationEnabled)((ConversationEnabled)this.getProjectObject()))) {
            throw new ProjectException(projectObject, ProjectCompileMsg.CONVERSATION_OPERATION_DUPLICATED((String)label));
        }
    }

    private void copyArguments(@NotNull DataDeclarationContainer source, @NotNull DataDeclarationContainer target) {
        try {
            target.clearDeclarations();
            for (DataDeclaration argument : source.getLocalDeclarations()) {
                DataDeclaration inputArg = target.createDeclaration(argument.getName(), argument.getType());
                target.addDeclaration(inputArg);
            }
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(ConversationEnabled fixedArgumentsRef, String fixedOperation, Boolean fixedSync) {
        DataDeclarationContainer outputsContainer;
        DataDeclarationContainer inputsContainer;
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        ConversationEnabled argumentsNode = (ConversationEnabled)this.getProjectObject();
        Project project = argumentsNode.getProject();
        boolean argumentsMutable = true;
        if (fixedArgumentsRef != null) {
            inputsContainer = this.getInputsContainer(fixedArgumentsRef);
            outputsContainer = this.getOutputsContainer(fixedArgumentsRef);
            argumentsMutable = false;
        } else {
            inputsContainer = this.nodeHasInputs(argumentsNode) ? new ProcessArgumentContainer(project) : null;
            outputsContainer = this.nodeHasOutputs(argumentsNode) ? new ProcessArgumentContainer(project) : null;
        }
        Panel argumentsDefinitionPanelContainer = new Panel((UiContainer)this);
        argumentsDefinitionPanelContainer.setLayout((Layout)new BorderLayout());
        this.argumentsDefinitionPanel = this.createArgumentsDefinitionPanel((UiContainer)argumentsDefinitionPanelContainer, inputsContainer, outputsContainer);
        this.argumentsDefinitionPanel.setEnabled(argumentsMutable);
        argumentsDefinitionPanelContainer.add((UiComponent)this.argumentsDefinitionPanel, (Object)"Center");
        this.add((UiComponent)argumentsDefinitionPanelContainer, "height 110, growx, gapy 5, wrap");
        CollapsablePanel advancedPanel = new CollapsablePanel((UiContainer)this, UIMsg.ADVANCED, true);
        Panel advancedContainer = advancedPanel.getContainer();
        advancedContainer.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.synchronicityPanel = new SynchronicityPanel((UiContainer)advancedContainer);
        advancedContainer.add((UiComponent)this.synchronicityPanel, (Object)"wrap");
        if (fixedSync != null) {
            this.synchronicityPanel.setEnabled(false);
            this.synchronicityPanel.setSynchronicity(fixedSync);
        }
        this.operationNamePanel = new OperationNamePanel((UiContainer)advancedContainer);
        advancedContainer.add((UiComponent)this.operationNamePanel, (Object)"gapy 5, growx");
        if (fixedOperation != null) {
            this.operationNamePanel.setEnabled(false);
            this.operationNamePanel.setOperationName(fixedOperation);
        } else {
            this.operationNamePanel.setOperationName(ConversationHelper.getDefaultOperationName((ConversationEnabled)((ConversationEnabled)this.getProjectObject())));
        }
        this.add((UiComponent)advancedPanel, "gapy 5, growx");
    }

    private DataDeclarationContainer getInputsContainer(@NotNull ConversationEnabled argumentsNode) {
        DataDeclarationContainer result = null;
        if (this.nodeHasInputs(argumentsNode)) {
            InputArgumentsEnabled inputNode = (InputArgumentsEnabled)argumentsNode;
            result = inputNode.getInputArgumentsContainer();
        }
        return result;
    }

    private DataDeclarationContainer getOutputsContainer(@NotNull ConversationEnabled argumentsNode) {
        DataDeclarationContainer result = null;
        if (this.nodeHasOutputs(argumentsNode)) {
            OutputArgumentsEnabled outputNode = (OutputArgumentsEnabled)argumentsNode;
            result = outputNode.getOutputArgumentsContainer();
        }
        return result;
    }

    private ArgumentsDefinitionPanel createArgumentsDefinitionPanel(@NotNull UiContainer container, DataDeclarationContainer inputs, DataDeclarationContainer output) {
        return new ArgumentsDefinitionPanel(container, inputs, output);
    }

    private boolean nodeHasInputs(@NotNull ConversationEnabled conversationalNode) {
        return InputArgumentsEnabled.class.isAssignableFrom(conversationalNode.getRawClass());
    }

    private boolean nodeHasOutputs(@NotNull ConversationEnabled conversationalNode) {
        return OutputArgumentsEnabled.class.isAssignableFrom(conversationalNode.getRawClass());
    }

    private static class SynchronicityPanel
    extends Panel {
        private ButtonGroup<RadioButton<Boolean>> synchronicityGroup = new ButtonGroup();
        private Map<Boolean, RadioButton<Boolean>> synchronicityRadios = new HashMap<Boolean, RadioButton<Boolean>>();

        public SynchronicityPanel(@NotNull UiContainer parent) {
            super(parent);
            this.init();
        }

        public void setSynchronicity(boolean isSync) {
            RadioButton<Boolean> radio = this.synchronicityRadios.get(isSync);
            if (radio != null) {
                this.synchronicityGroup.setSelected(radio, true);
            }
        }

        public boolean getSynchronicity() {
            return (Boolean)((RadioButton)this.synchronicityGroup.getSelection()).getItem();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            for (RadioButton<Boolean> radio : this.synchronicityRadios.values()) {
                radio.setEnabled(enabled);
            }
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            this.addSyncRadioButton(DesignerMsg.ASYNCHRONOUS, false);
            this.addSyncRadioButton(DesignerMsg.SYNCHRONOUS, true);
            this.setSynchronicity(false);
        }

        private void addSyncRadioButton(@NotNull Msg msg, boolean value) {
            RadioButton radio = new RadioButton((UiContainer)this, msg);
            radio.setItem((Object)value);
            this.synchronicityGroup.add((AbstractButton)radio);
            this.synchronicityRadios.put(value, (RadioButton<Boolean>)radio);
            this.add((UiComponent)radio, "gapright 5");
        }
    }

    private static class OperationNamePanel
    extends Panel {
        private Label operationNameLabel;
        private IdentifierTextField operationNameTextField;

        public OperationNamePanel(@NotNull UiContainer parent) {
            super(parent);
            this.init();
        }

        public void setOperationName(String operationName) {
            this.operationNameTextField.setText(operationName);
        }

        public String getOperationName() {
            return this.operationNameTextField.getText();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.operationNameLabel.setEnabled(enabled);
            this.operationNameTextField.setEnabled(enabled);
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
            this.operationNameLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.OPERATION_NAME);
            this.add((UiComponent)this.operationNameLabel);
            this.operationNameTextField = new IdentifierTextField((UiContainer)this);
            this.add((UiComponent)this.operationNameTextField, "gapx 5, growx");
        }
    }
}

