/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.catcher;

import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.editor.AbstractConversationContinuatorEditor;
import oracle.bpm.designer.conversation.editor.catcher.ConversationCatcherContinuatorCatchDefinePanel;
import oracle.bpm.designer.conversation.editor.common.ConversationNotImplementedEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationProcessEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationServiceEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ConversationCatcherContinuatorPanel
extends AbstractConversationContinuatorEditor {
    public ConversationCatcherContinuatorPanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        super(parent, null, conversationalNode, selectedInitiator);
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor() {
        ProjectObjectEditorPanel result;
        ConversationEnabled initiator = this.getSelectedInitiator();
        ConversationEnabled node = (ConversationEnabled)this.getProjectObject();
        if (!ConversationHelper.hasImplementation((ConversationEnabled)initiator)) {
            result = new ConversationNotImplementedEditor((UiContainer)this, node, DesignerMsg.CONVERSATION_INITIATOR_NOT_IMPLEMENTED);
        } else if (ConversationHelper.isCatcher((ConversationEnabled)initiator)) {
            result = ConversationHelper.usesService((ConversationEnabled)initiator) ? new ConversationServiceEditor((UiContainer)this, (ParticipantEnabled)node, initiator.getParticipant()) : ConversationCatcherContinuatorCatchDefinePanel.create((UiContainer)this, node, initiator);
        } else if (ConversationHelper.usesProcess((ConversationEnabled)initiator)) {
            result = ConversationProcessEditor.createCatcherContinuesThrowerEditor((UiContainer)this, node, this.getSelectedInitiator());
        } else {
            InterfaceObject service = (InterfaceObject)initiator.getParticipant();
            InterfaceObject callbackService = service != null ? ConversationHelper.getCallbackInterface((InterfaceObject)service) : null;
            result = new ConversationServiceEditor((UiContainer)this, (ParticipantEnabled)node, (CatalogObject)callbackService);
        }
        return result;
    }
}

