/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation.editor.catcher;

import java.util.Locale;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ConversationOption;
import oracle.bpm.designer.conversation.ConversationOptionLabelProvider;
import oracle.bpm.designer.conversation.editor.common.ConversationDefinitionEditor;
import oracle.bpm.designer.conversation.editor.common.ConversationNotImplementedEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class ConversationCatcherContinuatorCatchDefinePanel
extends ComboBoxSelectorPanel<CatcherContinuatorCatchDefineOptions, ConversationEnabled> {
    private ConversationEnabled selectedInitiator;

    private ConversationCatcherContinuatorCatchDefinePanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        super(parent, DesignerMsg.PROPERTIES, conversationalNode, DesignerMsg.CONVERSATION_IMPLEMENTATION, 5);
        this.selectedInitiator = selectedInitiator;
        this.init();
    }

    public static ConversationCatcherContinuatorCatchDefinePanel create(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode, @NotNull ConversationEnabled selectedInitiator) {
        ConversationCatcherContinuatorCatchDefinePanel result = new ConversationCatcherContinuatorCatchDefinePanel(parent, conversationalNode, selectedInitiator);
        result.setLabelProvider(new ConversationOptionLabelProvider());
        return result;
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        if (conversationalNode != null) {
            CatcherContinuatorCatchDefineOptions option = null;
            if (!ConversationHelper.hasImplementation((ConversationEnabled)conversationalNode)) {
                option = CatcherContinuatorCatchDefineOptions.NOT_IMPLEMENTED;
            } else if (ConversationHelper.isDefiner((ConversationEnabled)conversationalNode)) {
                CatcherContinuatorCatchDefineOptions catcherContinuatorCatchDefineOptions = option = ConversationHelper.usesInitiatorOperation((ConversationEnabled)conversationalNode) ? CatcherContinuatorCatchDefineOptions.USE_INITIATOR : CatcherContinuatorCatchDefineOptions.DEFINE;
            }
            if (option != null) {
                this.setSelectedOption(option);
                this.getInnerEditor().objectToEditor(null);
            } else {
                MessageDialog.showNotice((Msg)DesignerMsg.CONVERSATION_INVALID_IMPLEMENTATION_NOTICE);
            }
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        ProjectObjectEditorPanel innerEditor = this.getInnerEditor();
        if (innerEditor != null) {
            innerEditor.editorToObject();
        }
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        this.getInnerEditor().validatePanel();
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor(@NotNull UiContainer container, @NotNull CatcherContinuatorCatchDefineOptions selectedItem) {
        ProjectObjectEditorPanel result = null;
        switch (selectedItem) {
            case USE_INITIATOR: {
                result = new ConversationDefinitionEditor(container, (ConversationEnabled)this.getProjectObject(), this.selectedInitiator);
                break;
            }
            case DEFINE: {
                result = new ConversationDefinitionEditor(container, (ConversationEnabled)this.getProjectObject());
                break;
            }
            case NOT_IMPLEMENTED: {
                result = new ConversationNotImplementedEditor(container, (ConversationEnabled)this.getProjectObject());
            }
        }
        return result;
    }

    private void init() {
        if (!ConversationHelper.mustImplement((ConversationEnabled)((ConversationEnabled)this.getProjectObject()))) {
            this.addOption(CatcherContinuatorCatchDefineOptions.USE_INITIATOR);
            this.addOption(CatcherContinuatorCatchDefineOptions.DEFINE);
        }
        this.addOption(CatcherContinuatorCatchDefineOptions.NOT_IMPLEMENTED);
        this.setSelectedOption(this.getOptions().iterator().next());
    }

    public static enum CatcherContinuatorCatchDefineOptions implements ConversationOption
    {
        DEFINE(DesignerMsg.DEFINE_INTERFACE),
        USE_INITIATOR(DesignerMsg.USE_INITIATOR_INTERFACE),
        NOT_IMPLEMENTED(DesignerMsg.NOT_IMPLEMENTED);

        private Msg msg;

        private CatcherContinuatorCatchDefineOptions(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }

        @Override
        public Image getIcon() {
            return Image.create((Msg)this.msg);
        }
    }
}

