/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.designer.conversation.ReferenceControl;
import oracle.bpm.draw.Color;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ReferenceComboBox<T>
extends ComboBox<T>
implements ReferenceControl<T> {
    private Object invalidItem;

    public ReferenceComboBox(@NotNull UiContainer parent) {
        super(parent, false);
        this.init();
    }

    public void setSelectedItem(Object object) {
        Object item;
        if (this.invalidItem != null) {
            this.removeItem(this.invalidItem);
        }
        if ((item = object) != null && !this.containsItem(item)) {
            this.addItem(item);
            this.invalidItem = item;
        }
        super.setSelectedItem(item);
    }

    @Override
    public boolean isValidSelection() {
        return this.getSelectedItem() == null || this.getSelectedItem() != this.invalidItem;
    }

    @Override
    public void setValue(T value) {
        this.setSelectedItem(value);
    }

    @Override
    public T getValue() {
        return (T)this.getSelectedItem();
    }

    private void init() {
        this.setColorProvider((ColorProvider)new ColorProvider.Default(){

            public Color getForeground(Object element) {
                return element != ReferenceComboBox.this.invalidItem ? ReferenceControl.VALID_COLOR : ReferenceControl.INVALID_COLOR;
            }
        });
        this.addModificationListener(new ModificationListener<ReferenceControl>(){

            @Override
            public void objectModified(ModificationEvent<ReferenceControl> referenceControlModificationEvent) {
                ReferenceComboBox.this.setForeground(ReferenceComboBox.this.getSelectedItem() != ReferenceComboBox.this.invalidItem ? ReferenceControl.VALID_COLOR : ReferenceControl.INVALID_COLOR);
                if (ReferenceComboBox.this.invalidItem != null && ReferenceComboBox.this.getSelectedItem() != ReferenceComboBox.this.invalidItem) {
                    ReferenceComboBox.this.removeItem(ReferenceComboBox.this.invalidItem);
                }
            }
        });
    }
}

