/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import java.util.ArrayList;
import oracle.bpm.designer.conversation.ReferenceControl;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectBrowser<E extends ProjectObject>
extends Panel
implements ReferenceControl<E> {
    private ProjectFilter filter;
    private LabelProvider<E> labelProvider;
    private ArrayList<ModificationListener> listeners = new ArrayList();
    private ProjectObjectContainer root;
    private boolean showRoot = false;
    private TextField textField;
    private E value;

    public ProjectObjectBrowser(@NotNull UiContainer parent, @NotNull ProjectFilter filter, @NotNull ProjectObjectContainer root) {
        super(parent);
        this.filter = filter;
        this.root = root;
        this.init();
    }

    @Override
    public void addModificationListener(@NotNull ModificationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModificationListener(@NotNull ModificationListener listener) {
        this.listeners.remove(listener);
    }

    public boolean showRoot() {
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
    }

    @Override
    public void setLabelProvider(LabelProvider<E> labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    public boolean isValidSelection() {
        return this.value == null || this.filter.getChildren(this.root).contains(this.value);
    }

    @Override
    public void setValue(E newValue) {
        E oldValue = this.value;
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.value = newValue;
        this.textField.setText(newValue != null ? this.getText(newValue) : "");
        this.textField.setForeground(this.isValidSelection() ? VALID_COLOR : INVALID_COLOR);
        this.fireSelectionChanged(oldValue, newValue);
    }

    @Override
    public E getValue() {
        return this.value;
    }

    private String getText(@NotNull E value) {
        return this.labelProvider != null ? this.labelProvider.getText(value) : value.getId();
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        this.textField = this.createTextField((UiContainer)this);
        this.add((UiComponent)this.textField, "growx");
        this.add((UiComponent)this.createBrowseButton((UiContainer)this));
        this.add((UiComponent)this.createResetButton((UiContainer)this));
    }

    private TextField createTextField(@NotNull UiContainer container) {
        TextField result = new TextField(container);
        result.setEditable(false);
        return result;
    }

    private Button createResetButton(UiContainer container) {
        Button result = Button.createIconic((UiContainer)container, (Msg)UIMsg.CLEAR);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectObjectBrowser.this.setValue(null);
            }
        });
        return result;
    }

    private Button createBrowseButton(UiContainer container) {
        Button result = Button.createBrowse((UiContainer)container);
        result.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectNavigatorBuilder builder = new ProjectNavigatorBuilder((ProjectObject)ProjectObjectBrowser.this.root, DesignerMsg.TYPE).filter(ProjectObjectBrowser.this.filter).initialSelection(ProjectObjectBrowser.this.value);
                builder = ProjectObjectBrowser.this.showRoot ? builder.showRoot() : builder.hideRoot();
                ProjectObject object = builder.selectSingle(ProjectObject.class);
                if (object != null) {
                    ProjectObjectBrowser.this.setValue(object);
                }
            }
        });
        return result;
    }

    private void fireSelectionChanged(E oldValue, E newValue) {
        for (ModificationListener listener : this.listeners) {
            listener.objectModified(new ModificationEvent<ProjectObjectBrowser>(this, oldValue, newValue));
        }
    }
}

