/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import java.util.Locale;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ContinuatorPanel;
import oracle.bpm.designer.conversation.editor.catcher.ConversationCatcherInitiatorPanel;
import oracle.bpm.designer.conversation.editor.thrower.ConversationThrowerInitiatorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.designer.selectorpanel.RadioButtonSelectorPanel;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ConversationPanel
extends RadioButtonSelectorPanel<ConversationOptions, ConversationEnabled> {
    public ConversationPanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        super(parent, DesignerMsg.CONVERSATION, conversationalNode, 5);
        this.init();
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        if (conversationalNode != null) {
            if (!this.isFixedSelection()) {
                ConversationOptions option = conversationalNode.isConversationInitiator() ? ConversationOptions.INITIATES : ConversationOptions.CONTINUES;
                this.setSelectedOption(option);
            }
            this.getInnerEditor().objectToEditor(null);
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        this.getInnerEditor().editorToObject();
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        this.getInnerEditor().validatePanel();
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor(@NotNull UiContainer container, @NotNull ConversationOptions selectedItem) {
        ComboBoxSelectorPanel result = null;
        switch (selectedItem) {
            case INITIATES: {
                result = ConversationHelper.isCatcher((ConversationEnabled)((ConversationEnabled)this.getProjectObject())) ? ConversationCatcherInitiatorPanel.create(container, (ConversationEnabled)this.getProjectObject()) : ConversationThrowerInitiatorPanel.create(container, (ConversationEnabled)this.getProjectObject());
                break;
            }
            case CONTINUES: {
                result = ContinuatorPanel.create(container, (ConversationEnabled)this.getProjectObject());
            }
        }
        return result;
    }

    private void init() {
        this.addOption(ConversationOptions.INITIATES);
        this.addOption(ConversationOptions.CONTINUES);
        if (this.isFixedSelection()) {
            this.setSelectorEnabled(false);
            this.setSelectedOption(StartEvent.class.isAssignableFrom(((ConversationEnabled)this.getProjectObject()).getRawClass()) ? ConversationOptions.INITIATES : ConversationOptions.CONTINUES);
        } else {
            this.setSelectedOption(ConversationOptions.INITIATES);
        }
    }

    private boolean isFixedSelection() {
        return EndEvent.class.isAssignableFrom(((ConversationEnabled)this.getProjectObject()).getRawClass()) || StartEvent.class.isAssignableFrom(((ConversationEnabled)this.getProjectObject()).getRawClass()) && Process.class.isAssignableFrom(((ConversationEnabled)this.getProjectObject()).getParentObject().getRawClass());
    }

    public static enum ConversationOptions implements I18nProvider
    {
        INITIATES(DesignerMsg.INITIATES),
        CONTINUES(DesignerMsg.CONTINUES);

        private Msg msg;

        private ConversationOptions(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }
    }
}

