/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.conversation;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.editor.catcher.ConversationCatcherContinuatorPanel;
import oracle.bpm.designer.conversation.editor.thrower.ConversationThrowerContinuatorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

class ContinuatorPanel
extends ComboBoxSelectorPanel<ConversationEnabled, ConversationEnabled> {
    private ContinuatorPanel(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        super(parent, null, conversationalNode, DesignerMsg.INITIATOR_NODE);
        this.init();
    }

    public static ContinuatorPanel create(@NotNull UiContainer parent, @NotNull ConversationEnabled conversationalNode) {
        ContinuatorPanel result = new ContinuatorPanel(parent, conversationalNode);
        result.setLabelProvider(new LabelProvider<ConversationEnabled>(){

            public Image getIcon(ConversationEnabled element) {
                return ProjectObjectRenderer.Default.getIcon((ProjectObject)element);
            }

            public String getText(ConversationEnabled element) {
                return ProjectObjectRenderer.Default.getLabel((ProjectObject)element);
            }
        });
        return result;
    }

    @Override
    public void objectToEditor(ConversationEnabled projectObject) {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        if (conversationalNode != null) {
            ConversationEnabled initiator = ((ConversationEnabled)this.getProjectObject()).getConversationInitiator();
            this.setSelectedOption(initiator);
            ProjectObjectEditorPanel innerEditor = this.getInnerEditor();
            if (innerEditor != null) {
                innerEditor.objectToEditor(null);
            }
        }
    }

    @Override
    public ConversationEnabled editorToObject() throws ProjectException {
        ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
        conversationalNode.setConversationInitiator((ConversationEnabled)this.getSelectedOption());
        if (this.getInnerEditor() != null) {
            this.getInnerEditor().editorToObject();
        }
        return conversationalNode;
    }

    @Override
    public void validatePanel() throws ProjectException {
        Object projectObject = this.getProjectObject();
        if (this.getSelectedOption() == null || !this.isValidSelection()) {
            throw new ProjectException(projectObject, DesignerMsg.INVALID_INITIATOR);
        }
        this.getInnerEditor().validatePanel();
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor(@NotNull UiContainer container, @NotNull ConversationEnabled selectedItem) {
        return ConversationHelper.isCatcher((ConversationEnabled)((ConversationEnabled)this.getProjectObject())) ? new ConversationCatcherContinuatorPanel(container, (ConversationEnabled)this.getProjectObject(), selectedItem) : new ConversationThrowerContinuatorPanel(container, (ConversationEnabled)this.getProjectObject(), selectedItem);
    }

    private void init() {
        Sequence initiators = ConversationHelper.getPossibleInitiators((ConversationEnabled)((ConversationEnabled)this.getProjectObject()));
        for (ConversationEnabled initiator : initiators) {
            this.addOption(initiator);
        }
    }
}

