/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.capability.add.ContainerAddMeasurementCapability;
import oracle.bpm.designer.capability.add.ContainerAddingSequenceFlowCapability;
import oracle.bpm.designer.capability.add.SubprocessAddNodeCapability;
import oracle.bpm.designer.capability.drag.NodeMoveCapability;
import oracle.bpm.designer.capability.edit.ElementEditCapability;
import oracle.bpm.designer.capability.selection.ElementPopUpCapability;
import oracle.bpm.designer.capability.selection.ElementSelectionCapability;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.ConnectionController;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.FlowNodeControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.NodeContainerControllerImpl;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.subcontroller.ExpandCollapseSubcontroller;
import oracle.bpm.designer.subcontroller.HighlightContainerSubcontroller;
import oracle.bpm.designer.subcontroller.LoopCharacteristicSubcontroller;
import oracle.bpm.designer.subcontroller.SubprocessResizeSubcontroller;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubprocessController
extends NodeContainerControllerImpl<Subprocess>
implements FlowNodeController<Subprocess> {
    private final ActivityController.ToBoundaryControllerMapper boundaryMapper;
    private final FlowNodeControllerImpl.ToConnectionControllerMapper connectionMapper;

    protected SubprocessController(@NotNull NodeContainerController container, @NotNull DrawableSubprocess drawable) {
        super((Controller)container, drawable);
        this.install(new ElementEditCapability(this));
        this.install(new ElementPopUpCapability(this));
        this.install(new ElementSelectionCapability(this));
        this.install(new NodeMoveCapability(this));
        this.install(new SubprocessAddNodeCapability(this));
        this.install(new ContainerAddMeasurementCapability(this));
        this.install(new ContainerAddingSequenceFlowCapability(this));
        SubprocessResizeSubcontroller.appendTo(this);
        ExpandCollapseSubcontroller.appendTo(this);
        LoopCharacteristicSubcontroller.appendTo(this);
        HighlightContainerSubcontroller.appendTo(this);
        this.connectionMapper = new FlowNodeControllerImpl.ToConnectionControllerMapper(container);
        this.boundaryMapper = new ActivityController.ToBoundaryControllerMapper(container);
    }

    @Override
    @NotNull
    public NodeContainerController getContainer() {
        return (NodeContainerController)super.getContainer();
    }

    @Override
    @NotNull
    public DrawableFlowNode<Subprocess> getDrawableNode() {
        return (DrawableFlowNode)this.getDrawableObject();
    }

    @Override
    public void editProperties() {
        FlowNodePropertiesDialog.editProperties((FlowNode)this.getModelObject());
    }

    @Override
    @NotNull
    public Sequence<ConnectionController> getOutgoingConnections() {
        return ((Subprocess)this.getModelObject()).getOutgoingSequenceFlows().map(this.connectionMapper);
    }

    @Override
    @NotNull
    public Sequence<ConnectionController> getIncomingConnections() {
        return ((Subprocess)this.getModelObject()).getIncomingSequenceFlows().map(this.connectionMapper);
    }

    @Override
    protected void refreshDrawable(@Nullable ProjectEvent event) {
        super.refreshDrawable(event);
        for (ConnectionController connectionController : this.getIncomingConnections()) {
            connectionController.refresh();
        }
        for (ConnectionController connectionController : this.getOutgoingConnections()) {
            connectionController.refresh();
        }
        for (Controller controller : this.getBoundaryControllers()) {
            controller.refresh();
        }
    }

    @NotNull
    private Sequence<Controller> getBoundaryControllers() {
        return ((Subprocess)this.getModelObject()).getActivityBoundaryEvents().map(this.boundaryMapper);
    }
}

