/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.BpmnControllerFactory;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.ControllerFactory;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.controller.RootController;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.DesignerLayer;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableRoot;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.ui.PaintCanvas;
import org.jetbrains.annotations.NotNull;

public class SingleProcessRootController
extends RootController {
    private ProcessController single;

    private SingleProcessRootController(@NotNull ProcessDomain domain, @NotNull DrawableRoot drawable) {
        super(domain, drawable);
    }

    public static SingleProcessRootController create(@NotNull PaintCanvas canvas, @NotNull ProcessDomain domain) {
        DrawableSingleProcessRoot drawable = DrawableSingleProcessRoot.create((PaintCanvas)canvas);
        SingleProcessRootController controller = new SingleProcessRootController(domain, (DrawableRoot)drawable);
        controller.refresh();
        return controller;
    }

    @Override
    @NotNull
    public ProcessDomain getDomain() {
        return (ProcessDomain)super.getDomain();
    }

    public DrawableSingleProcessRoot getDrawableRoot() {
        return (DrawableSingleProcessRoot)this.getDrawableObject();
    }

    @Override
    public void addChild(@NotNull Controller controller) {
        if (controller.getDrawableObject().getLayer().equals((Object)DesignerLayer.PROCESS)) {
            this.single = (ProcessController)controller;
        }
        super.addChild(controller);
    }

    @Override
    public void removeChild(@NotNull Controller controller) {
        if (controller.getDrawableObject().getLayer().equals((Object)DesignerLayer.PROCESS) && controller.equals(this.single)) {
            this.single = null;
        }
        super.removeChild(controller);
    }

    @Override
    public void refresh() {
        ProcessDomain domain = this.getDomain();
        BpmnDrawableFactory drawableFactory = domain.getDrawableFactory();
        BpmnControllerFactory controllerFactory = domain.getControllerFactory();
        Drawable drawableProcess = drawableFactory.create(this.getDrawableObject(), (Object)domain.getDomainElement());
        Controller processController = ((ControllerFactory)controllerFactory).create(this, drawableProcess);
        processController.refresh();
        processController.add();
    }

    @NotNull
    public ProcessController getSingleProcess() {
        if (this.single == null) {
            throw new IllegalStateException("Oooooops!! It's an empty root! No process attached!\n ProcessController in Root hasn't been initialized!");
        }
        return this.single;
    }
}

