/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import java.awt.geom.Point2D;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BaseTransitionPropertiesDialog;
import oracle.bpm.designer.SequenceFlowPropertiesDialog;
import oracle.bpm.designer.controller.ConnectionController;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.subcontroller.AnchorSubcontroller;
import oracle.bpm.designer.subcontroller.HighlightConnectionSubcontroller;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.TransitionMessageType;
import oracle.bpm.geom.Ellipse;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequenceFlowController
extends FlowElementControllerImpl<SequenceFlow>
implements ConnectionController<SequenceFlow> {
    private int simulationNextPercentage = -1;
    private static final Image SIM_BALL_IMAGE = Image.create((Msg)DesignerMsg.SIMULATION_BALL);

    protected SequenceFlowController(@NotNull NodeContainerController<?> container, @NotNull DrawableSequenceFlow drawable) {
        super((Controller)container, drawable);
        AnchorSubcontroller.appendTo(this, DrawableHelper.TransitionAnchor.MIDDLE);
        AnchorSubcontroller.appendTo(this, DrawableHelper.TransitionAnchor.FROM);
        AnchorSubcontroller.appendTo(this, DrawableHelper.TransitionAnchor.TO);
        HighlightConnectionSubcontroller.appendTo(this);
    }

    @Override
    @NotNull
    public NodeContainerController getContainer() {
        return (NodeContainerController)super.getContainer();
    }

    @NotNull
    public DrawableSequenceFlow getDrawableObject() {
        return (DrawableSequenceFlow)super.getDrawableObject();
    }

    @NotNull
    public final DrawableNodeContainer<?> getDrawableContainer() {
        return this.getDrawableObject().getContainer();
    }

    @Override
    public String getTooltipMessage() {
        return this.getMessageToShow();
    }

    @Override
    public void drawSimulation(Graphics graphics) {
        DrawContext context = this.getDomain().getDrawContext();
        if (this.getDrawableObject().isHidden(context)) {
            return;
        }
        if (!AbstractStudioWorkbench.getInstance().isSimulating()) {
            return;
        }
        if (!this.getDomain().isShowAnimation() || this.simulationNextPercentage > 100 || this.simulationNextPercentage < 0) {
            return;
        }
        double perc = (double)this.simulationNextPercentage / 100.0;
        if (perc <= 0.0 || perc >= 100.0) {
            return;
        }
        Point2D p = this.getDrawableObject().getPathPoint(perc);
        double scale = context.getScale();
        double x = p.getX();
        double y = p.getY();
        double simBallWidth = SIM_BALL_IMAGE.getWidth();
        double simBallHeight = SIM_BALL_IMAGE.getHeight();
        double ballX = x - simBallWidth / 2.0;
        double ballY = y - simBallHeight / 2.0;
        Ellipse ellipse = new Ellipse((int)ballX, (int)ballY, (int)simBallWidth, (int)simBallHeight);
        Rectangle bounds = ellipse.getBounds();
        if (this.getDrawableObject().getDrawableSource().intersects(bounds, context) || this.getDrawableObject().getDrawableTarget().intersects(bounds, context)) {
            return;
        }
        int scaledX = (int)(ballX * scale);
        int scaledY = (int)(ballY * scale);
        int scaledWidth = (int)(simBallWidth * scale);
        int scaledHeight = (int)(simBallHeight * scale);
        graphics.drawImage(SIM_BALL_IMAGE, scaledX, scaledY, scaledWidth, scaledHeight, (UiComponent)this.getDomain().getCanvas());
    }

    @Override
    public void editProperties() {
        BaseTransitionPropertiesDialog dialog = SequenceFlowPropertiesDialog.createDialog((SequenceFlow)this.getModelObject());
        dialog.setVisible(true);
        boolean accepted = dialog.userAccepted();
        if (!accepted) {
            this.getDomain().getSelectionProvider().clear();
        }
        this.getDomain().getCanvas().repaint();
    }

    public void resetSimulation() {
        this.simulationNextPercentage = -1;
    }

    @Override
    public String toString() {
        return this.getSequenceFlowImpl().getBuiltName();
    }

    public void setSimulationNextPercentage(int step) {
        this.simulationNextPercentage = step;
    }

    @Override
    @Nullable
    public Controller getSourceController() {
        return this.asController(this.getDrawableObject().getDrawableSource());
    }

    @Override
    @Nullable
    public Controller getTargetController() {
        return this.asController(this.getDrawableObject().getDrawableTarget());
    }

    private String getMessageToShow() {
        DrawContext context = this.getDrawContext();
        return this.useEmptyText(context.getTransitionMessageType()) ? " " : this.getDrawableObject().getShortMessage(context).trim();
    }

    private boolean useEmptyText(TransitionMessageType currentType) {
        return currentType == TransitionMessageType.DESCRIPTION || currentType == TransitionMessageType.NONE;
    }

    private SequenceFlowImpl getSequenceFlowImpl() {
        return (SequenceFlowImpl)this.getModelObject();
    }

    @Nullable
    private Controller asController(@Nullable Drawable drawable) {
        return drawable != null ? this.getContainer().getControllerFor(drawable) : null;
    }
}

