/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.designer.capability.drag.NoteMoveCapability;
import oracle.bpm.designer.capability.edit.ElementEditCapability;
import oracle.bpm.designer.capability.selection.ElementPopUpCapability;
import oracle.bpm.designer.capability.selection.ElementSelectionCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.subcontroller.NoteResizeSubcontroller;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableNote;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.KeyAdapter;
import oracle.bpm.ui.event.KeyEvent;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.text.TextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoteController
extends FlowElementControllerImpl<TextAnnotation> {
    private TextArea area;
    private FocusAdapter focusListener;
    private Font font;
    private boolean isEditing;
    private KeyListener keyListener;

    protected NoteController(@NotNull NodeContainerController<?> container, @NotNull DrawableNote drawableObject) {
        super((Controller)container, drawableObject);
        this.install(new NoteMoveCapability(this));
        this.install(new ElementSelectionCapability(this));
        this.install(new ElementPopUpCapability(this));
        this.install(new ElementEditCapability(this));
        NoteResizeSubcontroller.appendTo(this);
    }

    @Override
    public void editProperties() {
        this.startEditing();
    }

    public void stopEditing() {
        if (this.isEditing()) {
            String newText = this.getUITextArea().getText();
            String oldText = ((TextAnnotation)this.getModelObject()).getDefaultLabel();
            if (oldText == null || !oldText.equals(newText)) {
                ((TextAnnotation)this.getModelObject()).setDefaultLabel(newText);
            }
            this.getUITextArea().setVisible(false);
            this.setEditing(false);
        }
    }

    @Override
    protected void refreshDrawable(@Nullable ProjectEvent event) {
        super.refreshDrawable(event);
        if (event != null && "associatedNode".equals(event.getPropertyName())) {
            this.getDomain().getCanvas().repaint();
        }
    }

    private void startEditing() {
        if (!this.isEditing()) {
            TextArea area = this.getUITextArea();
            DrawContext context = this.getDrawContext();
            Rectangle bounds = context.scaleAndInvert(this.getDrawableObject().getBounds(context));
            area.setText(((TextAnnotation)this.getModelObject()).getDefaultLabel());
            Insets crop = DrawableNote.TEXT_AREA_CROP.scaled(context.getScale());
            area.setBounds(bounds.shrink(crop));
            area.setFont(this.font.scale(context.getScale()));
            area.setForeground(Color.BLACK);
            area.selectAll();
            area.setVisible(true);
            area.setFocusable(true);
            area.requestFocus();
            this.setEditing(true);
            this.getCanvas().repaint();
        }
    }

    private TextArea getUITextArea() {
        if (this.area == null) {
            this.area = new TextArea((UiContainer)this.getCanvas(), ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
            this.area.setOpaque(false);
            this.area.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
            this.getCanvas().add((UiComponent)this.area);
            this.addListeners();
            this.font = this.area.getFont();
        }
        return this.area;
    }

    private PaintCanvas getCanvas() {
        return this.getDomain().getCanvas();
    }

    private void addListeners() {
        if (this.focusListener == null) {
            this.focusListener = new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    NoteController.this.stopEditing();
                    NoteController.this.getCanvas().repaint();
                }
            };
            this.area.addFocusListener((FocusListener)this.focusListener);
        }
        if (this.keyListener == null) {
            this.keyListener = new KeyAdapter(){

                public void keyReleased(KeyEvent event) {
                    if (event.isEscape()) {
                        NoteController.this.stopEditing();
                        NoteController.this.getCanvas().repaint();
                    }
                }
            };
            this.area.addKeyListener(this.keyListener);
        }
    }

    private boolean isEditing() {
        return this.isEditing;
    }

    private void setEditing(boolean editing) {
        this.isEditing = editing;
    }
}

