/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.controller;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.action.LanePropertiesAction;
import oracle.bpm.designer.capability.drag.LaneMoveCapability;
import oracle.bpm.designer.capability.edit.ElementEditCapability;
import oracle.bpm.designer.capability.selection.ElementPopUpCapability;
import oracle.bpm.designer.capability.selection.ElementSelectionCapability;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementControllerImpl;
import oracle.bpm.designer.controller.LaneColumnController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.subcontroller.HighlightSubcontroller;
import oracle.bpm.draw.DrawableLane;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.ui.Utilities;
import org.jetbrains.annotations.NotNull;

public class LaneController
extends FlowElementControllerImpl<LaneImpl> {
    private final LaneColumnController columnController = new LaneColumnController(this);

    protected LaneController(@NotNull NodeContainerController<?> container, @NotNull DrawableLane drawableObject) {
        super((Controller)container, drawableObject);
        this.install(new LaneMoveCapability(this));
        this.install(new ElementEditCapability(this));
        this.install(new ElementSelectionCapability(this));
        this.install(new ElementPopUpCapability(this));
        HighlightSubcontroller.appendTo(this);
    }

    public String getMessage() {
        String message = this.getDrawableLane().getDisplayName();
        message = Utilities.strechAndCutText((String)message, (int)5, (int)150);
        return message.trim();
    }

    public void setParameterName(String name) {
        if (!this.sameParameterName(name)) {
            ((LaneImpl)this.getModelObject()).asMutable().setParamName(name);
            Sequence lanes = ((LaneImpl)this.getModelObject()).getProcess().getLanes();
            if (((LaneImpl)this.getModelObject()).isParametric()) {
                for (Lane lane : lanes) {
                    LaneController r = (LaneController)lane;
                    if (r == this || !((LaneImpl)r.getModelObject()).getId().equals(((LaneImpl)this.getModelObject()).getId())) continue;
                    r.setParameterName(((LaneImpl)this.getModelObject()).getParamName());
                }
            }
        }
    }

    @Override
    public String getTooltipMessage() {
        return this.getMessage();
    }

    @Override
    public void editProperties() {
        LanePropertiesAction.getInstance().runWithSelection(this.getModelObject());
    }

    @Override
    public void add() {
        super.add();
        this.getLaneColumnController().add();
    }

    protected DrawableLane getDrawableLane() {
        return (DrawableLane)this.getDrawableObject();
    }

    LaneColumnController getLaneColumnController() {
        return this.columnController;
    }

    private boolean sameParameterName(String name) {
        String paramName = ((LaneImpl)this.getModelObject()).getParamName();
        return paramName != null && paramName.equals(name);
    }
}

